/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanFaultHelperWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanFaultWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanHelperWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaEnumTypeWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.JavaHolderWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaWriter;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import java.io.IOException;

public class JavaTypeWriter
implements Generator {
    protected Emitter emitter;
    private Generator typeWriter = null;
    private Generator holderWriter = null;
    private Generator helperWriter = null;
    private boolean isDeploy = false;

    public JavaTypeWriter(Emitter emitter, TypeEntry typeEntry, SymbolTable symbolTable) {
        this.emitter = emitter;
        if (this.holderIsNeeded(typeEntry)) {
            this.holderWriter = this.getHolderWriter(emitter, typeEntry);
        }
        if (this.disableGeneration(typeEntry)) {
            return;
        }
        if (typeEntry instanceof Type && !typeEntry.getName().endsWith("[]")) {
            Type type = (Type)typeEntry;
            if (type.isEnumeration()) {
                this.typeWriter = this.getEnumTypeWriter(emitter, type);
            } else {
                this.typeWriter = this.getBeanWriter(emitter, type);
                this.helperWriter = this.getBeanHelperWriter(emitter, type);
            }
        }
    }

    public boolean isDeployPhaseOnlyWriter() {
        return this.isDeploy;
    }

    public void setDeployPhaseOnly(boolean deployOnly) {
        this.isDeploy = deployOnly;
    }

    public void generate() throws IOException {
        if (this.emitter.getGenJava() != GenCriteria.NO) {
            if (this.typeWriter != null) {
                this.typeWriter.generate();
            }
            if (this.holderWriter != null) {
                this.holderWriter.generate();
            }
            if (this.helperWriter != null) {
                this.helperWriter.generate();
            }
        }
    }

    private boolean holderIsNeeded(SymTabEntry entry) {
        boolean hasHolderName = entry.getDynamicVar("HolderName") != null;
        Boolean disableHolderGeneration = (Boolean)entry.getDynamicVar("DisableHolderGeneration");
        return hasHolderName && disableHolderGeneration != Boolean.TRUE;
    }

    protected JavaWriter getEnumTypeWriter(Emitter emitter, Type type) {
        if (emitter.getRole() == Role.CLIENT || emitter.getRole() == Role.SERVER || emitter.getRole() == Role.DEVELOP_CLIENT || emitter.getRole() == Role.DEVELOP_SERVER) {
            return new JavaEnumTypeWriter(emitter, type);
        }
        return null;
    }

    protected JavaWriter getBeanWriter(Emitter emitter, Type type) {
        if (emitter.getRole() == Role.CLIENT || emitter.getRole() == Role.SERVER || emitter.getRole() == Role.DEVELOP_CLIENT || emitter.getRole() == Role.DEVELOP_SERVER) {
            Boolean isComplexFault = (Boolean)type.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
            if (isComplexFault != null && isComplexFault.booleanValue()) {
                return new JavaBeanFaultWriter(emitter, type);
            }
            return new JavaBeanWriter(emitter, type);
        }
        return null;
    }

    protected JavaWriter getBeanHelperWriter(Emitter emitter, Type type) {
        if (emitter.getRole() == Role.CLIENT || emitter.getRole() == Role.SERVER || emitter.getRole() == Role.DEPLOY_CLIENT || emitter.getRole() == Role.DEPLOY_SERVER) {
            Boolean isComplexFault = (Boolean)type.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
            if (isComplexFault != null && isComplexFault.booleanValue()) {
                return new JavaBeanFaultHelperWriter(emitter, type);
            }
            return new JavaBeanHelperWriter(emitter, type);
        }
        return null;
    }

    protected Generator getHolderWriter(Emitter emitter, TypeEntry type) {
        if (emitter.getRole() == Role.CLIENT || emitter.getRole() == Role.SERVER || emitter.getRole() == Role.DEVELOP_CLIENT || emitter.getRole() == Role.DEVELOP_SERVER) {
            return new JavaHolderWriter(emitter, type);
        }
        return null;
    }

    private boolean disableGeneration(TypeEntry typeEntry) {
        Boolean value2 = (Boolean)typeEntry.getDynamicVar("disable generation");
        return value2 != null && value2 == true;
    }
}

