/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Container;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.JavaEJBHomeWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaEJBImplWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaEJBRIWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaImplWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaInterfaceWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import javax.wsdl.Binding;

public class JavaBindingWriter
implements Generator {
    protected Generator stubWriter = null;
    protected Generator implWriter = null;
    protected Generator interfaceWriter = null;
    protected Emitter emitter;
    protected Binding binding;
    protected SymbolTable symbolTable;
    protected JavaEJBRIWriter ejbRIWriter = null;
    protected JavaEJBHomeWriter ejbHomeWriter = null;
    private boolean isDeploy = false;

    public JavaBindingWriter(Emitter emitter, Binding binding, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.binding = binding;
        this.symbolTable = symbolTable;
    }

    public boolean isDeployPhaseOnlyWriter() {
        return this.isDeploy;
    }

    public void setDeployPhaseOnly(boolean deployOnly) {
        this.isDeploy = deployOnly;
    }

    protected Generator getJavaInterfaceWriter(Emitter emitter, PortTypeEntry ptEntry, BindingEntry bEntry, SymbolTable st) {
        if ((emitter.getRole() == Role.SERVER || emitter.getRole() == Role.DEVELOP_SERVER) && emitter.getContainer() == Container.EJB) {
            this.ejbRIWriter = new JavaEJBRIWriter(emitter, ptEntry, bEntry, st);
            this.ejbHomeWriter = new JavaEJBHomeWriter(emitter, ptEntry, bEntry, st);
        }
        return new JavaInterfaceWriter(emitter, ptEntry, bEntry, st);
    }

    protected Generator getJavaStubWriter(Emitter emitter, BindingEntry bEntry, SymbolTable st) {
        StubGenerator generator = null;
        Binding binding = bEntry.getBinding();
        String bindingNamespace = (String)bEntry.getDynamicVar(BindingEntry.BINDING_NAMESPACE);
        if (bindingNamespace == null) {
            emitter.getToolEnv().reportWarning(Messages.getMessage("w2j.UnsupportedBindingWarning", bEntry.getNonSupportedBindingNS()));
        } else {
            ServiceProviderManager spm = new ServiceProviderManager();
            ServiceProvider serviceProvider = spm.getServiceProvider(bindingNamespace);
            if (serviceProvider != null) {
                generator = serviceProvider.getStubGenerator(emitter, bEntry, st);
            } else if (serviceProvider == null && bindingNamespace.equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
                emitter.getToolEnv().reportWarning(Messages.getMessage("w2j.NoStubWriterWarn"));
                generator = new JavaStubWriter(emitter, bEntry, st);
            }
        }
        return generator;
    }

    protected Generator getJavaImplWriter(Emitter emitter, BindingEntry bEntry, SymbolTable st) {
        if (emitter.getContainer() == Container.EJB) {
            return new JavaEJBImplWriter(emitter, bEntry, st);
        }
        return new JavaImplWriter(emitter, bEntry, st);
    }

    public void generate() throws IOException {
        if (this.emitter.getGenJava() != GenCriteria.NO) {
            this.setGenerators();
            if (this.interfaceWriter != null) {
                this.interfaceWriter.generate();
            }
            if (this.stubWriter != null) {
                this.stubWriter.generate();
            }
            if (this.implWriter != null) {
                this.implWriter.generate();
            }
            if (this.ejbRIWriter != null) {
                this.ejbRIWriter.generate();
            }
            if (this.ejbHomeWriter != null) {
                this.ejbHomeWriter.generate();
            }
        }
    }

    protected void setGenerators() {
        BindingEntry bEntry = this.symbolTable.getBindingEntry(this.binding.getQName());
        PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(this.binding.getPortType().getQName());
        if (ptEntry.isReferenced()) {
            this.interfaceWriter = this.getJavaInterfaceWriter(this.emitter, ptEntry, bEntry, this.symbolTable);
        }
        if (bEntry.isReferenced() && (bEntry.getBindingType() == 0 || bEntry.getBindingType() == 4)) {
            if (this.emitter.getRole() == Role.CLIENT || this.emitter.getRole() == Role.DEPLOY_CLIENT) {
                this.stubWriter = this.getJavaStubWriter(this.emitter, bEntry, this.symbolTable);
                if (this.stubWriter != null) {
                    this.stubWriter.setDeployPhaseOnly(true);
                }
            }
            if (this.emitter.getRole() == Role.SERVER || this.emitter.getRole() == Role.DEVELOP_SERVER) {
                String fileName = Utils.getJavaLocalName(bEntry.getName()) + "Impl.java";
                String packageName = this.emitter.getNamespaces().getAsDir(this.binding.getQName().getNamespaceURI());
                String fullName = packageName + fileName;
                if (Utils.fileShouldBeWritten(fullName, this.emitter.getToolEnv(), this.emitter.getGenJava(), false)) {
                    this.implWriter = this.getJavaImplWriter(this.emitter, bEntry, this.symbolTable);
                }
            }
        }
    }
}

