/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanBaseWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanDeserializerWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanSerializerWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.namespace.QName;

public class JavaBeanHelperWriter
extends JavaBeanBaseWriter {
    protected JavaWriter serWriter = null;
    protected JavaWriter deserWriter = null;

    protected JavaBeanHelperWriter(Emitter emitter, Type type) {
        super(emitter, type, type.getName() + "_Helper", "helper");
        this.serWriter = new JavaBeanSerializerWriter(emitter, type);
        this.deserWriter = new JavaBeanDeserializerWriter(emitter, type);
        this.setDeployPhaseOnly(true);
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.writeMetaData(pw);
        this.writeSerializer(pw);
        this.writeDeserializer(pw);
    }

    protected void writeMetaData(PrintWriter pw) throws IOException {
        pw.println("    // " + Messages.getMessage("typeMeta"));
        pw.println("    private static final com.ibm.ws.webservices.engine.description.TypeDesc typeDesc =");
        pw.println("        new com.ibm.ws.webservices.engine.description.TypeDesc(" + Utils.getJavaLocalName(this.type.getName()) + ".class);");
        pw.println();
        pw.println("    static {");
        pw.println("        typeDesc.setOption(\"buildNum\",\"" + Version.getRawBuildNum() + "\");");
        if (this.attributes != null || this.elements != null) {
            int i;
            boolean wroteFieldType = false;
            if (this.attributes != null) {
                for (i = 0; i < this.attributes.size(); ++i) {
                    ChildAttribute attr = (ChildAttribute)this.attributes.get(i);
                    TypeEntry te = attr.getType();
                    String fieldName = attr.getName();
                    QName attrXmlType = te.getQName();
                    pw.print("        ");
                    if (!wroteFieldType) {
                        pw.print("com.ibm.ws.webservices.engine.description.FieldDesc ");
                        wroteFieldType = true;
                    }
                    pw.println("field = new com.ibm.ws.webservices.engine.description.AttributeDesc();");
                    pw.println("        field.setFieldName(\"" + fieldName + "\");");
                    pw.println("        field.setXmlName(" + Utils.getNewQName(attr.getQName()) + ");");
                    if (attrXmlType != null) {
                        pw.println("        field.setXmlType(" + Utils.getNewQName(attrXmlType) + ");");
                    }
                    pw.println("        typeDesc.addFieldDesc(field);");
                }
            }
            if (this.elements != null) {
                for (i = 0; i < this.elements.size(); ++i) {
                    ChildElement elem = (ChildElement)this.elements.elementAt(i);
                    String fieldName = elem.getName();
                    QName xmlName = elem.getQName();
                    QName xmlType = Utils.getXSIType(elem.getType());
                    if (xmlType != null && xmlType.getLocalPart().indexOf("[") > 0) {
                        xmlType = null;
                    }
                    pw.print("        ");
                    if (!wroteFieldType) {
                        pw.print("com.ibm.ws.webservices.engine.description.FieldDesc ");
                        wroteFieldType = true;
                    }
                    pw.println("field = new com.ibm.ws.webservices.engine.description.ElementDesc();");
                    pw.println("        field.setFieldName(\"" + fieldName + "\");");
                    pw.println("        field.setXmlName(" + Utils.getNewQName(xmlName) + ");");
                    if (xmlType != null) {
                        pw.println("        field.setXmlType(" + Utils.getNewQName(xmlType) + ");");
                    }
                    if (elem.getMinOccursIs0()) {
                        pw.println("        field.setMinOccursIs0(true);");
                    }
                    if (elem.getMaxOccurs()) {
                        pw.println("        field.setMaxOccurs(true);");
                    }
                    pw.println("        typeDesc.addFieldDesc(field);");
                }
            }
        }
        pw.println("    };");
        pw.println();
        pw.println("    /**");
        pw.println("     * " + Messages.getMessage("returnTypeMeta"));
        pw.println("     */");
        pw.println("    public static com.ibm.ws.webservices.engine.description.TypeDesc getTypeDesc() {");
        pw.println("        return typeDesc;");
        pw.println("    }");
        pw.println();
    }

    protected void writeSerializer(PrintWriter pw) throws IOException {
        String ser = this.getClassName().substring(0, this.getClassName().lastIndexOf("_Helper")) + "_Ser";
        pw.println("    /**");
        pw.println("     * Get Custom Serializer");
        pw.println("     */");
        pw.println("    public static com.ibm.ws.webservices.engine.encoding.Serializer getSerializer(");
        pw.println("           java.lang.String mechType, ");
        pw.println("           java.lang.Class javaType,  ");
        pw.println("           javax.xml.namespace.QName xmlType) {");
        pw.println("        return ");
        pw.println("          new " + ser + "(");
        pw.println("            javaType, xmlType, typeDesc);");
        pw.println("    };");
        pw.println();
        if (ser != null) {
            this.serWriter.generate();
        }
    }

    protected void writeDeserializer(PrintWriter pw) throws IOException {
        String deser = this.getClassName().substring(0, this.getClassName().lastIndexOf("_Helper")) + "_Deser";
        pw.println("    /**");
        pw.println("     * Get Custom Deserializer");
        pw.println("     */");
        pw.println("    public static com.ibm.ws.webservices.engine.encoding.Deserializer getDeserializer(");
        pw.println("           java.lang.String mechType, ");
        pw.println("           java.lang.Class javaType,  ");
        pw.println("           javax.xml.namespace.QName xmlType) {");
        pw.println("        return ");
        pw.println("          new " + deser + "(");
        pw.println("            javaType, xmlType, typeDesc);");
        pw.println("    };");
        pw.println();
        if (deser != null) {
            this.deserWriter.generate();
        }
    }
}

