/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.query;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.Namespaces;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;

public class ImportResolverDelegate
implements ImportResolver {
    private Emitter emitter;
    private boolean lookForResolver = true;
    private ImportResolver resolver = null;
    protected static Log log = LogFactory.getLog(ImportResolverDelegate.class.getName());

    public ImportResolverDelegate(Emitter emitter) {
        this.emitter = emitter;
    }

    public InputStream resolve(String location) {
        if (this.lookForResolver) {
            this.lookForResolver();
        }
        if (this.resolver != null) {
            return this.resolver.resolve(location);
        }
        return null;
    }

    private void lookForResolver() {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug("ImportResolverDelegate.lookForResolver() > Entry");
            }
            this.lookForResolver = false;
            try {
                if (this.emitter.getSymbolTable() != null && this.emitter.getSymbolTable().getDefinition() != null && this.emitter.getSymbolTable().getDefinition().getTargetNamespace() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Will use the WSDL to find the _AbsoluteImportResolver class");
                    }
                    String targetNamespace = this.emitter.getSymbolTable().getDefinition().getTargetNamespace();
                    Namespaces namespaces = this.emitter.getNamespaces();
                    String packageName = namespaces.getCreate(targetNamespace);
                    Class resolverClass = ClassUtils.forName(packageName + "._AbsoluteImportResolver");
                    this.resolver = (ImportResolver)resolverClass.newInstance();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("A WSDL is not available, so will try to find _AbsoluteImportResolver in the application's packages");
                    }
                    Namespaces namespaces = this.emitter.getNamespaces();
                    Iterator it = namespaces.keySet().iterator();
                    while (it.hasNext() && this.resolver == null) {
                        String ns = (String)it.next();
                        String packageName = namespaces.getCreate(ns);
                        try {
                            Class resolverClass = ClassUtils.forName(packageName + "._AbsoluteImportResolver");
                            this.resolver = (ImportResolver)resolverClass.newInstance();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            catch (Throwable t) {
                log.warn("The _AbsoluteImportResolver was not found due to " + t.toString());
                if (!log.isDebugEnabled()) break block10;
                log.debug("The _AbsoluteImportResolver was not found due to " + t.toString() + " " + JavaUtils.stackToString(t));
            }
        }
    }
}

