/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.wsdl.fromJava.ArrayWriter;
import com.ibm.ws.webservices.wsdl.fromJava.BeanWriter;
import com.ibm.ws.webservices.wsdl.fromJava.CharWriter;
import com.ibm.ws.webservices.wsdl.fromJava.CustomWriter;
import com.ibm.ws.webservices.wsdl.fromJava.Emitter;
import com.ibm.ws.webservices.wsdl.fromJava.EnumWriter;
import com.ibm.ws.webservices.wsdl.fromJava.MIMEWriter;
import com.ibm.ws.webservices.wsdl.fromJava.MapWriter;
import com.ibm.ws.webservices.wsdl.fromJava.Namespaces;
import com.ibm.ws.webservices.wsdl.fromJava.SchemaWriter;
import com.ibm.ws.webservices.wsdl.fromJava.SimpleWriter;
import com.ibm.ws.webservices.wsdl.fromJava.Style;
import com.ibm.ws.webservices.wsdl.fromJava.Utils;
import com.ibm.ws.webservices.wsdl.fromJava.VectorWriter;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class Types {
    protected static Log log = LogFactory.getLog(Types.class.getName());
    Definition def;
    Namespaces namespaces = null;
    TypeMapping tm;
    String targetNamespace;
    Element wsdlTypesElem = null;
    Element firstWrapperElement = null;
    HashMap schemaTypes = null;
    HashMap schemaElementNames = null;
    HashMap schemaUniqueElementNames = null;
    HashMap wrapperMap = new HashMap();
    HashMap writtenPrefixNS = null;
    List stopClasses = null;
    List beanCompatErrs = new ArrayList();
    Style style = null;
    Use use = null;
    Emitter emitter = null;
    List writers = new ArrayList();
    JavaClass listClass;
    boolean verbose;
    boolean elementFormDefault;
    boolean elementFormDefaultOption;
    boolean attributeFormDefault;
    boolean attributeFormDefaultOption;
    Document docHolder;

    Types(Emitter emitter, Definition def, TypeMapping tm, Namespaces namespaces, String targetNamespace, List stopClasses, Style style, Use use, boolean verbose, boolean elementFormDefault, boolean attributeFormDefault) {
        this.emitter = emitter;
        this.def = def;
        this.createDocumentFragment();
        this.tm = tm;
        this.namespaces = namespaces;
        this.targetNamespace = targetNamespace;
        this.stopClasses = stopClasses;
        this.style = style;
        this.use = use;
        this.verbose = verbose;
        this.elementFormDefault = elementFormDefault;
        this.attributeFormDefault = attributeFormDefault;
        this.schemaElementNames = new HashMap();
        this.schemaUniqueElementNames = new HashMap();
        this.schemaTypes = new HashMap();
        this.writtenPrefixNS = new HashMap();
        this.writers.add(new ArrayWriter(this));
        this.writers.add(new CustomWriter(this, emitter.getCustomRegistry()));
        this.writers.add(new CharWriter(this));
        this.writers.add(new MIMEWriter(this));
        this.writers.add(new EnumWriter(this));
        this.writers.add(new MapWriter(this));
        this.writers.add(new VectorWriter(this));
        this.writers.add(new SimpleWriter(this));
        this.writers.add(new BeanWriter(this));
        this.listClass = (JavaClass)emitter.getToolEnv().getClassFactory().forName("java.util.List");
        if (this.listClass == null) {
            throw new InternalException(new ClassNotFoundException("java.util.List"));
        }
    }

    Style getStyle() {
        return this.style;
    }

    Use getUse() {
        return this.use;
    }

    Emitter getEmitter() {
        return this.emitter;
    }

    Namespaces getNamespaces() {
        return this.namespaces;
    }

    void loadInputTypes(String inputWSDL) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Document doc = XMLUtils.newDocument(inputWSDL);
        if (doc.getFirstChild() != null && doc.getFirstChild().getLocalName().equals("definitions")) {
            for (Node child = doc.getFirstChild().getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getLocalName() == null || !child.getLocalName().equals("types")) continue;
                this.wsdlTypesElem = (Element)child;
            }
        }
        if (this.wsdlTypesElem == null) {
            return;
        }
        this.wsdlTypesElem = (Element)this.docHolder.importNode(this.wsdlTypesElem, true);
        this.docHolder.appendChild(this.wsdlTypesElem);
        BaseTypeMapping btm = new BaseTypeMapping(){

            public String getBaseName(QName qNameIn) {
                QName qName = QNameTable.createQName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                Class cls = Types.this.tm.getClassForQName(qName);
                if (cls == null) {
                    return null;
                }
                return JavaUtils.getTextClassName(cls.getName());
            }

            public TypeMapping getTypeMapping() {
                return Types.this.tm;
            }
        };
        MetaInfo metaInfo = new MetaInfo();
        metaInfo.setBaseTypeMapping(btm);
        SymbolTable symbolTable = new SymbolTable(this.emitter.getToolEnv(), metaInfo, true, false);
        symbolTable.populate(inputWSDL, doc);
        Vector v = symbolTable.getTypes();
        for (int i = 0; i < v.size(); ++i) {
            TypeEntry te = (TypeEntry)v.elementAt(i);
            if (this.verbose) {
                this.emitter.getToolEnv().report(Messages.getMessage("j2wGen00", "existing type/element", te.getQName().toString()));
            }
            if (te instanceof com.ibm.ws.webservices.wsdl.symbolTable.Element) {
                this.addToElementsList(te.getQName());
                continue;
            }
            if (!(te instanceof Type)) continue;
            this.addToTypesList(te.getQName());
        }
    }

    QName writeTypeForPart(JavaHelpers type, QName qname) {
        if (type.getJavaName().equals("void")) {
            return null;
        }
        if (Utils.getHolderValueType(type, this.emitter.getToolEnv().getClassFactory()) != null) {
            type = Utils.getHolderValueType(type, this.emitter.getToolEnv().getClassFactory());
        }
        if ((qname == null || Constants.isSOAP_ENC(qname.getNamespaceURI()) && "Array".equals(qname.getLocalPart())) && (qname = this.getTypeQName(type)) == null) {
            this.emitter.getToolEnv().reporterr(Messages.getMessage("beanCompatType00", type.getJavaName()));
            qname = Constants.XSD_ANYTYPE;
        }
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        if (this.writeType(type, qname) == null) {
            qname = Constants.XSD_ANYTYPE;
        }
        return qname;
    }

    QName writeElementForPart(JavaHelpers type, QName qName, String partName) {
        String nsURI;
        if (type.getJavaName().equals("void")) {
            return null;
        }
        if (Utils.getHolderValueType(type, this.emitter.getToolEnv().getClassFactory()) != null) {
            type = Utils.getHolderValueType(type, this.emitter.getToolEnv().getClassFactory());
        }
        if ((qName == null || Constants.isSOAP_ENC(qName.getNamespaceURI()) && "Array".equals(qName.getLocalPart())) && (qName = this.getTypeQName(type)) == null) {
            this.emitter.getToolEnv().reporterr(Messages.getMessage("beanCompatType00", type.getJavaName()));
            qName = Constants.XSD_ANYTYPE;
        }
        if (Constants.isSOAP_ENC(nsURI = qName.getNamespaceURI()) && !"Array".equals(qName.getLocalPart())) {
            return qName;
        }
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        QName elemQName = qName;
        if ((Constants.isSchemaXSD(nsURI) || Constants.isWSIBasicProfile(nsURI)) && this.isElementEmitted(elemQName = QNameTable.createQName(this.targetNamespace, partName))) {
            elemQName = QNameTable.createQName(this.targetNamespace, qName.getLocalPart());
        }
        if (this.writeTypeAsElement(type, qName, elemQName) == null) {
            elemQName = null;
        }
        return elemQName;
    }

    boolean writeWrapperForPart(QName wrapper, String name2, QName type, boolean isUnbounded, boolean isNillable) {
        Element sequence;
        boolean isNew;
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        this.writeTypeNamespace(wrapper.getNamespaceURI());
        if (type != null) {
            this.recordReference(wrapper.getNamespaceURI(), type.getNamespaceURI());
        }
        boolean bl = isNew = (sequence = (Element)this.wrapperMap.get(wrapper)) == null;
        if (isNew) {
            Element wrapperElement = this.docHolder.createElement("element");
            Element schema = this.writeSchemaElement(wrapper.getNamespaceURI());
            if (schema != null) {
                schema.insertBefore(wrapperElement, this.firstWrapperElement);
                if (this.firstWrapperElement == null) {
                    this.firstWrapperElement = wrapperElement;
                }
            }
            wrapperElement.setAttribute("name", wrapper.getLocalPart());
            Element complexType = this.docHolder.createElement("complexType");
            wrapperElement.appendChild(complexType);
            sequence = this.docHolder.createElement("sequence");
            complexType.appendChild(sequence);
            this.wrapperMap.put(wrapper, sequence);
        }
        if (name2 != null) {
            Element childElem = this.docHolder.createElement("element");
            childElem.setAttribute("name", name2);
            String prefix = (String)this.writtenPrefixNS.get(type.getNamespaceURI());
            if (prefix == null) {
                prefix = this.namespaces.getCreatePrefix(type.getNamespaceURI());
            }
            String prefixedName = prefix + ":" + type.getLocalPart();
            childElem.setAttribute("type", prefixedName);
            if (isUnbounded) {
                childElem.setAttribute("maxOccurs", "unbounded");
                childElem.setAttribute("minOccurs", "0");
            } else if (isNillable) {
                childElem.setAttribute("nillable", "true");
            }
            sequence.appendChild(childElem);
        }
        return isNew;
    }

    private QName writeTypeAsElement(JavaHelpers type, QName typeQName, QName elemQName) {
        Element schema;
        String typeString;
        if (typeQName == null || Constants.equals(Constants.SOAP_ARRAY, typeQName)) {
            typeQName = this.getTypeQName(type);
        }
        if ((typeString = this.writeType(type, typeQName)) == null) {
            typeString = this.namespaces.getCreatePrefix(Constants.XSD_ANYTYPE.getNamespaceURI()) + ":" + Constants.XSD_ANYTYPE.getLocalPart();
        } else {
            this.writeTypeNamespace(typeQName.getNamespaceURI());
            this.writeTypeNamespace(elemQName.getNamespaceURI());
            this.recordReference(elemQName.getNamespaceURI(), typeQName.getNamespaceURI());
        }
        Element element = this.createElementDecl(elemQName, typeString, this.isNullable(type));
        if (element != null && (schema = this.writeSchemaElement(elemQName.getNamespaceURI())) != null) {
            schema.appendChild(element);
        }
        return elemQName;
    }

    private QName writeTypeNamespace(JavaHelpers type, QName qName) {
        if (qName == null) {
            qName = this.getTypeQName(type);
        }
        this.writeTypeNamespace(qName.getNamespaceURI());
        return qName;
    }

    String writeTypeNamespace(String namespace) {
        String pref = null;
        if (namespace != null && (pref = this.def.getPrefix(namespace)) == null) {
            pref = this.namespaces.getCreatePrefix(namespace);
            this.def.addNamespace(pref, namespace);
        }
        return pref;
    }

    void recordReference(String refingNS, String refdNS) {
        if (refingNS == refdNS || refingNS.equals(refdNS)) {
            return;
        }
        Element schema = this.writeSchemaElement(refingNS);
        if (schema == null) {
            return;
        }
        String pref = this.writeTypeNamespace(refdNS);
        String attr = schema.getAttribute("xmlns:" + pref);
        this.writtenPrefixNS.put(refdNS, pref);
        if (attr == null || attr.length() == 0) {
            schema.setAttribute("xmlns:" + pref, refdNS);
            Element importElem = this.docHolder.createElement("import");
            if (schema.hasChildNodes()) {
                schema.insertBefore(importElem, schema.getFirstChild());
            } else {
                schema.appendChild(importElem);
            }
            importElem.setAttribute("namespace", refdNS);
            String schemaLocation = this.emitter.getNs2Location(refdNS);
            if (schemaLocation != null) {
                importElem.setAttribute("schemaLocation", schemaLocation);
            }
        }
    }

    QName getTypeQName(JavaHelpers javaType) {
        return this.getTypeQName(javaType, null);
    }

    QName getTypeQName(JavaHelpers javaType, String refNamespace) {
        if (refNamespace == null) {
            refNamespace = this.targetNamespace;
        }
        QName xmlType = null;
        xmlType = Utils.getTypeQName(javaType, this.tm, this.emitter.getCustomRegistry(), this.emitter.getToolEnv().getClassFactory());
        if (xmlType != null && Constants.equals(Constants.SOAP_ARRAY, xmlType)) {
            ArrayType javaTypeArray;
            JavaHelpers componentType;
            QName cxmlType;
            xmlType = !javaType.isArray() ? QNameTable.createQName(refNamespace, "ArrayOfXSDAnyType") : ((cxmlType = this.getTypeQName(componentType = (JavaHelpers)(javaTypeArray = (ArrayType)javaType).getComponentType(), refNamespace)).equals(Constants.XSD_ANYTYPE) ? QNameTable.createQName(refNamespace, "ArrayOfXSDAnyType") : (refNamespace.equals(cxmlType.getNamespaceURI()) ? QNameTable.createQName(refNamespace, "ArrayOf" + cxmlType.getLocalPart()) : (this.isNullable(componentType) ? QNameTable.createQName(refNamespace, "ArrayOf_" + Math.abs(refNamespace.hashCode()) + "_nillable_" + cxmlType.getLocalPart()) : QNameTable.createQName(refNamespace, "ArrayOf_" + Math.abs(refNamespace.hashCode()) + "_" + cxmlType.getLocalPart()))));
            return xmlType;
        }
        if (xmlType == null) {
            String pkg = "";
            if (javaType instanceof JavaClass) {
                pkg = ((JavaClass)javaType).getJavaPackage().getName();
                if (((JavaClass)javaType).isNested()) {
                    this.emitter.getToolEnv().reportWarning(Messages.getMessage("J2WFoundInnerClass", javaType.getName()));
                }
            }
            String lcl = javaType.getName();
            String ns = this.namespaces.getCreate(pkg);
            this.namespaces.getCreatePrefix(ns);
            String localPart = JavaUtils.java2NCName(lcl);
            xmlType = QNameTable.createQName(ns, localPart);
        }
        return xmlType;
    }

    Element writeSchemaElement(String namespace) {
        if (this.wsdlTypesElem == null) {
            try {
                this.writeWsdlTypesElement();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.fromJava.Types.writeSchemaElementgetS", "594", this);
                log.error(e);
                this.emitter.getToolEnv().reportFatalErr(e.toString());
                return null;
            }
        }
        Element schemaElem = null;
        for (Node child = this.wsdlTypesElem.getFirstChild(); child != null; child = child.getNextSibling()) {
            NamedNodeMap attrs = child.getAttributes();
            if (attrs == null) continue;
            for (int n = 0; n < attrs.getLength(); ++n) {
                Attr a = (Attr)attrs.item(n);
                if (!a.getName().equals("targetNamespace") || !a.getValue().equals(namespace)) continue;
                schemaElem = (Element)child;
            }
        }
        if (schemaElem == null) {
            schemaElem = this.docHolder.createElement("schema");
            this.wsdlTypesElem.appendChild(schemaElem);
            if (this.emitter.getElementFormDefaultOption()) {
                if (this.emitter.getElementFormDefault()) {
                    schemaElem.setAttribute("elementFormDefault", "qualified");
                } else {
                    schemaElem.setAttribute("elementFormDefault", "unqualified");
                }
            }
            if (this.emitter.getAttributeFormDefaultOption()) {
                if (this.emitter.getAttributeFormDefault()) {
                    schemaElem.setAttribute("attributeFormDefault", "qualified");
                } else {
                    schemaElem.setAttribute("attributeFormDefault", "unqualified");
                }
            }
            schemaElem.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
            schemaElem.setAttribute("targetNamespace", namespace);
            Map commonNSMap = this.emitter.getCommonNSMap();
            Iterator keys = commonNSMap.keySet().iterator();
            while (keys.hasNext()) {
                String prefix = (String)keys.next();
                String namespace2 = (String)commonNSMap.get(prefix);
                if (namespace.equals("http://www.w3.org/2001/XMLSchema")) continue;
                schemaElem.setAttribute("xmlns:" + prefix, namespace2);
            }
            if (this.use != Use.LITERAL) {
                Element importElem = this.docHolder.createElement("import");
                schemaElem.appendChild(importElem);
                importElem.setAttribute("namespace", Constants.URI_DEFAULT_SOAP_ENC);
            }
        }
        return schemaElem;
    }

    private void writeWsdlTypesElement() {
        if (this.wsdlTypesElem == null) {
            this.wsdlTypesElem = this.docHolder.createElementNS("http://schemas.xmlsoap.org/wsdl/", "types");
            this.wsdlTypesElem.setPrefix("wsdl");
        }
    }

    String writeType(JavaHelpers type) {
        return this.writeType(type, null, null);
    }

    String writeType(JavaHelpers type, QName qName) {
        return this.writeType(type, qName, null);
    }

    String writeType(JavaHelpers type, QName qName, String refingNS) {
        if (qName == null || Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = this.getTypeQName(type, refingNS);
        }
        if (Constants.isSchemaXSD(qName.getNamespaceURI())) {
            return "xsd:" + qName.getLocalPart();
        }
        if (Constants.isSOAP_ENC(qName.getNamespaceURI()) && !"Array".equals(qName.getLocalPart())) {
            return "soapenc:" + qName.getLocalPart();
        }
        if (Constants.isWSIBasicProfile(qName.getNamespaceURI())) {
            return "wsi:" + qName.getLocalPart();
        }
        this.writeTypeNamespace(type, qName);
        String prefix = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
        String prefixedName = prefix + ":" + qName.getLocalPart();
        SchemaWriter writer = null;
        for (int i = 0; i < this.writers.size() && writer == null; ++i) {
            if (!((SchemaWriter)this.writers.get(i)).isWriter(type, qName)) continue;
            writer = (SchemaWriter)this.writers.get(i);
        }
        try {
            if (writer != null) {
                if (!this.addToTypesList(qName)) {
                    return prefixedName;
                }
                if (this.verbose) {
                    this.emitter.getToolEnv().report(Messages.getMessage("j2wGen00", "type/element", qName.toString()));
                }
                writer.writeSchema(type, qName);
            } else {
                BeanWriter.isBeanCompatible(type, this, true);
                if (!BeanWriter.isMIMEType(type.getJavaName())) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.fromJava.Types.writeType", "717", this);
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("writeSchemaProblem00", type.getJavaName()));
        }
        return prefixedName;
    }

    private Element createElementDecl(QName qName, String elementType, boolean nullable) {
        if (!this.addToElementsList(qName)) {
            return null;
        }
        Element element = this.docHolder.createElement("element");
        element.setAttribute("name", qName.getLocalPart());
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    Element createElement(String elementName, String elementType, boolean nullable, boolean omittable, Document docHolder) {
        Element element = docHolder.createElement("element");
        element.setAttribute("name", elementName);
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        if (omittable) {
            element.setAttribute("minOccurs", "0");
            element.setAttribute("maxOccurs", "1");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    Element createAttributeElement(String elementName, String elementType, boolean nullable, Document docHolder) {
        Element element = docHolder.createElement("attribute");
        element.setAttribute("name", elementName);
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    private boolean addToTypesList(QName qName) {
        boolean added = false;
        ArrayList<String> types = (ArrayList<String>)this.schemaTypes.get(qName.getNamespaceURI());
        if (types == null) {
            types = new ArrayList<String>();
            types.add(qName.getLocalPart());
            this.schemaTypes.put(qName.getNamespaceURI(), types);
            added = true;
        } else if (!types.contains(qName.getLocalPart())) {
            types.add(qName.getLocalPart());
            added = true;
        }
        if (added) {
            String prefix = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
            return !prefix.equals("soapenv") && !prefix.equals("soapenc") && !prefix.equals("xsd") && !prefix.equals("wsdl") && !prefix.equals("wsdlsoap");
        }
        return false;
    }

    private boolean addToElementsList(QName qName) {
        if (qName == null) {
            return false;
        }
        boolean added = false;
        ArrayList<String> elements = (ArrayList<String>)this.schemaElementNames.get(qName.getNamespaceURI());
        if (elements == null) {
            elements = new ArrayList<String>();
            elements.add(qName.getLocalPart());
            this.schemaElementNames.put(qName.getNamespaceURI(), elements);
            added = true;
        } else if (!elements.contains(qName.getLocalPart())) {
            elements.add(qName.getLocalPart());
            added = true;
        }
        return added;
    }

    private boolean isElementEmitted(QName qName) {
        if (qName == null) {
            return false;
        }
        ArrayList elements = (ArrayList)this.schemaElementNames.get(qName.getNamespaceURI());
        if (elements == null) {
            return false;
        }
        return elements.contains(qName.getLocalPart());
    }

    boolean isNullable(JavaHelpers type) {
        return !type.isPrimitive() && (!type.isArray() || !((ArrayType)type).getComponentTypeAsHelper().getJavaName().equals("byte"));
    }

    boolean isSimpleBaseType(JavaHelpers javaType) {
        QName qname = Utils.getTypeQName(javaType, this.tm, this.emitter.getCustomRegistry(), this.emitter.getToolEnv().getClassFactory());
        if (qname == null) {
            return false;
        }
        String nsURI = qname.getNamespaceURI();
        return Constants.isSchemaXSD(nsURI) || Constants.isSOAP_ENC(nsURI) || Constants.isWSIBasicProfile(nsURI);
    }

    boolean isAcceptableAsAttribute(JavaHelpers javaType) {
        return this.isSimpleBaseType(javaType) || EnumWriter.isEnumClass(javaType, this.emitter.getToolEnv().getClassFactory(), this.emitter.getToolEnv()) || SimpleWriter.implementsSimpleType(javaType);
    }

    private void createDocumentFragment() {
        try {
            this.docHolder = XMLUtils.newDocument();
        }
        catch (ParserConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.fromJava.Types.createDocumentFragment", "926", this);
            throw new InternalException(e);
        }
    }

    void insertTypesFragment(Document doc) {
        if (this.wsdlTypesElem != null) {
            Node node = doc.importNode(this.wsdlTypesElem, true);
            doc.getDocumentElement().insertBefore(node, doc.getDocumentElement().getFirstChild());
        }
    }

    List getStopClasses() {
        return this.stopClasses;
    }

    Element createElement(String elementName) {
        return this.docHolder.createElement(elementName);
    }

    TypeMapping getTypeMapping() {
        return this.tm;
    }
}

