/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.fromJava.BeanUtils;
import com.ibm.ws.webservices.wsdl.fromJava.SchemaWriter;
import com.ibm.ws.webservices.wsdl.fromJava.Types;
import com.ibm.ws.webservices.wsdl.fromJava.Utils;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.internal.impl.FieldImpl;
import org.w3c.dom.Element;

class EnumWriter
extends SchemaWriter {
    EnumWriter(Types types) {
        super(types);
    }

    boolean isWriter(JavaHelpers javaType, QName xmlType) {
        return EnumWriter.isEnumClass(javaType, this.types.getEmitter().getToolEnv().getClassFactory(), this.types.getEmitter().getToolEnv());
    }

    void writeSchema(JavaHelpers javaType, QName xmlType) throws Exception {
        JavaClass javaClass = (JavaClass)javaType;
        Method m = BeanUtils.getMethod(javaClass, "getValue", new ArrayList(), this.types.getEmitter().getToolEnv());
        JavaHelpers base = m.getReturnType();
        Element simpleType = this.types.createElement("simpleType");
        Element schema = this.types.writeSchemaElement(xmlType.getNamespaceURI());
        if (schema != null) {
            schema.appendChild(simpleType);
        }
        simpleType.setAttribute("name", xmlType.getLocalPart());
        Element restriction = this.types.createElement("restriction");
        simpleType.appendChild(restriction);
        String baseType = this.types.writeType(base, null);
        restriction.setAttribute("base", baseType);
        this.types.recordReference(xmlType.getNamespaceURI(), this.types.getTypeQName(base).getNamespaceURI());
        EList fields = javaClass.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            FieldImpl field = (FieldImpl)fields.get(i);
            if (!field.getJavaClass().isPublic() || !field.isStatic() || !field.isFinal() || !field.getJavaType().getJavaName().equals(base.getJavaName())) continue;
            Element enumeration = this.types.createElement("enumeration");
            String value2 = Utils.getInitialValue((Field)field);
            if (value2 == null) {
                value2 = field.getName().substring(1);
            }
            enumeration.setAttribute("value", value2);
            restriction.appendChild(enumeration);
        }
    }

    static boolean isEnumClass(JavaHelpers javaType, ClassFactory classFactory, ToolEnv toolEnv) {
        if (!(javaType instanceof JavaClass)) {
            return false;
        }
        JavaClass javaClass = (JavaClass)javaType;
        Method m = BeanUtils.getMethod(javaClass, "getValue", new ArrayList(), toolEnv);
        Method m2 = BeanUtils.getMethod(javaClass, "toString", new ArrayList(), toolEnv);
        Vector<JavaHelpers> params = new Vector<JavaHelpers>();
        JavaHelpers stringCls = classFactory.forName("java.lang.String");
        if (stringCls == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.String"));
        }
        params.add(stringCls);
        Method m3 = BeanUtils.getMethod(javaClass, "fromString", params, true, toolEnv);
        Vector<JavaHelpers> fromParam = new Vector<JavaHelpers>();
        if (m != null) {
            fromParam.add(m.getReturnType());
            if (m != null && m2 != null && m3 != null && BeanUtils.getMethod(javaClass, "fromValue", fromParam, true, toolEnv) != null && BeanUtils.getMethod(javaClass, "setValue", fromParam, toolEnv) == null) {
                return true;
            }
        }
        return false;
    }
}

