/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.BAAInputStream;
import com.ibm.ws.webservices.utils.BAAOutputStream;
import com.ibm.ws.webservices.utils.BufferUtils;
import java.io.BufferedWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DetachableInputStream
extends FilterInputStream {
    private static final TraceComponent tc = Tr.register(DetachableInputStream.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    private long count = 0L;
    BAAInputStream localStream = null;
    boolean isClosed = false;

    public DetachableInputStream(InputStream in) {
        super(in);
    }

    public long length() throws IOException {
        if (this.localStream == null) {
            this.detach();
        }
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() throws IOException {
        if (this.localStream == null && !this.isClosed) {
            BAAOutputStream baaos = new BAAOutputStream();
            try {
                BufferUtils.inputStream2OutputStream(this.in, baaos);
                super.close();
            }
            catch (Throwable t) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "detach caught exception.  Processing continues:" + t);
                    Tr.debug(tc, "  " + DetachableInputStream.stackToString(t));
                }
            }
            finally {
                this.in = null;
            }
            this.localStream = new BAAInputStream(baaos.buffers(), baaos.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The local stream built from the detached stream has a length of:" + baaos.length());
            }
            this.count += (long)baaos.length();
        }
    }

    public int available() throws IOException {
        if (this.localStream != null) {
            return this.localStream.available();
        }
        return super.available();
    }

    public void close() throws IOException {
        this.isClosed = true;
        if (this.localStream != null) {
            this.localStream.close();
        } else {
            super.close();
        }
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public int read() throws IOException {
        if (this.localStream == null) {
            int rc = super.read();
            if (rc != -1) {
                ++this.count;
            }
            return rc;
        }
        return this.localStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.localStream == null) {
            int rc = super.read(b, off, len);
            if (rc > 0) {
                this.count += (long)rc;
            }
            return rc;
        }
        return this.localStream.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        if (this.localStream == null) {
            int rc = super.read(b);
            if (rc > 0) {
                this.count += (long)rc;
            }
            return rc;
        }
        return this.localStream.read(b);
    }

    public synchronized void reset() throws IOException {
        throw new IOException();
    }

    public long skip(long n) throws IOException {
        if (this.localStream == null) {
            long rc = super.skip(n);
            if (rc > 0L) {
                this.count += rc;
            }
            return rc;
        }
        return this.localStream.skip(n);
    }

    private static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        return text;
    }
}

