/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.trace;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;

public class UserExceptionTrace {
    private static TraceComponent tc = Tr.register(UserExceptionTrace.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");

    public static boolean isUserExceptionLoggingEnabled() {
        return tc.isDebugEnabled();
    }

    public static boolean isUserDefinedException(Throwable t) {
        return t != null && t instanceof WebServicesFault && ((WebServicesFault)t).isUserException();
    }

    public static void log(Throwable t) {
        UserExceptionTrace.log(t, null, null, null);
    }

    public static void log(Throwable t, String ffdcClassName, String ffdcLineNumber, Object ffdcClass) {
        if (UserExceptionTrace.isUserDefinedException(t)) {
            if (UserExceptionTrace.isUserExceptionLoggingEnabled()) {
                String logMessage = Messages.getMessage("logUserException00");
                Tr.debug(tc, logMessage, t);
            }
        } else {
            Tr.error(tc, "exception01", t);
            if (ffdcClassName != null && ffdcLineNumber != null && ffdcClass != null) {
                FFDCFilter.processException(t, ffdcClassName, ffdcLineNumber, ffdcClass);
            }
        }
    }
}

