/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.utils;

import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.encoding.AgnosticTypeMappingRegistry;
import com.ibm.ws.webservices.multiprotocol.handlers.AgnosticHandlerRegistry;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Port;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public class ServiceManager {
    protected ServiceContext context;
    protected ServiceProviderManager serviceProviderManager;
    protected AgnosticHandlerRegistry handlerRegistry;
    protected AgnosticTypeMappingRegistry typeMappingRegistry;
    protected Map bindingNamspace2ServiceCache;

    public ServiceManager(ServiceContext context, ServiceProviderManager serviceProviderManager) {
        this.context = context;
        this.serviceProviderManager = serviceProviderManager;
        this.bindingNamspace2ServiceCache = new HashMap();
    }

    public AgnosticTypeMappingRegistry getTypeMappingRegistry() {
        if (this.typeMappingRegistry == null) {
            this.typeMappingRegistry = new AgnosticTypeMappingRegistry();
        }
        return this.typeMappingRegistry;
    }

    public HandlerRegistry getHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new AgnosticHandlerRegistry();
        }
        return this.handlerRegistry;
    }

    public Service getServiceForPort(String portName) throws ServiceException {
        Port port2 = this.context.getWSDLService().getPort(portName);
        Service service = this.getServiceForPort(port2);
        return service;
    }

    public Service getServiceForPort(Port port2) throws ServiceException {
        String bindingNS = this.context.getPortBindingNamespace(port2);
        Service service = this.getServiceForNamespace(bindingNS);
        return service;
    }

    public Service getServiceForNamespace(String namespace) throws ServiceException {
        Service service = this.discoverServiceForNamespace(namespace);
        if (service == null) {
            throw new ServiceException(Messages.getMessage("noService", namespace));
        }
        return service;
    }

    private void initTypeMappings(Service service) {
        TypeMappingRegistry tmr;
        if (this.typeMappingRegistry != null && (tmr = service.getTypeMappingRegistry()) != null) {
            this.typeMappingRegistry.copyContents(tmr);
        }
    }

    private void initHandlerRegistry(Service service) {
        if (this.context.isManagedEnvironment()) {
            return;
        }
        HandlerRegistry hr = service.getHandlerRegistry();
        this.getHandlerRegistry();
        this.handlerRegistry.transferContents(hr);
    }

    protected synchronized Service discoverServiceForNamespace(String bindingNS) throws ServiceException {
        ServiceProvider serviceProvider;
        Service service = (Service)this.bindingNamspace2ServiceCache.get(bindingNS);
        if (service == null && (serviceProvider = this.serviceProviderManager.getServiceProvider(bindingNS)) != null) {
            service = serviceProvider.createService(this.context);
            this.bindingNamspace2ServiceCache.put(bindingNS, service);
            this.initTypeMappings(service);
            this.initHandlerRegistry(service);
        }
        return service;
    }
}

