/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.base.DefaultService;
import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionDescription;
import com.ibm.ws.webservices.multiprotocol.provider.BindingGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

public abstract class ModelServiceProvider
implements ServiceProvider {
    protected String[] supportedBindings;

    protected ModelServiceProvider() throws ServiceException {
        if (this.isEnabled()) {
            this.enableServiceProvider();
        } else {
            this.disableServiceProvider();
        }
    }

    public boolean isBindingNamespaceSupported(String namespaceURI) {
        boolean supported = false;
        for (int i = 0; !supported && i < this.supportedBindings.length; ++i) {
            if (this.supportedBindings[i] == null || this.supportedBindings[i].length() == 0) {
                supported = namespaceURI == null || namespaceURI.length() == 0;
                continue;
            }
            if (!this.supportedBindings[i].equals(namespaceURI)) continue;
            supported = true;
        }
        return supported;
    }

    protected abstract String[] getRequiredClasses();

    public abstract ExtensionDescription[] getExtensionDescriptions();

    protected abstract String[] getSupportedBindingNamespaces();

    public BindingGenerator[] getBindingGenerators() {
        return null;
    }

    public StubGenerator getStubGenerator(Emitter emitter, BindingEntry bEntry, SymbolTable st) {
        return null;
    }

    protected Service makeService(ServiceContext context) throws ServiceException {
        Transport transport2 = this.makeTransport(context);
        DefaultService service = new DefaultService(context, transport2);
        return service;
    }

    protected abstract Transport makeTransport(ServiceContext var1) throws ServiceException;

    public Service createService(ServiceContext context) throws ServiceException {
        Service service = this.makeService(context);
        return service;
    }

    public boolean isEnabled() {
        String[] requiredClasses = this.getRequiredClasses();
        return ModelServiceProvider.areRequiredClassesAvailable(requiredClasses);
    }

    protected void enableServiceProvider() throws ServiceException {
        this.supportedBindings = this.getSupportedBindingNamespaces();
    }

    protected void disableServiceProvider() {
        this.supportedBindings = new String[0];
    }

    protected static boolean areRequiredClassesAvailable(String[] classes) {
        boolean classesAvailable = true;
        if (classes != null) {
            for (int i = 0; classesAvailable && i < classes.length; ++i) {
                final String className = classes[i];
                Class c = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return ClassUtils.forName(className);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                });
                if (c != null) continue;
                classesAvailable = false;
            }
        }
        return classesAvailable;
    }
}

