/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.websphere.webservices.rpc.IBMCall;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.attachments.MimeUtils;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.SDOCall;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.models.ModelTransport;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import commonj.sdo.DataGraph;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;

public abstract class ModelCall
implements IBMCall,
SDOCall {
    protected InvocationContext invocationContext;
    protected QName portTypeName;
    protected QName operationName;
    protected String inputMessageName;
    protected ParameterDesc returnParameter;
    protected ArrayList parameters;
    protected boolean parameterAndReturnSpecRequired;
    protected Map outputParams;
    protected boolean invokeOneWayCalled = false;
    protected static ArrayList propertyNames = new ArrayList();
    protected Transport transport;

    protected ModelCall(InvocationContext invContext, Transport transport2, QName operationName, String inputMessageName) {
        this.invocationContext = invContext;
        this.transport = transport2;
        this.initialize();
        if (operationName != null) {
            if (operationName.getNamespaceURI().equals("")) {
                String uriString = this.invocationContext.getServiceContext().getServiceName().getNamespaceURI();
                QName qn = QNameTable.createQName(uriString, operationName.getLocalPart());
                this.setOperationName(qn);
            } else {
                this.setOperationName(operationName);
            }
        }
        this.inputMessageName = inputMessageName;
        if (this.invocationContext.getEndpoint() == null) {
            this.setTargetEndpointAddress(this.getPort());
        }
    }

    protected void initialize() {
        this.returnParameter = null;
        this.parameters = new ArrayList();
        this.parameterAndReturnSpecRequired = true;
        this.invokeOneWayCalled = false;
        this.portTypeName = null;
        this.outputParams = new HashMap();
        this.invocationContext.setInputDataGraph(null);
        this.invocationContext.setOutputDataGraph(null);
        this.invocationContext.setInputParams(null);
        this.invocationContext.setOutputParams(null);
        this.invocationContext.setInputParameterTypes(null);
        this.invocationContext.setOneWay(false);
    }

    public void setProperty(String name2, Object value2) {
        if (this.isIllegalPropertyNameForCall(name2)) {
            throw new JAXRPCException(Messages.getMessage("badCallPropName", name2));
        }
        if ("javax.xml.rpc.session.maintain".equals(name2)) {
            this.setMaintainSession(value2);
        }
        this.doSetProperty(name2, value2);
    }

    protected void doSetProperty(String name2, Object value2) {
        this.invocationContext.setProperty(name2, value2);
    }

    public Object getProperty(String name2) {
        if (this.isIllegalPropertyNameForCall(name2)) {
            throw new JAXRPCException(Messages.getMessage("badCallPropName", name2));
        }
        return this.invocationContext.getProperty(name2);
    }

    protected void setMaintainSession(Object value2) {
        if (!(value2 instanceof Boolean) || this.transport == null) {
            return;
        }
        boolean yes = (Boolean)value2;
        if (yes) {
            return;
        }
        try {
            ((ModelTransport)this.transport).close(this.getTargetEndpointAddress());
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.models.ModelCall.setMaintainSession", "235", this);
            throw new JAXRPCException(Messages.getMessage("errorClosePort", "RemoteException", e.toString()));
        }
    }

    public boolean isMaintainSession() {
        Boolean bool = (Boolean)this.getProperty("javax.xml.rpc.session.maintain");
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public void removeProperty(String name2) {
        this.invocationContext.removeProperty(name2);
    }

    public static Iterator getDefaultPropertyNames() {
        return propertyNames.iterator();
    }

    public Iterator getPropertyNames() {
        return propertyNames.iterator();
    }

    public boolean isPropertySupported(String name2) {
        return propertyNames.contains(name2) || !name2.startsWith("java.") && !name2.startsWith("javax.");
    }

    protected boolean isIllegalPropertyNameForCall(String name2) {
        if (name2 == null) {
            return true;
        }
        if (name2.equals("javax.xml.rpc.encodingstyle.namespace.uri") || name2.equals("javax.xml.rpc.soap.operation.style") || name2.equals("javax.xml.rpc.security.auth.password") || name2.equals("javax.xml.rpc.session.maintain") || name2.equals("javax.xml.rpc.soap.http.soapaction.uri") || name2.equals("javax.xml.rpc.soap.http.soapaction.use") || name2.equals("javax.xml.rpc.security.auth.username")) {
            return false;
        }
        return name2.startsWith("javax.xml.rpc");
    }

    public boolean isParameterAndReturnSpecRequired(QName operationName) {
        return this.parameterAndReturnSpecRequired;
    }

    protected void setParameterAndReturnSpecRequired(boolean b) {
        this.parameterAndReturnSpecRequired = b;
    }

    public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode) {
        this.addParameter(QNameTable.createQName("", paramName), xmlType, null, parameterMode);
    }

    public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode parameterMode) {
        this.addParameter(QNameTable.createQName("", paramName), xmlType, javaType, parameterMode);
    }

    public void addParameter(QName paramName, QName xmlType, Class javaType, ParameterMode parameterMode) {
        ParameterDesc param = new ParameterDesc();
        param.setQName(paramName);
        param.setTypeQName(xmlType);
        param.setJavaType(javaType);
        byte mode = 1;
        if (parameterMode == ParameterMode.INOUT) {
            mode = 3;
        } else if (parameterMode == ParameterMode.OUT) {
            mode = 2;
        }
        param.setMode(mode);
        this.parameters.add(param);
    }

    public QName getParameterTypeByName(String paramName) {
        QName parameterType = null;
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)this.parameters.get(i);
            if (!param.getQName().getLocalPart().equals(paramName)) continue;
            parameterType = param.getTypeQName();
        }
        return parameterType;
    }

    public void setReturnType(QName xmlType) {
        this.setReturnType(xmlType, null);
    }

    public void setReturnType(QName xmlType, Class javaType) {
        this.returnParameter = new ParameterDesc();
        this.returnParameter.setTypeQName(xmlType);
        this.returnParameter.setJavaType(javaType);
    }

    public QName getReturnType() {
        QName returnType = null;
        if (this.returnParameter != null) {
            returnType = this.returnParameter.getTypeQName();
        }
        return returnType;
    }

    public Class getReturnClass() {
        Class returnClass = null;
        returnClass = this.returnParameter != null ? this.returnParameter.getJavaType() : this.invocationContext.getReturnType();
        return returnClass;
    }

    public void removeAllParameters() {
        this.initialize();
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    public QName getPortTypeName() {
        return this.portTypeName == null ? QNameTable.createQName("", "") : this.portTypeName;
    }

    public void setPortTypeName(QName portTypeName) {
        this.portTypeName = portTypeName;
        this.invocationContext.setPortName(portTypeName.getLocalPart());
    }

    public Port getPort() {
        Port port2 = null;
        Service service = this.invocationContext.getServiceContext().getWSDLService();
        if (service != null) {
            String portName = this.invocationContext.getPortName();
            port2 = service.getPort(portName);
        }
        return port2;
    }

    public String getTargetEndpointAddress() {
        return this.invocationContext.getEndpoint();
    }

    public void setTargetEndpointAddress(String address) {
        this.invocationContext.setEndpoint(address);
    }

    protected void setTargetEndpointAddress(Port port2) {
        List ees;
        if (port2 != null && (ees = port2.getExtensibilityElements()) != null && ees.size() > 0) {
            ExtensibilityElement ee = (ExtensibilityElement)ees.get(0);
            if (ee instanceof AgnosticAddress) {
                AgnosticAddress agnosticAddress = (AgnosticAddress)ee;
                this.setTargetEndpointAddress(agnosticAddress.getLocationURI());
            } else {
                this.doUnknownPortExtensibilityElement(port2, ee);
            }
        }
    }

    protected void doUnknownPortExtensibilityElement(Port port2, ExtensibilityElement ee) {
    }

    public void setInputMessageName(String name2) {
        this.inputMessageName = name2;
    }

    public Object invoke(Object[] inputParams) throws RemoteException {
        QName operationName = this.getOperationName();
        Object response = this.invoke(operationName, inputParams);
        return response;
    }

    public Object invoke(QName operationName, Object[] inputParams) throws RemoteException {
        Object response = this.doInvoke(operationName, null, inputParams);
        return response;
    }

    protected abstract Object doInvoke(InvocationContext var1) throws RemoteException;

    public Object invoke(QName operationName, String inputMessageName, Object[] inputParams) throws RemoteException {
        Object response = this.doInvoke(operationName, inputMessageName, inputParams);
        return response;
    }

    public DataGraph invoke(DataGraph dataGraph) throws RemoteException {
        this.invocationContext.setInputDataGraph(dataGraph);
        this.doInvoke(this.invocationContext);
        DataGraph outDataGraph = this.invocationContext.getOutputDataGraph();
        return outDataGraph;
    }

    public void invokeOneway(DataGraph dataGraph) {
        this.invokeOneWayCalled = true;
        this.invocationContext.setOneWay(true);
        try {
            try {
                this.invoke(dataGraph);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            Object var4_2 = null;
            this.invocationContext.setOneWay(false);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.invocationContext.setOneWay(false);
            throw throwable;
        }
    }

    protected Object doInvoke(QName operationName, String inputMessageName, Object[] inputParams) throws RemoteException {
        this.invocationContext.setOperationName(operationName);
        this.invocationContext.setInputMessageName(inputMessageName);
        this.invocationContext.setInputParams(inputParams);
        if (this.parameters.size() > 0) {
            boolean useable = true;
            ArrayList<Class> inputTypes = new ArrayList<Class>();
            for (int i = 0; i < this.parameters.size(); ++i) {
                ParameterDesc pd = (ParameterDesc)this.parameters.get(i);
                if (pd.getMode() == 2) continue;
                Class cls = pd.getJavaType();
                if (cls == null) {
                    useable = false;
                    break;
                }
                inputTypes.add(cls);
            }
            if (useable && inputTypes.size() == inputParams.length) {
                this.invocationContext.setInputParameterTypes(inputTypes.toArray(new Class[inputTypes.size()]));
            }
        }
        return this.doInvoke(this.invocationContext);
    }

    protected Object getTarget() throws RemoteException {
        Object target;
        if (this.transport instanceof ModelTransport) {
            ModelTransport modelTransport = (ModelTransport)this.transport;
            target = modelTransport.getTargetObject(this.invocationContext);
        } else {
            target = this.transport.makeTargetObject(this.invocationContext);
        }
        return target;
    }

    protected void closeIfRequired(Object target) throws RemoteException {
        Boolean maintainSession = (Boolean)this.getProperty("javax.xml.rpc.session.maintain");
        if (maintainSession == null || !maintainSession.booleanValue()) {
            if (this.transport instanceof ModelTransport) {
                ((ModelTransport)this.transport).close(this.getTargetEndpointAddress());
            } else {
                this.transport.close(this.invocationContext, target);
            }
        }
    }

    public void invokeOneWay(Object[] inputParams) {
        this.invokeOneWayCalled = true;
        this.invocationContext.setOneWay(true);
        try {
            try {
                this.invoke(inputParams);
            }
            catch (RemoteException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.models.ModelCall.invokeOneWay", "550", this);
                throw new JAXRPCException(Messages.getMessage("invokeError", "RemoteException", e.toString()));
            }
            Object var4_2 = null;
            this.invocationContext.setOneWay(false);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.invocationContext.setOneWay(false);
            throw throwable;
        }
    }

    public Map getOutputParams() {
        return this.outputParams;
    }

    public List getOutputValues() {
        ArrayList<Object> outputParamsList = this.outputParams != null ? new ArrayList(this.outputParams.values()) : new ArrayList();
        return outputParamsList;
    }

    public void addAttachmentParameter(QName paramName, String mimeType, Class javaType, ParameterMode mode) {
        this.addParameter(paramName, MimeUtils.getMIMETypeQName(mimeType), javaType, mode);
    }

    public void setAttachmentReturnType(String mimeType, Class javaType) {
        this.setReturnType(MimeUtils.getMIMETypeQName(mimeType), javaType);
    }

    public void addParameter(QName paramName, QName xmlType, ParameterMode parameterMode) {
        this.addParameter(paramName, xmlType, null, parameterMode);
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    static {
        propertyNames.add("javax.xml.rpc.security.auth.username");
        propertyNames.add("javax.xml.rpc.security.auth.password");
        propertyNames.add("javax.xml.rpc.session.maintain");
        propertyNames.add("javax.xml.rpc.service.endpoint.address");
        propertyNames.add("com.ibm.websphere.webservices.protocolNamespace");
    }
}

