/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.handlers;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPool;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPoolFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.handlers.HandlerChain;
import com.ibm.ws.webservices.multiprotocol.handlers.Message;
import com.ibm.ws.webservices.multiprotocol.handlers.MessageContext;
import com.ibm.wsspi.webservices.rpc.handler.Handler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.commons.logging.Log;

public class JAXRPCHandlerChain
extends AbstractList
implements HandlerChain {
    protected static Log log = LogFactory.getLog(JAXRPCHandlerChain.class.getName());
    private static final String emptyString = "".intern();
    private List _handlerPools = new ArrayList();
    private Collection _headerQNames = new JAXRPCHandler.QNameSet();
    private Collection _roles;
    static /* synthetic */ Class class$com$ibm$wsspi$webservices$rpc$handler$SystemHandler;
    static /* synthetic */ Class class$com$ibm$wsspi$webservices$rpc$handler$Handler;

    public JAXRPCHandlerChain(List handlerInfos, Collection roles) {
        if (handlerInfos != null) {
            this.addAll(handlerInfos);
        }
        this.setRoles(roles);
    }

    public void destroy() {
        this.clear();
        if (this._handlerPools != null) {
            this._handlerPools.clear();
            this._handlerPools = null;
        }
        if (this._headerQNames != null) {
            this._headerQNames.clear();
            this._headerQNames = null;
        }
        if (this._roles != null) {
            this._roles.clear();
            this._roles = null;
        }
    }

    public void preHandleIncoming(MessageContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JAXRPCHandlerChain.preHandleIncoming()");
        }
        boolean done = false;
        for (int handlerIdx = 0; !done && handlerIdx < this._handlerPools.size(); ++handlerIdx) {
            HandlerPool pool2;
            if (!(class$com$ibm$wsspi$webservices$rpc$handler$SystemHandler == null ? JAXRPCHandlerChain.class$("com.ibm.wsspi.webservices.rpc.handler.SystemHandler") : class$com$ibm$wsspi$webservices$rpc$handler$SystemHandler).isAssignableFrom((pool2 = (HandlerPool)this._handlerPools.get(handlerIdx)).getHandlerClass())) continue;
            SystemHandler handler2 = (SystemHandler)pool2.get();
            String handlerName = pool2.getHandlerClassName();
            if (log.isDebugEnabled()) {
                log.debug(handlerName + ".preHandleIncoming()");
            }
            try {
                handler2.preHandleIncoming(context);
                pool2.put(handler2);
                continue;
            }
            catch (SOAPFaultException sfe) {
                FFDCFilter.processException((Throwable)sfe, "com.ibm.ws.webservices.engine.handlers.JAXRPCHandlerChain.preHandleIncoming", "202", this);
                done = true;
                pool2.put(handler2);
                throw sfe;
            }
            catch (RuntimeException re) {
                FFDCFilter.processException((Throwable)re, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.preHandleIncoming", "210", this);
                done = true;
                pool2.faulted(handler2);
                throw re;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JAXRPCHandlerChain.preHandleIncoming()");
        }
    }

    public boolean handleRequest(MessageContext context) throws WebServicesFault {
        boolean result = true;
        boolean done = false;
        Message savedRequestMessage = null;
        String handlerName = null;
        int handlerIdx = 0;
        boolean autoResponse = false;
        while (!done && handlerIdx < this._handlerPools.size()) {
            savedRequestMessage = context.getRequestMessage();
            HandlerPool pool2 = (HandlerPool)this._handlerPools.get(handlerIdx);
            handlerName = pool2.getHandlerClassName();
            boolean faultLocal = ExtendedHandlerInfo.isFaultLocal(pool2.getOriginalInfo());
            autoResponse = ExtendedHandlerInfo.isAutoResponse(pool2.getOriginalInfo());
            javax.xml.rpc.handler.Handler handler2 = pool2.get();
            try {
                if (log.isDebugEnabled()) {
                    log.debug(handlerName + ".handleRequest()");
                }
                result = handler2.handleRequest(context);
                if (context.isServer()) {
                    this.checkProtectedStateViolation(context, handlerName);
                }
                if (!result) {
                    done = true;
                } else {
                    ++handlerIdx;
                }
                pool2.put(handler2);
            }
            catch (SOAPFaultException sfe) {
                FFDCFilter.processException((Throwable)sfe, "com.ibm.ws.webservices.engine.handlers.HandlerChain.handleRequest", "135", this);
                done = true;
                pool2.put(handler2);
                this.handleSOAPException(context, handlerName, handlerIdx, autoResponse, faultLocal, savedRequestMessage, sfe);
                throw sfe;
            }
            catch (RuntimeException re) {
                Throwable t;
                FFDCFilter.processException((Throwable)re, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.handleRequest", "228", this);
                done = true;
                if (re instanceof JAXRPCException && (t = WebServicesFault.getRootCause(re)) instanceof WebServicesFault) {
                    pool2.put(handler2);
                    this.handleSOAPException(context, handlerName, handlerIdx, autoResponse, faultLocal, savedRequestMessage, t);
                    throw (WebServicesFault)t;
                }
                pool2.faulted(handler2);
                this.handleClosure(context, handlerIdx - 1);
                handlerIdx = -1;
                if (context.isServer()) {
                    this.handleRuntimeException(re, context, handlerName, "handleRequest");
                    continue;
                }
                throw WebServicesFault.makeFault(re);
            }
        }
        if (!result) {
            if (autoResponse) {
                this.forceResponse(context, savedRequestMessage, handlerName, false, null);
            }
            if (handlerIdx >= 0) {
                if (context.isOneWay()) {
                    this.handleClosure(context, handlerIdx);
                } else {
                    LoopControls controls = new LoopControls(handlerIdx, -1);
                    this.oneHandleResponse(context, controls);
                    if (!autoResponse) {
                        this.forceResponse(context, savedRequestMessage, handlerName, true, null);
                    }
                    this.handleResponse(context, controls);
                }
            }
        }
        return result;
    }

    public void forceResponse(MessageContext context, Message savedRequestMessage, String handlerName, boolean warn, Throwable exception) throws MissingResourceException {
        context.setPastPivot(true);
        if (!context.isOneWay()) {
            Message potentialResponseMessage = context.getRequestMessage();
            if (potentialResponseMessage == savedRequestMessage) {
                if (context.getResponseMessage() == null) {
                    if (warn) {
                        log.warn(Messages.getMessage("jaxRpcHandlerMissingResponse00", handlerName));
                    }
                    if (exception == null) {
                        Message respMsg = context.createMessage();
                        context.setResponseMessage(respMsg);
                    } else {
                        Message respMsg = context.createMessage();
                        respMsg.setFault(true);
                        respMsg.setPayload(exception);
                        context.setResponseMessage(respMsg);
                    }
                }
            } else {
                context.setResponseMessage(potentialResponseMessage);
                context.setRequestMessage(savedRequestMessage);
            }
        }
    }

    protected void handleSOAPException(MessageContext context, String handlerName, int handleIdx, boolean autoResponse, boolean faultLocal, Message savedRequestMessage, Throwable exception) throws WebServicesFault, MissingResourceException {
        if (context.isServer()) {
            LoopControls controls = new LoopControls(handleIdx, -1);
            if (autoResponse) {
                this.forceResponse(context, savedRequestMessage, handlerName, false, exception);
            }
            if (controls.idx() >= 0) {
                if (faultLocal) {
                    this.oneHandleFault(context, controls);
                } else {
                    controls.next();
                }
            }
            if (!autoResponse) {
                this.forceResponse(context, savedRequestMessage, handlerName, true, exception);
            }
            this.handleFault(context, controls);
        } else {
            log.error(Messages.getMessage("jaxRpcHandlerRequestClientFault00", handlerName));
            this.handleClosure(context, handleIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleRuntimeException(RuntimeException re, MessageContext context, String handlerName, String handlerType) throws WebServicesFault {
        WebServicesFault wsf;
        block8: {
            Message responseMsg;
            block9: {
                String outString;
                block10: {
                    log.error(Messages.getMessage("jaxRpcHandlerServerRuntimeException00", handlerName, handlerType), re);
                    wsf = new WebServicesFault(QNameTable.createQName(Constants.DEFAULT_SOAP_VERSION.getEnvelopeURI(), "Server.generalException"), Messages.getMessage("jaxRpcHandlerServerRuntimeException00", handlerName, handlerType), handlerName, null);
                    if (context.isOneWay()) break block8;
                    responseMsg = context.getResponseMessage();
                    if (responseMsg == null) break block9;
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    responseMsg.writeTo(outStream);
                    outString = outStream.toString();
                    Object var11_9 = null;
                    try {
                        outStream.close();
                    }
                    catch (Exception e2) {}
                    break block10;
                    {
                        catch (Exception e) {
                            outString = "!!responseMessage.writeTo() failed!!" + e.toString();
                            Object var11_10 = null;
                            try {
                                outStream.close();
                            }
                            catch (Exception e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        try {
                            outStream.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                log.info(Messages.getMessage("jaxRpcHandlerReplaceResponse00", outString));
            }
            responseMsg = new Message(wsf);
            context.setResponseMessage(responseMsg);
        }
        throw wsf;
    }

    public boolean handleResponse(MessageContext context) throws WebServicesFault {
        LoopControls controls = new LoopControls(this._handlerPools.size() - 1, -1);
        this.handleResponse(context, controls);
        return controls.isResult();
    }

    private void handleResponse(MessageContext context, LoopControls controls) throws WebServicesFault {
        while (!controls.isDone() && controls.idx() >= 0) {
            this.oneHandleResponse(context, controls);
        }
    }

    private void oneHandleResponse(MessageContext context, LoopControls controls) throws WebServicesFault {
        block9: {
            HandlerPool pool2 = (HandlerPool)this._handlerPools.get(controls.idx());
            String handlerName = pool2.getHandlerClassName();
            javax.xml.rpc.handler.Handler handler2 = pool2.get();
            try {
                if (log.isDebugEnabled()) {
                    log.debug(handlerName + ".handleResponse()");
                }
                controls.next();
                controls.setResult(handler2.handleResponse(context));
                pool2.put(handler2);
                if (!controls.isResult()) {
                    controls.setDone(true);
                    this.handleClosure(context, controls);
                    break block9;
                }
                if (controls.isDone() || controls.idx() < 0) break block9;
                try {
                    Message responseMsg = context.getResponseMessage();
                    if (responseMsg != null && responseMsg.isFault()) {
                        this.handleFault(context, controls);
                    }
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.webservices.engine.handler.jaxrpc.JAXRPCHandlerChain.oneHandleResponse", "757", null);
                    throw WebServicesFault.makeFault(ioe);
                }
            }
            catch (RuntimeException re) {
                Throwable t;
                FFDCFilter.processException((Throwable)re, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.oneHandleResponse", "541", this);
                controls.setDone(true);
                if (re instanceof JAXRPCException && (t = WebServicesFault.getRootCause(re)) instanceof WebServicesFault) {
                    pool2.put(handler2);
                    this.handleClosure(context, controls);
                    throw (WebServicesFault)t;
                }
                pool2.faulted(handler2);
                this.handleClosure(context, controls);
                if (context.isServer()) {
                    this.handleRuntimeException(re, context, handlerName, "handleResponse");
                }
                throw WebServicesFault.makeFault(re);
            }
        }
    }

    public void handleClosure(MessageContext context) {
        this.handleClosure(context, this._handlerPools.size() - 1);
    }

    public void handleClosure(MessageContext context, LoopControls controls) {
        int idx = controls.idx();
        controls.clear();
        this.handleClosure(context, idx);
    }

    private void handleClosure(MessageContext context, int first) {
        for (int i = first; i >= 0; --i) {
            HandlerPool pool2;
            if (!(class$com$ibm$wsspi$webservices$rpc$handler$Handler == null ? JAXRPCHandlerChain.class$("com.ibm.wsspi.webservices.rpc.handler.Handler") : class$com$ibm$wsspi$webservices$rpc$handler$Handler).isAssignableFrom((pool2 = (HandlerPool)this._handlerPools.get(i)).getHandlerClass())) continue;
            String handlerName = pool2.getHandlerClassName();
            Handler handler2 = (Handler)pool2.get();
            try {
                if (log.isDebugEnabled()) {
                    log.debug(handlerName + ".handleClosure()");
                }
                handler2.handleClosure(context);
                pool2.put(handler2);
                continue;
            }
            catch (RuntimeException re) {
                pool2.faulted(handler2);
            }
        }
    }

    public boolean handleFault(MessageContext context) throws WebServicesFault {
        LoopControls controls = new LoopControls(this._handlerPools.size() - 1, -1);
        this.handleFault(context, controls);
        return controls.isResult();
    }

    private void handleFault(MessageContext context, LoopControls controls) throws WebServicesFault {
        while (!controls.isDone() && controls.idx() >= 0) {
            this.oneHandleFault(context, controls);
        }
    }

    private void oneHandleFault(MessageContext context, LoopControls controls) throws WebServicesFault {
        HandlerPool pool2 = (HandlerPool)this._handlerPools.get(controls.idx());
        String falseHandlerName = pool2.getHandlerClassName();
        javax.xml.rpc.handler.Handler handler2 = pool2.get();
        try {
            if (log.isDebugEnabled()) {
                log.debug(falseHandlerName + ".handleFault()");
            }
            controls.next();
            controls.setResult(handler2.handleFault(context));
            pool2.put(handler2);
            if (!controls.isResult()) {
                controls.setDone(true);
                this.handleClosure(context, controls);
            }
        }
        catch (RuntimeException re) {
            Throwable t;
            FFDCFilter.processException((Throwable)re, "com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.oneHandleFault", "681", this);
            controls.setDone(true);
            if (re instanceof JAXRPCException && (t = WebServicesFault.getRootCause(re)) instanceof WebServicesFault) {
                pool2.put(handler2);
                this.handleClosure(context, controls);
                throw (WebServicesFault)t;
            }
            pool2.faulted(handler2);
            this.handleClosure(context, controls);
            if (context.isServer()) {
                this.handleRuntimeException(re, context, falseHandlerName, "handleFault");
            }
            throw WebServicesFault.makeFault(re);
        }
    }

    public void setRoles(String[] soapActorNames) {
        this._roles = new TreeSet();
        if (soapActorNames != null && soapActorNames.length > 0) {
            for (int i = 0; i < soapActorNames.length; ++i) {
                String actor = soapActorNames[i];
                this._roles.add(actor == null ? emptyString : actor);
            }
        }
        this.addManditoryRoles();
    }

    public void setRoles(Collection roles) {
        this._roles = new TreeSet();
        if (roles != null && roles.size() > 0) {
            Iterator iter = roles.iterator();
            while (iter.hasNext()) {
                String actor = (String)iter.next();
                this._roles.add(actor == null ? emptyString : actor);
            }
        }
        this.addManditoryRoles();
    }

    private void addManditoryRoles() {
        this._roles.add("http://schemas.xmlsoap.org/soap/actor/next");
        this._roles.add("http://www.w3.org/2002/06/soap-envelope/actor/next");
    }

    public Collection getRoles() {
        return this._roles;
    }

    public Collection getHeaderQNames() {
        return this._headerQNames;
    }

    protected void checkProtectedStateViolation(MessageContext msgContext, String handlerName) throws SOAPFaultException {
    }

    private Object wrapObject(Object element) {
        if (element instanceof HandlerInfo) {
            HandlerInfo handlerInfo = (HandlerInfo)element;
            try {
                QName[] headers = handlerInfo.getHeaders();
                if (headers != null) {
                    for (int hIdx = 0; hIdx < headers.length; ++hIdx) {
                        this._headerQNames.add(headers[hIdx]);
                    }
                }
                return HandlerPoolFactory.createHandlerPool((HandlerInfo)element);
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.webservices.engine.handlers.HandlerChain.newHandlerPool", "170");
                String exStr = ex.getMessage() != null ? ex.getMessage() : JavaUtils.stackToString(ex);
                String translatedMessage = Messages.getMessage("NoJAXRPCHandler00", handlerInfo.getHandlerClass().toString(), exStr);
                log.error(translatedMessage, ex);
                throw new JAXRPCException(translatedMessage, ex);
            }
        }
        throw new JAXRPCException("Internal: improper element type '" + element.getClass().getName() + "' for JAXRPCHandlerChain");
    }

    public void add(int index, Object element) {
        this._handlerPools.add(index, this.wrapObject(element));
    }

    public Object get(int index) {
        return ((HandlerPool)this._handlerPools.get(index)).getOriginalInfo();
    }

    public Object remove(int index) {
        HandlerPool pool2 = (HandlerPool)this._handlerPools.get(index);
        HandlerInfo handlerInfo = pool2.getOriginalInfo();
        pool2.destroy();
        this._handlerPools.remove(index);
        QName[] headers = handlerInfo.getHeaders();
        if (headers != null) {
            for (int hIdx = 0; hIdx < headers.length; ++hIdx) {
                this._headerQNames.remove(headers[hIdx]);
            }
        }
        return handlerInfo;
    }

    public Object set(int index, Object element) {
        return this._handlerPools.set(index, this.wrapObject(element));
    }

    public int size() {
        return this._handlerPools.size();
    }

    private class LoopControls {
        private boolean _done = false;
        private boolean _result = true;
        private int _idx;
        private int _dir;

        LoopControls(int idx, int dir) {
            this._idx = idx;
            this._dir = dir;
        }

        void clear() {
            this._idx = -1;
        }

        void setDone(boolean done) {
            this._done = done;
        }

        void setResult(boolean result) {
            this._result = result;
        }

        boolean isDone() {
            return this._done;
        }

        boolean isResult() {
            return this._result;
        }

        void next() {
            this._idx += this._dir;
        }

        int idx() {
            return this._idx;
        }
    }
}

