/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.handlers;

import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.handlers.EndpointPMIContext;
import com.ibm.ws.webservices.pmi.modules.ModulePmiModule;
import org.apache.commons.logging.Log;

class MessagePMIContext {
    protected static Log log = LogFactory.getLog(MessagePMIContext.class.getName());
    public static final String propertyName = MessagePMIContext.class.getName();
    private final WebServicesPerf.ServicePerf pmiServiceModule;
    private final WebServicesPerf wsPerf;
    private final EndpointPMIContext endpointPmiContext;
    private long receivedRequestTime = 0L;
    private long sentRequestTime = 0L;
    private long receivedReplyTime = 0L;
    private long sentReplyTime = 0L;
    private final long STATE_RECEIVE_REQUEST = 0L;
    private final long STATE_SEND_REQUEST = 1L;
    private final long STATE_RECEIVE_REPLY = 2L;
    private final long STATE_SEND_REPLY = 3L;
    private final long STATE_DONE = 4L;
    private final long NO_TIME = -1L;
    private long next_state = 0L;

    MessagePMIContext(ModulePmiModule pmiModule, MessageContext msgContext, WebServicesPerf pmiServicesModule, String serviceName) {
        this.endpointPmiContext = new EndpointPMIContext(msgContext, pmiModule);
        this.wsPerf = pmiServicesModule;
        this.pmiServiceModule = this.wsPerf.getService(serviceName);
    }

    void onServerReceiveRequest() {
        this.receivedRequestTime = this.doRequestResponseTime() || this.doResponseTime() ? System.currentTimeMillis() : 0L;
        if (this.doReceivedRequestCount()) {
            this.pmiServiceModule.onServerReceiveRequest();
        }
        this.endpointPmiContext.onServerReceiveRequest(this.receivedRequestTime);
        this.next_state = 1L;
    }

    void onServerForwardRequestToPort() {
        if (this.doRequestResponseTime() || this.doDispatchResponseTime()) {
            this.sentRequestTime = System.currentTimeMillis();
            if (this.doRequestResponseTime()) {
                this.pmiServiceModule.onServerForwardRequestToPort(this.sentRequestTime - this.receivedRequestTime);
            } else {
                this.pmiServiceModule.onServerForwardRequestToPort(-1L);
            }
        } else {
            this.sentRequestTime = 0L;
            this.pmiServiceModule.onServerForwardRequestToPort(-1L);
        }
        this.endpointPmiContext.onServerForwardRequestToPort(this.sentRequestTime);
        this.next_state = 2L;
    }

    void onServerReceiveReplyFromPort() {
        if (this.doDispatchResponseTime() || this.doReplyResponseTime()) {
            this.receivedReplyTime = System.currentTimeMillis();
            if (this.doDispatchResponseTime()) {
                this.pmiServiceModule.onServerReceiveReplyFromPort(this.receivedReplyTime - this.sentRequestTime);
            }
        } else {
            this.receivedReplyTime = 0L;
        }
        this.endpointPmiContext.onServerReceiveReplyFromPort(this.receivedReplyTime);
        this.next_state = 3L;
    }

    void onServerReturnReply(MessageContext msgContext) {
        this.sentReplyTime = this.doReplyResponseTime() || this.doResponseTime() ? System.currentTimeMillis() : 0L;
        long requestPayloadSize = this.getRequestLength(msgContext, "requestMessageMissing00");
        long responsePayloadSize = this.getResponseLength(msgContext, "responseMessageMissing00");
        this.pmiServiceModule.onServerReturnReply(this.doProcessedRequestCount(), requestPayloadSize, responsePayloadSize, this.receivedReplyTime > 0L ? this.sentReplyTime - this.receivedReplyTime : -1L, this.sentReplyTime > 0L ? this.sentReplyTime - this.receivedRequestTime : -1L);
        if (this.sentReplyTime == 0L) {
            this.sentReplyTime = System.currentTimeMillis();
        }
        this.endpointPmiContext.onServerReturnReply(this.sentReplyTime, this.sentReplyTime - this.receivedRequestTime, requestPayloadSize, responsePayloadSize);
        this.next_state = 4L;
    }

    void close(MessageContext msgContext, String noResponseMessageKey) {
        this.sentReplyTime = this.doReplyResponseTime() || this.doResponseTime() ? System.currentTimeMillis() : 0L;
        if (this.next_state == 3L && msgContext != null && msgContext.isOneWay()) {
            long requestPayloadSize = this.getRequestLength(msgContext, "requestMessageMissing00");
            this.pmiServiceModule.onServerReturnReply(this.doProcessedRequestCount(), requestPayloadSize, -1L, -1L, this.sentReplyTime - this.receivedRequestTime);
            if (this.sentReplyTime == 0L) {
                this.sentReplyTime = System.currentTimeMillis();
            }
            this.endpointPmiContext.close(msgContext.isOneWay(), this.sentReplyTime, this.sentReplyTime - this.receivedRequestTime, requestPayloadSize, 0L);
        } else if (this.next_state != 4L) {
            long requestPayloadSize = this.getRequestLength(msgContext, "requestMessageMissing00");
            long responsePayloadSize = this.getResponseLength(msgContext, noResponseMessageKey);
            this.pmiServiceModule.onServerReturnReply(false, requestPayloadSize, responsePayloadSize, this.receivedReplyTime > 0L ? this.sentReplyTime - this.receivedReplyTime : -1L, this.sentReplyTime - this.receivedRequestTime);
            if (this.sentReplyTime == 0L) {
                this.sentReplyTime = System.currentTimeMillis();
            }
            this.endpointPmiContext.close(msgContext.isOneWay(), this.sentReplyTime, this.sentReplyTime - this.receivedRequestTime, requestPayloadSize, responsePayloadSize);
        }
        this.next_state = 4L;
    }

    private long getRequestLength(MessageContext msgContext, String noMessageKey) {
        long length;
        if (this.doPayloadSize() || this.doRequestPayloadSize()) {
            if (msgContext == null || msgContext.getRequestMessage() == null) {
                length = -1L;
                if (noMessageKey != null) {
                    log.error(Messages.getMessage(noMessageKey));
                }
            } else {
                Message message = msgContext.getRequestMessage();
                try {
                    boolean savedPastPivot = msgContext.getPastPivot();
                    msgContext.setPastPivot(false);
                    length = message.getOriginalContentLength();
                    if (savedPastPivot) {
                        msgContext.setPastPivot(savedPastPivot);
                    }
                }
                catch (WebServicesFault wsf) {
                    log.debug("Unable to determine message length.", wsf);
                    length = -1L;
                }
            }
        } else {
            length = 0L;
        }
        return length;
    }

    private long getResponseLength(MessageContext msgContext, String noMessageKey) {
        long length;
        if (this.doPayloadSize() || this.doReplyPayloadSize()) {
            if (msgContext == null || msgContext.getResponseMessage() == null) {
                length = -1L;
                if (noMessageKey != null) {
                    log.error(Messages.getMessage(noMessageKey));
                }
            } else {
                Message message = msgContext.getResponseMessage();
                try {
                    length = message.getContentLength();
                }
                catch (WebServicesFault wsf) {
                    log.debug("Unable to determine message length.", wsf);
                    length = -1L;
                }
            }
        } else {
            length = 0L;
        }
        return length;
    }

    public final boolean doResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(14);
    }

    public final boolean doRequestResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(15);
    }

    public final boolean doDispatchResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(16);
    }

    public final boolean doReplyResponseTime() {
        return this.pmiServiceModule.isStatisticEnabled(17);
    }

    public final boolean doPayloadSize() {
        return this.pmiServiceModule.isStatisticEnabled(18);
    }

    public final boolean doRequestPayloadSize() {
        return this.pmiServiceModule.isStatisticEnabled(19);
    }

    public final boolean doReplyPayloadSize() {
        return this.pmiServiceModule.isStatisticEnabled(20);
    }

    public final boolean doReceivedRequestCount() {
        return this.pmiServiceModule.isStatisticEnabled(11);
    }

    public final boolean doDispatchedRequestCount() {
        return this.pmiServiceModule.isStatisticEnabled(12);
    }

    public final boolean doProcessedRequestCount() {
        return this.pmiServiceModule.isStatisticEnabled(13);
    }
}

