/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationWriter;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerFactory;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public final class WebServicesFaultAlternateContent
extends AlternateContentBase {
    protected static Log log = LogFactory.getLog(WebServicesFaultAlternateContent.class.getName());

    public static WebServicesFaultAlternateContent create(WebServicesFault content) {
        return new WebServicesFaultAlternateContent(content, AlternateContentBase.CONTENT_ONLY);
    }

    WebServicesFaultAlternateContent(WebServicesFault content, short contentFlag) {
        super(content, contentFlag);
    }

    protected void serialize(SerializationContext context, boolean includeNSDecls) throws Exception {
        Mapping m;
        MappingScope faultMS;
        if (this.owner.getSOAPFactory().getSOAPConstants().getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            this.serializeSOAP12(context, includeNSDecls);
            return;
        }
        MappingScope ms = null;
        if (includeNSDecls) {
            ms = this._getMappingScopeForAncestorsNotWritten(context);
        }
        if ((faultMS = this._getMappingScope(this.owner)).size() > 0) {
            if (ms == null) {
                ms = new MappingScope();
            }
            Mapping mapping = null;
            String ns = null;
            String prefix = null;
            StringBuffer msDebug = new StringBuffer();
            for (int i = 0; i < faultMS.size(); ++i) {
                mapping = faultMS.get(i);
                if (mapping == null) continue;
                ns = mapping.getNamespaceURI();
                prefix = mapping.getPrefix();
                if (prefix.length() <= 0) continue;
                ms.addMapping(ns, prefix);
                msDebug.append(prefix + " " + ns);
                msDebug.append("\n");
            }
            if (log.isDebugEnabled()) {
                log.debug("MappingScope of Fault: \n" + msDebug);
            }
        }
        QName faultQName = this.owner.getQName();
        String prefix = this.owner.getPrefix();
        if (log.isDebugEnabled()) {
            log.debug("owner QName and prefix: " + faultQName + " " + prefix);
        }
        if ((m = faultMS.getMappingForPrefix(prefix, false)) == null || m != null && !faultQName.getNamespaceURI().equals(m.getNamespaceURI())) {
            if (ms == null) {
                ms = new MappingScope();
            }
            if (log.isDebugEnabled()) {
                log.debug("Will add owner namespace and prefix to MappingScope");
            }
            ms.addMapping(faultQName.getNamespaceURI(), prefix);
        }
        if (log.isDebugEnabled()) {
            log.debug("Serializing these namespaces: " + ms);
        }
        context.getSerializationWriter().startElement(this.owner.getQName(), this.owner.getPrefix(), this.owner.getSAXAttributes(), ms);
        WebServicesFault wsf = (WebServicesFault)this.content;
        if (wsf.getFaultCode() != null) {
            QName qnFaultCode = wsf.getFaultCode();
            String faultCode = qnFaultCode.getNamespaceURI().length() == 0 ? qnFaultCode.getLocalPart() : context.getSerializationWriter().qName2String(qnFaultCode);
            context.getSerializationWriter().simpleElement(Constants.QNAME_FAULTCODE, null, faultCode);
        }
        if (wsf.getFaultString() != null) {
            context.getSerializationWriter().simpleElement(Constants.QNAME_FAULTSTRING, null, wsf.getFaultString());
        }
        if (wsf.getFaultActor() != null) {
            context.getSerializationWriter().simpleElement(Constants.QNAME_FAULTACTOR, null, wsf.getFaultActor());
        }
        if (wsf.getFaultDetails() != null || wsf.getUserException() != null) {
            SOAPFaultException soapFault;
            MessageContext mc = context.getMessageContext();
            String encStyle = mc != null ? mc.getEncodingStyle() : null;
            AttributesImpl attrs = null;
            if (encStyle != null) {
                attrs = new AttributesImpl();
                attrs.addAttribute(this.owner.getQName().getNamespaceURI(), "encodingStyle", "encodingStyle", "CDATA", encStyle);
            }
            MappingScope detailMS = null;
            if (wsf.getUserException() instanceof SOAPFaultException && (soapFault = (SOAPFaultException)wsf.getUserException()).getDetail() != null) {
                detailMS = this._getMappingScope((Detail)soapFault.getDetail());
            }
            if (detailMS != null) {
                log.debug("Will serialize detail element with this MappingScope: " + detailMS);
            }
            context.getSerializationWriter().startElement(Constants.QNAME_FAULTDETAILS, attrs, detailMS);
            try {
                Element[] faultDetails;
                Exception userException = wsf.getUserException();
                if (userException != null && !(userException instanceof SOAPFaultException)) {
                    FaultDesc faultDesc = null;
                    if (context.getMessageContext() != null && context.getMessageContext().getOperation() != null) {
                        faultDesc = context.getMessageContext().getOperation().getFaultByClass(userException.getClass());
                    }
                    if (faultDesc != null && faultDesc.getPartQName() != null) {
                        Object detail = null;
                        SerializerFactory sf = (SerializerFactory)context.getTypeMapping().getSerializer(userException.getClass());
                        detail = sf instanceof CustomSerializerFactory ? userException : JavaUtils.getDetail(userException);
                        QName xmlType = null;
                        Boolean wantXSIType = null;
                        if (detail == userException) {
                            Class<?> javaType = detail.getClass();
                            xmlType = faultDesc.getPartXmlType();
                            QName qName = ((TypeMappingImpl)context.getTypeMapping()).getXMLType(javaType, xmlType);
                            if (xmlType != null && !xmlType.equals(qName)) {
                                wantXSIType = Boolean.TRUE;
                            }
                        }
                        context.serialize(faultDesc.getPartQName(), null, detail, xmlType, false, wantXSIType);
                    }
                }
                if ((faultDetails = wsf.getFaultDetails()) != null) {
                    for (int i = 0; i < faultDetails.length; ++i) {
                        context.getSerializationWriter().writeDOMElement(faultDetails[i]);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.ext.WebServicesFaultAlternateContent.serialize", "142", this);
            }
            context.getSerializationWriter().endElement();
        }
        context.getSerializationWriter().endElement();
        context.outputMultiRefs();
    }

    private void serializeSOAP12(SerializationContext context, boolean includeNSDecls) throws Exception {
        AttributesImpl attrs;
        MappingScope ms = null;
        if (includeNSDecls) {
            ms = this._getMappingScopeForAncestorsNotWritten(context);
        }
        SerializationWriter writer = context.getSerializationWriter();
        writer.startElement(this.owner.getQName(), this.owner.getPrefix(), this.owner.getSAXAttributes(), ms);
        WebServicesFault wsf = (WebServicesFault)this.content;
        SOAPConstants soapConstants = this.owner.getSOAPFactory().getSOAPConstants();
        QName faultCodeQName = soapConstants.getFaultCodeQName();
        QName faultCodeValueQName = soapConstants.getFaultCodeValueQName();
        QName faultSubcodeQName = soapConstants.getFaultSubcodeQName();
        QName faultReasonQName = soapConstants.getFaultStringOrReasonQName();
        QName faultReasonTextQName = soapConstants.getFaultReasonTextQName();
        QName faultNodeQName = soapConstants.getFaultNodeQName();
        QName faultRoleQName = soapConstants.getFaultActorOrRoleQName();
        QName faultDetailQName = soapConstants.getFaultDetailQName();
        QName lang = soapConstants.getXMLLangAttributeQName();
        String prefix = this.owner.getPrefix();
        if (wsf.getFaultCode() != null) {
            writer.startElement(faultCodeQName, null);
            QName qnFaultCode = wsf.getFaultCode();
            String faultCode = qnFaultCode.getNamespaceURI().length() == 0 ? qnFaultCode.getLocalPart() : writer.qName2String(qnFaultCode);
            writer.simpleElement(faultCodeValueQName, prefix, null, faultCode);
            List subcodes = wsf.getSOAP12_Subcodes();
            if (subcodes != null) {
                int i;
                for (i = 0; i < subcodes.size(); ++i) {
                    writer.startElement(faultSubcodeQName, null);
                    QName subcodeQName = (QName)subcodes.get(i);
                    String subcode = subcodeQName.getNamespaceURI().length() == 0 ? subcodeQName.getLocalPart() : writer.qName2String(subcodeQName);
                    writer.simpleElement(faultCodeValueQName, prefix, null, subcode);
                }
                for (i = 0; i < subcodes.size(); ++i) {
                    writer.endElement();
                }
            }
            writer.endElement();
        }
        if (wsf.getFaultString() != null) {
            writer.startElement(faultReasonQName, null);
            String text = wsf.getFaultString();
            String langValue = wsf.getSOAP12_ReasonLanguage();
            if (langValue == null) {
                Locale locale = Locale.getDefault();
                langValue = locale.getLanguage();
            }
            attrs = null;
            if (langValue != null) {
                attrs = new AttributesImpl();
                attrs.addAttribute(lang.getNamespaceURI(), lang.getLocalPart(), "xml:" + lang.getLocalPart(), "CDATA", langValue);
            }
            writer.simpleElement(faultReasonTextQName, prefix, attrs, text);
            List reasons = wsf.getSOAP12_AdditionalReasons();
            if (reasons != null) {
                for (int i = 0; i < reasons.size(); i += 2) {
                    langValue = (String)reasons.get(i);
                    text = (String)reasons.get(i + 1);
                    if (langValue != null) {
                        attrs = new AttributesImpl();
                        attrs.addAttribute(lang.getNamespaceURI(), lang.getLocalPart(), "xml:" + lang.getLocalPart(), "CDATA", langValue);
                    }
                    writer.simpleElement(faultReasonTextQName, prefix, attrs, text);
                }
            }
            writer.endElement();
        }
        if (wsf.getSOAP12_Node() != null) {
            writer.simpleElement(faultNodeQName, prefix, null, wsf.getSOAP12_Node());
        }
        if (wsf.getFaultActor() != null) {
            writer.simpleElement(faultRoleQName, prefix, null, wsf.getFaultActor());
        }
        if (wsf.getFaultDetails() != null || wsf.getUserException() != null) {
            MessageContext mc = context.getMessageContext();
            String encStyle = mc != null ? mc.getEncodingStyle() : null;
            attrs = null;
            if (encStyle != null) {
                attrs = new AttributesImpl();
                attrs.addAttribute(this.owner.getQName().getNamespaceURI(), "encodingStyle", "encodingStyle", "CDATA", encStyle);
            }
            writer.startElement(faultDetailQName, attrs);
            try {
                Element[] faultDetails;
                FaultDesc faultDesc;
                Exception userException = wsf.getUserException();
                if (userException != null && !(userException instanceof SOAPFaultException) && (faultDesc = context.getMessageContext().getOperation().getFaultByClass(userException.getClass())) != null && faultDesc.getPartQName() != null) {
                    Object detail = null;
                    SerializerFactory sf = (SerializerFactory)context.getTypeMapping().getSerializer(userException.getClass());
                    detail = sf instanceof CustomSerializerFactory ? userException : JavaUtils.getDetail(userException);
                    QName xmlType = null;
                    Boolean wantXSIType = null;
                    if (detail == userException) {
                        Class<?> javaType = detail.getClass();
                        xmlType = faultDesc.getPartXmlType();
                        QName qName = ((TypeMappingImpl)context.getTypeMapping()).getXMLType(javaType, xmlType);
                        if (xmlType != null && !xmlType.equals(qName)) {
                            wantXSIType = Boolean.TRUE;
                        }
                    }
                    context.serialize(faultDesc.getPartQName(), null, detail, xmlType, false, wantXSIType);
                }
                if ((faultDetails = wsf.getFaultDetails()) != null) {
                    for (int i = 0; i < faultDetails.length; ++i) {
                        context.getSerializationWriter().writeDOMElement(faultDetails[i]);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.ext.WebServicesFaultAlternateContent.serialize", "142", this);
            }
            writer.endElement();
        }
        writer.endElement();
        context.outputMultiRefs();
    }
}

