/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.WebServicesParser;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class WebServicesParserFactory
extends SAXParserFactory {
    protected static Log log;
    private static WebServicesParserFactory singleton;
    private SAXParserFactory saxParserFactory = null;
    private Stack parsers;
    public int PARSER_STACK_LIMIT = 50;
    public int MAX_PARSER_USAGE = 1000;

    protected WebServicesParserFactory() {
    }

    public static synchronized SAXParserFactory newInstance() {
        if (singleton != null) {
            return singleton;
        }
        singleton = new WebServicesParserFactory();
        WebServicesParserFactory.singleton.saxParserFactory = (SAXParserFactory)WebServicesProperties.newSPIInstance(SAXParserFactory.class);
        return singleton;
    }

    public synchronized SAXParser newSAXParser() {
        if (this.parsers != null && !this.parsers.empty()) {
            return (SAXParser)this.parsers.pop();
        }
        try {
            return new WebServicesParser(this, this.saxParserFactory);
        }
        catch (ParserConfigurationException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.WebServicesParserFactory.getSAXParser", "75");
            log.error(Messages.getMessage("parserConfigurationException00", e.toString()));
            return null;
        }
        catch (SAXException se) {
            FFDCFilter.processException(se, "com.ibm.ws.webservices.engine.utils.WebServicesParserFactory.getSAXParser", "79");
            log.error(Messages.getMessage("SAXException00", se.toString()));
            return null;
        }
        catch (Exception excp) {
            FFDCFilter.processException(excp, "com.ibm.ws.webservices.engine.utils.WebServicesParserFactory.getSAXParser", "107");
            log.error(Messages.getMessage("exception01", excp.toString()));
            return null;
        }
    }

    synchronized boolean recycle(WebServicesParser parser) {
        if (this.parsers == null) {
            this.parsers = new Stack();
        }
        if (parser.getUsageCounter() > this.MAX_PARSER_USAGE) {
            if (log.isDebugEnabled()) {
                log.debug("MAX_PARSER_USAGE exceeded " + parser.getUsageCounter());
            }
            return false;
        }
        if (this.parsers.size() < this.PARSER_STACK_LIMIT) {
            parser.incrementUsageCounter();
            this.parsers.push(parser);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("PARSER_STACK_LIMIT exceeded " + this.parsers.size());
        }
        return false;
    }

    public void setNamespaceAware(boolean value2) {
        this.saxParserFactory.setNamespaceAware(value2);
    }

    public void setValidating(boolean value2) {
        this.saxParserFactory.setValidating(value2);
    }

    public boolean isNamespaceAware() {
        return this.saxParserFactory.isNamespaceAware();
    }

    public boolean isValidating() {
        return this.saxParserFactory.isValidating();
    }

    public void setFeature(String feature, boolean value2) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.saxParserFactory.setFeature(feature, value2);
    }

    public boolean getFeature(String feature) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.saxParserFactory.getFeature(feature);
    }

    static {
        WebServicesProperties.setClassDefault(SAXParserFactory.class, SAXParserFactory.class.getName());
        log = LogFactory.getLog(WebServicesParserFactory.class.getName());
        singleton = null;
    }
}

