/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.Serializable;

public final class Mapping
implements Serializable {
    private String namespaceURI;
    private String prefix;
    private final String EMPTY_STRING = "".intern();

    static Mapping createMapping(String namespaceURI, String prefix) {
        return new Mapping(namespaceURI, prefix);
    }

    private Mapping(String namespaceURI, String prefix) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "namespaceURI"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(Messages.getMessage("null00", "prefix"));
        }
        if (namespaceURI.length() != 0 || prefix.length() != 0) {
            if (namespaceURI.length() == 0) {
                throw new IllegalArgumentException(Messages.getMessage("mapUnqualNamespace00", prefix));
            }
            if ("xmlns".equals(prefix)) {
                throw new IllegalArgumentException(Messages.getMessage("illegalXMLNS00", prefix));
            }
        }
        this.namespaceURI = namespaceURI.length() == 0 ? this.EMPTY_STRING : namespaceURI.intern();
        this.prefix = prefix.length() == 0 ? this.EMPTY_STRING : prefix.intern();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

