/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.jms.JMSConstants;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class JMSURLParser {
    private URL url = null;
    private Properties props = null;
    private int destinationType = 0;
    private static String QueueMode = "/queue";
    private static String TopicMode = "/topic";
    private static String URL_CHARSET = "UTF-8";
    private static String URL_PROPERTY_DELIM = "&";
    private static String SPEC_STR = "jndi:";
    private boolean newProtocol = false;
    private static final TraceComponent _tc = Tr.register(JMSURLParser.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");

    public JMSURLParser(URL url) throws Exception {
        this.setURL(url);
    }

    public void setURL(URL u) throws Exception {
        this.url = u;
        this.parseURL();
    }

    private void parseURL() throws Exception {
        StringTokenizer st;
        String protocol2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseURL");
        }
        this.props = null;
        this.destinationType = 0;
        String destination = null;
        if (this.url == null) {
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "About to parse JMS URL string: [" + this.url.toString() + "]");
        }
        if (!(protocol2 = this.url.getProtocol()).equals("jms")) {
            throw new MalformedURLException(Messages.getMessage("JMS.invalid_protocol", protocol2));
        }
        this.props = new Properties();
        String filePart = this.url.getPath();
        if (filePart.startsWith(SPEC_STR)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "SPEC protocol");
            }
            this.newProtocol = true;
            st = new StringTokenizer(filePart, ":");
            if (st.hasMoreTokens()) {
                st.nextToken();
                if (st.hasMoreTokens()) {
                    destination = st.nextToken();
                } else {
                    throw new MalformedURLException(Messages.getMessage("JMS.InvalidDestinationType", filePart));
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Destination is: " + destination);
            }
            this.setDestination(destination);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "IBM protocol");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Destination type is: " + filePart);
            }
            if (filePart.equalsIgnoreCase(QueueMode)) {
                this.destinationType = 1;
            } else if (filePart.equalsIgnoreCase(TopicMode)) {
                this.destinationType = 2;
            } else {
                throw new MalformedURLException(Messages.getMessage("JMS.InvalidDestinationType", filePart));
            }
        }
        st = new StringTokenizer(this.url.getQuery(), "&|");
        while (st.hasMoreTokens()) {
            String value2;
            String propValuePair = st.nextToken();
            int index = propValuePair.indexOf("=");
            String property = index > -1 ? propValuePair.substring(0, index) : propValuePair;
            String string = value2 = index > -1 ? propValuePair.substring(index + 1) : "";
            if (property == null || value2 == null) continue;
            property = URLDecoder.decode(property, URL_CHARSET);
            value2 = URLDecoder.decode(value2, URL_CHARSET);
            this.props.setProperty(property, value2);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Properties contained in the JMS URL string:\n" + this.props.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseURL");
        }
    }

    public String getProperty(String propertyName, String defaultValue) {
        return this.props.getProperty(propertyName, defaultValue);
    }

    public void setProperty(String propertyName, String value2) {
        if (value2 == null) {
            this.props.remove(propertyName);
        } else {
            this.props.setProperty(propertyName, value2);
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public int getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(int value2) {
        this.destinationType = value2;
    }

    public String getDestination() {
        return this.getProperty("destination", null);
    }

    public void setDestination(String destination) {
        this.setProperty("destination", destination);
    }

    public String getConnectionFactory() {
        if (this.newProtocol) {
            return this.getProperty("jndiConnectionFactoryName", null);
        }
        return this.getProperty("connectionFactory", null);
    }

    public void setConnectionFactory(String factoryName) {
        if (this.newProtocol) {
            this.setProperty("jndiConnectionFactoryName", factoryName);
        } else {
            this.setProperty("connectionFactory", factoryName);
        }
    }

    public String getTargetService() {
        return this.getProperty("targetService", null);
    }

    public void setTargetService(String targetService) {
        this.setProperty("targetService", targetService);
    }

    public String getJndiProviderURL() {
        if (this.newProtocol) {
            return this.getProperty("jndiURL", null);
        }
        return this.getProperty("jndiProviderURL", null);
    }

    public void setJndiProviderURL(String providerURL) {
        if (this.newProtocol) {
            this.setProperty("jndiURL", providerURL);
        } else {
            this.setProperty("jndiProviderURL", providerURL);
        }
    }

    public String getInitialContextFactory() {
        if (this.newProtocol) {
            return this.getProperty("jndiInitialContextFactory", null);
        }
        return this.getProperty("initialContextFactory", null);
    }

    public void setInitialContextFactory(String icfClassname) {
        this.setProperty("initialContextFactory", icfClassname);
    }

    public String getTimeToLive() {
        return this.getProperty("timeToLive", null);
    }

    public void setTimeToLive(int value2) {
        this.setProperty("timeToLive", Integer.toString(value2));
    }

    public String getDeliveryMode() {
        return this.getProperty("deliveryMode", null);
    }

    public void setDeliveryMode(int value2) {
        this.setProperty("deliveryMode", Integer.toString(value2));
    }

    public String getMessageType() {
        return this.getProperty("messageType", JMSConstants.MESSAGETYPE_DEFAULT_STR);
    }

    public void setMessageType(String value2) {
        this.setProperty("messageType", value2);
    }

    public String getPriority() {
        return this.getProperty("priority", null);
    }

    public void setPriority(int value2) {
        this.setProperty("priority", Integer.toString(value2));
    }

    public String getReplyTo() {
        if (this.newProtocol) {
            return this.getProperty("replyToName", null);
        }
        return this.getProperty("replyToDestination", null);
    }

    public void setReplyTo(String value2) {
        if (this.newProtocol) {
            this.setProperty("replyToName", value2);
        } else {
            this.setProperty("replyToDestination", value2);
        }
    }

    public String getURLString() throws Exception {
        String destination = this.getDestination();
        String connectionFactory = this.getConnectionFactory();
        String targetService = this.getTargetService();
        if (destination == null || destination.length() == 0 || connectionFactory == null || connectionFactory.length() == 0 || targetService == null || targetService.length() == 0) {
            throw new MalformedURLException(Messages.getMessage("JMS.MissingRequiredProperties"));
        }
        StringBuffer buf = new StringBuffer();
        if (this.newProtocol) {
            buf.append("jms:jndi");
        } else {
            int destType = this.getDestinationType();
            if (destType != 1 && destType != 2) {
                throw new MalformedURLException(Messages.getMessage("JMS.InvalidDestinationType", Integer.toString(destType)));
            }
            buf.append("jms:");
            if (destType == 1) {
                buf.append("/queue");
            } else {
                buf.append("/topic");
            }
        }
        buf.append("?");
        boolean needDelimiter = false;
        Enumeration<?> names = this.props.propertyNames();
        while (names.hasMoreElements()) {
            String name2 = (String)names.nextElement();
            String value2 = this.getProperty(name2, null);
            if (needDelimiter) {
                buf.append(URL_PROPERTY_DELIM);
            } else {
                needDelimiter = true;
            }
            buf.append(URLEncoder.encode(name2, URL_CHARSET) + "=");
            if (value2 == null) continue;
            buf.append(URLEncoder.encode(value2, URL_CHARSET));
        }
        return buf.toString();
    }

    public String toString() {
        String urlString = null;
        try {
            urlString = this.getURLString();
        }
        catch (Exception e) {
            urlString = Messages.getMessage("JMS.no_url_string", e.toString());
        }
        String s = null;
        if (this.newProtocol) {
            s = new String("JMSURLParserNew contains:\n  Properties: " + this.props.toString() + "\n  URL String: " + urlString);
        } else {
            String d = new String(this.destinationType == 1 ? "queue" : "topic");
            s = new String("JMSURLParser contains:\n  Destination Type: " + d + "\n  Properties: " + this.props.toString() + "\n  URL String: " + urlString);
        }
        return s;
    }

    static {
        Protocols.init();
    }
}

