/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.jms.JMSCacheData;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.JMSException;

public class JMSConnectionCache {
    private static final TraceComponent _tc = Tr.register(JMSConnectionCache.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    private static JMSConnectionCache singleton = null;
    private Hashtable activeConnections = new Hashtable();

    private JMSConnectionCache() {
    }

    public static JMSConnectionCache newInstance() {
        if (singleton == null) {
            singleton = new JMSConnectionCache();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "JMSConnectionCache created.");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSConnectionCache doesn't need created.");
        }
        return singleton;
    }

    public JMSCacheData get(String key) {
        return (JMSCacheData)this.activeConnections.get(key);
    }

    public void put(String key, JMSCacheData data) {
        this.activeConnections.put(key, data);
    }

    public void put(String key, Connection cData) {
        JMSCacheData data = new JMSCacheData(cData);
        this.put(key, data);
    }

    public void closeConnection(String key) throws WebServicesFault {
        Connection conn;
        JMSCacheData data = this.get(key);
        if (data != null && (conn = data.getConnection()) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "JMSConnectionCache closing connection " + key);
            }
            try {
                conn.close();
            }
            catch (JMSException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSConnectionCache.closeConnection", "102", this);
                Tr.error(_tc, "JMS.JMSError01", e.toString());
                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", e.toString()), null, null);
            }
        }
    }

    public void closeConnections() throws WebServicesFault {
        Enumeration keys = this.activeConnections.keys();
        while (keys.hasMoreElements()) {
            this.closeConnection((String)keys.nextElement());
        }
    }
}

