/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.Config;
import com.ibm.ws.webservices.engine.transport.OneWayConnectionMap;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache;
import com.ibm.ws.webservices.engine.transport.channel.OutboundOutputStream;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSCFEndPointCriteriaImpl;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPCookieManager;
import com.ibm.ws.webservices.engine.transport.http.HTTPSessionContext;
import com.ibm.ws.webservices.engine.transport.http.HttpChannelAddress;
import com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection;
import com.ibm.ws.webservices.engine.transport.http.OneWayConnection;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSLProvider;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPrompt;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPromptFactory;
import com.ibm.ws.webservices.engine.transport.security.WSConfigSSLChangeListener;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.SelectionRule;
import com.ibm.wsspi.cluster.selection.rule.AttributeRule;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;

public class HTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog(HTTPSender.class.getName());
    private static final TraceComponent _tc = Tr.register(HTTPSender.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static boolean UseNewCookieHandling = false;
    private static String IN_PROCESS_ENABLED = null;
    private static long oneWayRecycleTime = Long.valueOf(System.getProperty("com.ibm.websphere.webservices.http.OneWayConnectionRecycleTime", "0")) * 1000L;
    private StringBuffer hashKeyCode = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext msgContext) throws WebServicesFault {
        block126: {
            OutboundConnectionCache oCache;
            WSOutboundConnection ovc;
            block128: {
                MessageContext currMC;
                block127: {
                    Object wsCB;
                    Object asyncResponse;
                    Object redirectFlag;
                    block116: {
                        block123: {
                            block125: {
                                block124: {
                                    block115: {
                                        if (_tc.isEntryEnabled()) {
                                            Tr.entry(_tc, "HTTPSender::invoke");
                                        }
                                        ovc = null;
                                        boolean callbackDisabled = false;
                                        oCache = (OutboundConnectionCache)AccessController.doPrivileged(new PrivilegedAction(){

                                            public Object run() {
                                                return OutboundConnectionCache.getInstance();
                                            }
                                        });
                                        WSChannelManager wMgr = WSChannelManager.getInstance();
                                        Object connectingAddr = null;
                                        currMC = MessageContext.getCurrentThreadsContext();
                                        redirectFlag = currMC.getProperty("com.ibm.ws.wsaddressing.RedirectRequired");
                                        asyncResponse = currMC.getProperty(HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE);
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "com.ibm.ws.wsaddressing.RedirectRequired: " + (redirectFlag == null ? "" : redirectFlag));
                                        }
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, HTTPConstants.MC_HTTP_OUTBOUND_ASYNC_RESPONSE + ": " + (asyncResponse == null ? "" : asyncResponse));
                                        }
                                        wsCB = null;
                                        try {
                                            try {
                                                block122: {
                                                    block120: {
                                                        Identity id;
                                                        block121: {
                                                            WSCFEndPointCriteriaImpl wsEPCrit;
                                                            URL targetURL;
                                                            block119: {
                                                                block118: {
                                                                    block113: {
                                                                        targetURL = msgContext.getTargetEndpointAddressAsURL();
                                                                        wsEPCrit = null;
                                                                        wsEPCrit = targetURL.getProtocol().equalsIgnoreCase("http") ? new WSCFEndPointCriteriaImpl(1) : new WSCFEndPointCriteriaImpl(2);
                                                                        if (_tc.isDebugEnabled()) {
                                                                            Tr.debug(_tc, "javax.xml.rpc.service.endpoint.address: " + targetURL.toString());
                                                                        }
                                                                        connectingAddr = WSAddress.getAddress(targetURL);
                                                                        id = wMgr.clusterIdenFromEPR(wsEPCrit);
                                                                        if (id != null) break block118;
                                                                        if (_tc.isDebugEnabled()) {
                                                                            Tr.debug(_tc, Messages.getMessage("clusterFromWsAddr", String.valueOf(id)));
                                                                        }
                                                                        TransportClientProperties tcpProp = TransportClientPropertiesFactory.create(targetURL.getProtocol());
                                                                        if (_tc.isDebugEnabled()) {
                                                                            Tr.debug(_tc, "Original " + targetURL.getProtocol() + " transport client properties:\n" + ((Object)tcpProp).toString());
                                                                        }
                                                                        if ((connectingAddr = HttpChannelAddress.getProxyAddress(targetURL, tcpProp)) == null) {
                                                                            connectingAddr = WSAddress.getAddress(targetURL);
                                                                        } else if (_tc.isDebugEnabled()) {
                                                                            Tr.debug(_tc, Messages.getMessage("targetAddress01", connectingAddr.toString()));
                                                                        }
                                                                        if (_tc.isDebugEnabled()) {
                                                                            Tr.debug(_tc, "Updated " + targetURL.getProtocol() + " transport client properties:\n" + ((Object)tcpProp).toString());
                                                                        }
                                                                        if (wMgr.getRuntime() == 3 || wMgr.isEPRFragile()) break block119;
                                                                        if (IN_PROCESS_ENABLED == null) {
                                                                            try {
                                                                                Log log = HTTPSender.log;
                                                                                synchronized (log) {
                                                                                    if (IN_PROCESS_ENABLED == null) {
                                                                                        Class c_WebContainer;
                                                                                        if (_tc.isDebugEnabled()) {
                                                                                            Tr.debug(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                                                        }
                                                                                        if ((c_WebContainer = ClassUtils.forName("com.ibm.wsspi.webcontainer.WebContainer")) != null) {
                                                                                            Method m_getWebContainerProperties;
                                                                                            Properties prop;
                                                                                            if (_tc.isDebugEnabled()) {
                                                                                                Tr.debug(_tc, Messages.getMessage("invokeMethod00", "getWebContainerProperties", "com.ibm.wsspi.webcontainer.WebContainer"));
                                                                                            }
                                                                                            if ((prop = (Properties)(m_getWebContainerProperties = c_WebContainer.getMethod("getWebContainerProperties", null)).invoke(null, null)) != null) {
                                                                                                IN_PROCESS_ENABLED = prop.getProperty("enableinprocessconnections");
                                                                                            }
                                                                                        }
                                                                                        if (IN_PROCESS_ENABLED == null) {
                                                                                            IN_PROCESS_ENABLED = "null";
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                            catch (Exception ex) {
                                                                                if (IN_PROCESS_ENABLED == null) {
                                                                                    IN_PROCESS_ENABLED = "null";
                                                                                }
                                                                                if (!_tc.isDebugEnabled()) break block113;
                                                                                Tr.debug(_tc, ex.toString() + " is caught. Failed to read WebContainer properties. Proceed with HTTP in-process connection disabled.");
                                                                            }
                                                                        }
                                                                    }
                                                                    if (_tc.isDebugEnabled()) {
                                                                        Tr.debug(_tc, "enableInProcessConnections : " + IN_PROCESS_ENABLED);
                                                                    }
                                                                    String rrdEnabled = MessageContext.getCurrentThreadsContext().getStrProp("com.ibm.ws.webservices.rrdEnabled");
                                                                    if (_tc.isDebugEnabled()) {
                                                                        Tr.debug(_tc, "com.ibm.ws.webservices.rrdEnabled: " + (rrdEnabled == null ? "" : rrdEnabled));
                                                                    }
                                                                    if (IN_PROCESS_ENABLED != null && IN_PROCESS_ENABLED.equalsIgnoreCase("true") || Boolean.valueOf(rrdEnabled).booleanValue()) {
                                                                        id = wMgr.clusterIdenFromDWLMClient((WSAddress)connectingAddr, wsEPCrit);
                                                                        if (_tc.isDebugEnabled()) {
                                                                            Tr.debug(_tc, Messages.getMessage("clusterFromRequestMapper", String.valueOf(id), connectingAddr.toString()));
                                                                        }
                                                                    }
                                                                    break block119;
                                                                }
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, Messages.getMessage("clusterFromWsAddr", String.valueOf(id)));
                                                                }
                                                                if (msgContext.isPropertyTrue("com.ibm.ws.wsaddressing.UCFCallback.disable")) {
                                                                    callbackDisabled = true;
                                                                }
                                                            }
                                                            if (id == null) break block120;
                                                            CFEndPoint cfEP = null;
                                                            HashMap<String, SelectionRule[]> contextMap = (HashMap<String, SelectionRule[]>)msgContext.getProperty("com.ibm.ws.webservices.wlmselectioncriteria");
                                                            if (_tc.isDebugEnabled()) {
                                                                Tr.debug(_tc, "com.ibm.ws.webservices.wlmselectioncriteria: " + (contextMap == null ? "" : ((Object)contextMap).toString()));
                                                            }
                                                            if (wsEPCrit.getEPRtype() == 1) {
                                                                String[] sessionids;
                                                                String cookieValue;
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, "Encountered WLM EPR. Check for session affinity information.");
                                                                }
                                                                if ((cookieValue = this.getCookieValue("SSLJSESSION", currMC, (WSAddress)connectingAddr)) == null) {
                                                                    cookieValue = this.getCookieValue("JSESSIONID", currMC, (WSAddress)connectingAddr);
                                                                    if (cookieValue != null && _tc.isDebugEnabled()) {
                                                                        Tr.debug(_tc, "JSESSIONID=" + cookieValue);
                                                                    }
                                                                } else if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, "SSLJSESSION=" + cookieValue);
                                                                }
                                                                if (cookieValue != null && (sessionids = cookieValue.split(":")) != null && sessionids.length > 1) {
                                                                    int idSize = sessionids.length;
                                                                    SelectionRule[] sRule = new SelectionRule[idSize];
                                                                    for (int i = 1; i < idSize; ++i) {
                                                                        HashSet<String> attrSet = new HashSet<String>();
                                                                        attrSet.add(sessionids[i]);
                                                                        sRule[idSize - i - 1] = new AttributeRule(attrSet);
                                                                    }
                                                                    sRule[idSize - 1] = new DefaultRule();
                                                                    if (contextMap == null) {
                                                                        contextMap = new HashMap<String, SelectionRule[]>();
                                                                    }
                                                                    if (_tc.isDebugEnabled()) {
                                                                        Tr.debug(_tc, "Setting rules.precedence");
                                                                    }
                                                                    contextMap.put("rules.precedence", sRule);
                                                                }
                                                            }
                                                            if ((cfEP = wMgr.identityToCFEndPoint(id, wsEPCrit, contextMap, callbackDisabled)) == null) break block121;
                                                            String actualURL = targetURL.getProtocol() + "://";
                                                            actualURL = cfEP.isLocal() ? actualURL + cfEP.getAddress().getHostAddress() : actualURL + cfEP.getAddress().getHostName();
                                                            actualURL = actualURL + ":" + cfEP.getPort() + targetURL.getFile();
                                                            connectingAddr = WSAddress.getAddress(new URL(actualURL));
                                                            ((WSAddress)connectingAddr).setCFEndPoint(cfEP);
                                                            if (cfEP.isLocal()) {
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, Messages.getMessage("usedHttpChannelType", "In-process"));
                                                                }
                                                                break block122;
                                                            } else if (_tc.isDebugEnabled()) {
                                                                Tr.debug(_tc, Messages.getMessage("usedHttpChannelType", "Network"));
                                                            }
                                                            break block122;
                                                        }
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, Messages.getMessage("cannotConvertCFEndPt", String.valueOf(id)));
                                                        }
                                                        break block122;
                                                    }
                                                    if (_tc.isDebugEnabled()) {
                                                        Tr.debug(_tc, Messages.getMessage("usedHttpChannelType", "Network"));
                                                    }
                                                }
                                                if (_tc.isDebugEnabled()) {
                                                    Tr.debug(_tc, Messages.getMessage("targetAddress00", connectingAddr.toString()));
                                                }
                                                if (((WSAddress)connectingAddr).getSchema() == 2) {
                                                    this.setupEffectiveSSLConfiguration((WSAddress)connectingAddr);
                                                }
                                                Message currReqMC = currMC.getRequestMessage();
                                                String reqContentType = currReqMC.getContentType(currMC.getSOAPConstants());
                                                if (_tc.isDebugEnabled()) {
                                                    Tr.debug(_tc, "HTTP Content-Type: " + reqContentType);
                                                }
                                                OutboundOutputStream bytestream = new OutboundOutputStream(reqContentType);
                                                currReqMC.writeTo(bytestream);
                                                currReqMC.removeAllAttachments();
                                                int rcInt = 0;
                                                Integer rc = null;
                                                String propValue = null;
                                                boolean completed = false;
                                                while (!completed) {
                                                    boolean resendEnabled;
                                                    ovc = oCache.findGroupAndGetConnection((WSAddress)connectingAddr);
                                                    try {
                                                        if (ovc == null) throw new WebServicesFault("No WSOutboundConnection object returned from outbound connection pool.");
                                                        if (MessageTrace.isTraceEnabled() && reqContentType != null && bytestream != null) {
                                                            MessageTrace.log(MessageTrace.OUTBOUND_HTTP_REQUEST, reqContentType, bytestream.toByteArray());
                                                        }
                                                        ovc.connect();
                                                        if (redirectFlag != null && asyncResponse != null) {
                                                            if (_tc.isDebugEnabled()) {
                                                                Tr.debug(_tc, Messages.getMessage("redirectedAsyncDelivery", ovc.toString()));
                                                            }
                                                            wsCB = ovc.sendSOAPRequestAsync(bytestream);
                                                        } else {
                                                            ovc.sendSOAPRequest(bytestream);
                                                        }
                                                    }
                                                    catch (SocketTimeoutException sox) {
                                                        FFDCFilter.processException((Throwable)sox, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "612", this);
                                                        TransportClientProperties tp = TransportClientPropertiesFactory.create(((WSAddress)connectingAddr).getSchemaInString());
                                                        resendEnabled = false;
                                                        resendEnabled = ((DefaultHTTPTransportClientProperties)tp).isResendEnabled();
                                                        if (!ovc.hasbeenUsed()) throw WebServicesFault.makeFault(sox);
                                                        if (ovc.isMessageSent()) throw WebServicesFault.makeFault(sox);
                                                        if (resendEnabled) throw WebServicesFault.makeFault(sox);
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, "SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                                                        }
                                                        ovc.disconnect(sox);
                                                        oCache.findGroupAndReturnConnection(ovc);
                                                        continue;
                                                    }
                                                    catch (SocketException sx) {
                                                        FFDCFilter.processException((Throwable)sx, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "641", this);
                                                        TransportClientProperties tp = TransportClientPropertiesFactory.create(((WSAddress)connectingAddr).getSchemaInString());
                                                        resendEnabled = false;
                                                        resendEnabled = ((DefaultHTTPTransportClientProperties)tp).isResendEnabled();
                                                        if (!ovc.hasbeenUsed()) throw WebServicesFault.makeFault(sx);
                                                        if (ovc.isMessageSent()) throw WebServicesFault.makeFault(sx);
                                                        if (resendEnabled) throw WebServicesFault.makeFault(sx);
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, "SOAP message has not been sent and messageResend is disabled. Use another connection object.");
                                                        }
                                                        ovc.disconnect(sx);
                                                        oCache.findGroupAndReturnConnection(ovc);
                                                        continue;
                                                    }
                                                    if (redirectFlag != null && asyncResponse != null) {
                                                        completed = true;
                                                        continue;
                                                    }
                                                    ovc.receiveSOAPResponse();
                                                    rc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                                                    propValue = msgContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                                                    if (rc != null) {
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, Messages.getMessage("httpStatusInResponse00", rc.toString(), propValue));
                                                        }
                                                        if ((rcInt = rc.intValue()) == HttpConstants.STATUS_FOUND.getIntCode()) {
                                                            if (!HTTPSender.isHttpRedirectEnabled()) {
                                                                completed = true;
                                                                throw new WebServicesFault(Messages.getMessage("http302StatusCode", connectingAddr.toString()));
                                                            }
                                                            propValue = msgContext.getStrProp(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                                                            if (JavaUtils.hasValue(propValue)) {
                                                                connectingAddr = WSAddress.getAddress(new URL(propValue));
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, Messages.getMessage("http302StatusCode", connectingAddr.toString()));
                                                                }
                                                                if (ovc.getTargetAddress().getSchema() == 2) {
                                                                    this.restoreSSLConfiguration(ovc);
                                                                }
                                                                ovc.disconnect(null);
                                                                oCache.findGroupAndReturnConnection(ovc);
                                                                ovc = null;
                                                                if (((WSAddress)connectingAddr).getSchema() == 2) {
                                                                    this.setupEffectiveSSLConfiguration((WSAddress)connectingAddr);
                                                                }
                                                            } else {
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, Messages.getMessage("http302StatusCode", ""));
                                                                }
                                                                completed = true;
                                                            }
                                                            msgContext.removeProperty(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                                                            continue;
                                                        }
                                                        if (rcInt == HttpConstants.STATUS_UNAUTHORIZED.getIntCode()) {
                                                            if (wMgr.getRuntime() != 1) {
                                                                String hdr_www_authenticate = msgContext.getStrProp("WWW-Authenticate");
                                                                boolean spnegoUsed = (Boolean)msgContext.getProperty("com.ibm.ws.webservices.spnegoUsed");
                                                                if (spnegoUsed && hdr_www_authenticate != null && hdr_www_authenticate.indexOf("Negotiate") == 0) {
                                                                    Tr.debug(_tc, "WWW-Authenticate: " + hdr_www_authenticate);
                                                                    completed = true;
                                                                    continue;
                                                                }
                                                                if (this.receivedHTTPBasicAuth()) {
                                                                    Tr.debug(_tc, Messages.getMessage("challengeStatus01"));
                                                                    ovc.reset();
                                                                    oCache.findGroupAndReturnConnection(ovc);
                                                                    ovc = null;
                                                                    continue;
                                                                }
                                                                Tr.debug(_tc, Messages.getMessage("challengeStatus02"));
                                                                completed = true;
                                                                continue;
                                                            }
                                                            completed = true;
                                                            continue;
                                                        }
                                                        completed = true;
                                                        continue;
                                                    }
                                                    completed = true;
                                                }
                                                bytestream.reset();
                                                if (redirectFlag != null && asyncResponse != null) {
                                                    Object var25_32 = null;
                                                    break block115;
                                                }
                                                if (rcInt == 0) throw new WebServicesFault(Messages.getMessage("httpStatusInResponse01"));
                                                String contentType = ((HttpOutboundChannelConnection)ovc).getHeaderFromResponse(HttpConstants.HDR_CONTENT_TYPE);
                                                this.processStatusCode(rcInt, contentType, (WSAddress)connectingAddr);
                                                break block116;
                                            }
                                            catch (Exception e) {
                                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "815", this);
                                                if (_tc.isDebugEnabled()) {
                                                    Tr.debug(_tc, Messages.getMessage("exception01", e.toString()));
                                                    if (JavaUtils.hasValue(connectingAddr.toString())) {
                                                        Tr.debug(_tc, "URL = " + connectingAddr.toString());
                                                    } else {
                                                        Tr.debug(_tc, "URL = " + msgContext.getTargetEndpointAddress());
                                                    }
                                                }
                                                if (ovc == null) throw WebServicesFault.makeFault(e);
                                                ovc.disconnect(e);
                                                throw WebServicesFault.makeFault(e);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            block117: {
                                                Object var25_34 = null;
                                                try {
                                                    if (ovc == null) break block117;
                                                    if (ovc.getTargetAddress().getSchema() == 2) {
                                                        this.restoreSSLConfiguration(ovc);
                                                    }
                                                    if (redirectFlag != null && asyncResponse != null) {
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, Messages.getMessage("returnOCforAsyncDelivery", ovc.toString(), wsCB.toString()));
                                                        }
                                                        break block117;
                                                    }
                                                    if (currMC.isOneWay()) {
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, "One-way ? " + currMC.isOneWay());
                                                        }
                                                        if (_tc.isDebugEnabled()) {
                                                            Tr.debug(_tc, "One way connection recycle time : " + oneWayRecycleTime + " ms.");
                                                        }
                                                        if (oneWayRecycleTime > 0L) {
                                                            if (_tc.isDebugEnabled()) {
                                                                Tr.debug(_tc, "Creating hash key");
                                                            }
                                                            this.hashKeyCode = new StringBuffer(String.valueOf(ovc.hashCode()));
                                                            this.hashKeyCode.append(String.valueOf(System.currentTimeMillis()));
                                                            if (!this.saveOneWayConnectionToMap(ovc)) {
                                                                if (_tc.isDebugEnabled()) {
                                                                    Tr.debug(_tc, "Could not save connection. Resetting the connection");
                                                                }
                                                                ovc.reset();
                                                                oCache.findGroupAndReturnConnection(ovc);
                                                                ovc = null;
                                                            }
                                                            break block117;
                                                        }
                                                        ovc.reset();
                                                        oCache.findGroupAndReturnConnection(ovc);
                                                        ovc = null;
                                                        break block117;
                                                    }
                                                    ovc.reset();
                                                    oCache.findGroupAndReturnConnection(ovc);
                                                    ovc = null;
                                                }
                                                catch (Exception ex) {
                                                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "902", this);
                                                    if (!_tc.isDebugEnabled()) throw WebServicesFault.makeFault(ex);
                                                    Tr.debug(_tc, Messages.getMessage("exception01", ex.toString()));
                                                    throw WebServicesFault.makeFault(ex);
                                                }
                                            }
                                            if (!_tc.isEntryEnabled()) throw throwable;
                                            Tr.exit(_tc, "HTTPSender::invoke");
                                            throw throwable;
                                        }
                                    }
                                    try {}
                                    catch (Exception ex) {
                                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "902", this);
                                        if (!_tc.isDebugEnabled()) throw WebServicesFault.makeFault(ex);
                                        Tr.debug(_tc, Messages.getMessage("exception01", ex.toString()));
                                        throw WebServicesFault.makeFault(ex);
                                    }
                                    if (ovc == null) break block123;
                                    if (ovc.getTargetAddress().getSchema() == 2) {
                                        this.restoreSSLConfiguration(ovc);
                                    }
                                    if (redirectFlag == null || asyncResponse == null) break block124;
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, Messages.getMessage("returnOCforAsyncDelivery", ovc.toString(), wsCB.toString()));
                                    }
                                    break block123;
                                }
                                if (!currMC.isOneWay()) break block125;
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "One-way ? " + currMC.isOneWay());
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "One way connection recycle time : " + oneWayRecycleTime + " ms.");
                                }
                                if (oneWayRecycleTime > 0L) {
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Creating hash key");
                                    }
                                    this.hashKeyCode = new StringBuffer(String.valueOf(ovc.hashCode()));
                                    this.hashKeyCode.append(String.valueOf(System.currentTimeMillis()));
                                    if (!this.saveOneWayConnectionToMap(ovc)) {
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Could not save connection. Resetting the connection");
                                        }
                                        ovc.reset();
                                        oCache.findGroupAndReturnConnection(ovc);
                                        ovc = null;
                                    }
                                    break block123;
                                } else {
                                    ovc.reset();
                                    oCache.findGroupAndReturnConnection(ovc);
                                    ovc = null;
                                }
                                break block123;
                            }
                            ovc.reset();
                            oCache.findGroupAndReturnConnection(ovc);
                            ovc = null;
                        }
                        if (!_tc.isEntryEnabled()) return;
                        Tr.exit(_tc, "HTTPSender::invoke");
                        return;
                    }
                    Object var25_33 = null;
                    try {}
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "902", this);
                        if (!_tc.isDebugEnabled()) throw WebServicesFault.makeFault(ex);
                        Tr.debug(_tc, Messages.getMessage("exception01", ex.toString()));
                        throw WebServicesFault.makeFault(ex);
                    }
                    if (ovc == null) break block126;
                    if (ovc.getTargetAddress().getSchema() == 2) {
                        this.restoreSSLConfiguration(ovc);
                    }
                    if (redirectFlag == null || asyncResponse == null) break block127;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, Messages.getMessage("returnOCforAsyncDelivery", ovc.toString(), wsCB.toString()));
                    }
                    break block126;
                }
                if (!currMC.isOneWay()) break block128;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "One-way ? " + currMC.isOneWay());
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "One way connection recycle time : " + oneWayRecycleTime + " ms.");
                }
                if (oneWayRecycleTime > 0L) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Creating hash key");
                    }
                    this.hashKeyCode = new StringBuffer(String.valueOf(ovc.hashCode()));
                    this.hashKeyCode.append(String.valueOf(System.currentTimeMillis()));
                    if (!this.saveOneWayConnectionToMap(ovc)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Could not save connection. Resetting the connection");
                        }
                        ovc.reset();
                        oCache.findGroupAndReturnConnection(ovc);
                        ovc = null;
                    }
                    break block126;
                } else {
                    ovc.reset();
                    oCache.findGroupAndReturnConnection(ovc);
                    ovc = null;
                }
                break block126;
            }
            ovc.reset();
            oCache.findGroupAndReturnConnection(ovc);
            ovc = null;
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "HTTPSender::invoke");
    }

    public boolean saveOneWayConnectionToMap(WSOutboundConnection ovc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender.saveOneWayConnectionToMap()...");
        }
        boolean result = false;
        String key = null;
        key = this.hashKeyCode.toString();
        OneWayConnectionMap oWConnMap = OneWayConnectionMap.getInstance();
        OneWayConnection oWConn = new OneWayConnection(ovc, oneWayRecycleTime);
        if (!oWConnMap.containsKey(key)) {
            oWConnMap.putConnection(key, oWConn);
            if (_tc.isEventEnabled()) {
                Tr.debug(_tc, "Creating and adding one way connection " + oWConn + " to cache with key: " + key);
            }
            result = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender.saveOneWayConnectionToMap() : " + result);
        }
        return result;
    }

    private String getCookieValue(String CookieName, MessageContext currMC, WSAddress connectingAddr) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::getCookieValue(" + CookieName + ")");
        }
        String values = null;
        String cookiestring = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Get value of cookie: " + CookieName);
        }
        if (currMC.getMaintainSession()) {
            Object sc;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "javax.xml.rpc.session.maintain:  TRUE");
            }
            if ((sc = currMC.getProperty("com.ibm.ws.webservices.engine.session.context")) != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders() : msgContext = " + currMC.toString() + " SessionContext = " + sc);
                }
                if (UseNewCookieHandling = HTTPCookieManager.newCookieHandling()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "New Cookie Management Handling HTTPCookieManager object: " + sc);
                    }
                    URL targetURL = currMC.getTargetEndpointAddressAsURL();
                    String path = targetURL.getPath();
                    String domain = targetURL.getHost();
                    int port2 = targetURL.getPort();
                    boolean secure = false;
                    if (connectingAddr.getSchema() == 2) {
                        secure = true;
                    }
                    if ((cookiestring = ((HTTPCookieManager)sc).getCookie(path, domain, port2, secure)) != null) {
                        values = this.parseCookieString(cookiestring, CookieName);
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Old Cookie Management Handling HTTPSessionContext object: " + sc);
                    }
                    if ((cookiestring = ((HTTPSessionContext)sc).getCookie()) != null) {
                        values = this.parseCookieString(cookiestring, CookieName);
                    }
                    if ((cookiestring == null || values == null) && (cookiestring = ((HTTPSessionContext)sc).getCookie2()) != null) {
                        values = this.parseCookieString(cookiestring, CookieName);
                    }
                }
            }
        }
        if (values == null) {
            HashMap reqHeaders = (HashMap)currMC.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.websphere.webservices.requestTransportProperties: " + reqHeaders);
            }
            if (reqHeaders != null) {
                cookiestring = (String)reqHeaders.get("Cookie");
                if (cookiestring != null) {
                    values = this.parseCookieString(cookiestring, CookieName);
                }
                if ((cookiestring == null || values == null) && (cookiestring = (String)reqHeaders.get("Cookie2")) != null) {
                    values = this.parseCookieString(cookiestring, CookieName);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::getCookieValue");
        }
        return values;
    }

    private String parseCookieString(String cookieStr, String cookieName) {
        String[] values = null;
        values = cookieStr.split(";");
        if (values != null) {
            for (int i = 0; i < values.length - 1; ++i) {
                if (values[i].indexOf(cookieName) != 0) continue;
                return values[i].split("=")[1];
            }
        }
        return null;
    }

    private void setupEffectiveSSLConfiguration(final WSAddress connaddr) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::setupEffectiveSSLConfiguration");
        }
        Config cfg = null;
        final MessageContext fMC = MessageContext.getCurrentThreadsContext();
        try {
            cfg = (Config)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WebServicesFault {
                    return ConfigSSLProvider.getInstance().getConfig(fMC, connaddr);
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "%C", this);
            Tr.debug(_tc, e.toString());
            throw (WebServicesFault)e.getException();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Effective SSL configuration: " + (cfg == null ? null : cfg.toString()));
        }
        if (cfg == null) {
            throw new WebServicesFault(Messages.getMessage("sslConfigResolveFailed01", connaddr.toString()));
        }
        connaddr.setTransportConfiguration(cfg);
        cfg.addTargetAddress(connaddr);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::setupEffectiveSSLConfiguration");
        }
    }

    private void restoreSSLConfiguration(final WSOutboundConnection wsOC) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::restoreSSLConfiguration");
        }
        final Log lg = log;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WebServicesFault {
                    JSSEHelper jhlpr = JSSEHelper.getInstance();
                    ConfigSSL cfg = (ConfigSSL)wsOC.getTargetAddress().transportConfiguration();
                    if (cfg != null) {
                        WSConfigSSLChangeListener sslListener = cfg.getlistener();
                        if (sslListener != null) {
                            if (lg.isDebugEnabled()) {
                                lg.debug("De-registering WSConfigSSLChangeListener: " + sslListener);
                            }
                            sslListener.deRegister();
                        }
                        Properties p = cfg.getPreCfg();
                        if (lg.isDebugEnabled()) {
                            if (p != null) {
                                lg.debug("Restoring previously saved SSL configuration: " + p);
                            } else {
                                lg.debug("No previously saved SSL configuration to be restored.");
                            }
                        }
                        jhlpr.setSSLPropertiesOnThread(p);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.restoreSSLConfiguration", "1234", this);
            if (lg.isDebugEnabled()) {
                Tr.debug(_tc, e.toString());
            }
            throw WebServicesFault.makeFault(e.getException());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::restoreSSLConfiguration");
        }
    }

    private void processStatusCode(int returnSC, String contentType, WSAddress wsad) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::processStatusCode");
        }
        MessageContext msgContext = MessageContext.getCurrentThreadsContext();
        String string = contentType = null == contentType ? null : contentType.trim();
        if (!(returnSC > 199 && returnSC < 300 || contentType != null && !contentType.startsWith("text/html") && returnSC > 499 && returnSC < 600)) {
            String statusMessage = msgContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            String targetHostAndPort = wsad.getSchemaInString().toLowerCase() + "://" + wsad.getHostname() + ":" + wsad.getPort();
            WebServicesFault fault2 = new WebServicesFault("HTTP", "( " + returnSC + " ) " + statusMessage, targetHostAndPort, null);
            String retSOAPMsg = msgContext.getResponseMessage() == null ? "" : msgContext.getResponseMessage().getSOAPPartAsString();
            fault2.setFaultDetailString(Messages.getMessage("return01", "( " + returnSC + " ) " + statusMessage, retSOAPMsg));
            throw fault2;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::processStatusCode");
        }
    }

    public String getCookieFromHeaders(String cookieName, String setCookieName, Hashtable headers) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::getCookieFromHeaders(" + cookieName + ", " + setCookieName + ", headers)");
        }
        String cookie = null;
        if (headers.containsKey(setCookieName.toLowerCase())) {
            cookie = (String)headers.get(setCookieName.toLowerCase());
            int index = (cookie = cookie.trim()).indexOf(59);
            if (index != -1) {
                cookie = cookie.substring(0, index);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::getCookieFromHeaders");
        }
        return cookie;
    }

    public static boolean isHttpRedirectEnabled() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPSender::isHttpRedirectEnabled()");
        }
        boolean result = false;
        MessageContext mc = MessageContext.getCurrentThreadsContext();
        Boolean httpRedirectEnabled = (Boolean)mc.getProperty("http.redirect.enabled");
        if (httpRedirectEnabled != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Programmatic value of http.redirect.enabled: " + httpRedirectEnabled);
            }
            return httpRedirectEnabled;
        }
        httpRedirectEnabled = (Boolean)mc.getProperty("com.ibm.ws.webservices.HttpRedirectEnabled");
        if (httpRedirectEnabled != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Programmatic value of com.ibm.ws.webservices.HttpRedirectEnabled: " + httpRedirectEnabled);
            }
            return httpRedirectEnabled;
        }
        String sysProp = System.getProperty("http.redirect.enabled");
        if (sysProp != null) {
            result = Boolean.valueOf(sysProp);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "System property value of http.redirect.enabled: " + sysProp);
            }
            return result;
        }
        sysProp = System.getProperty("com.ibm.ws.webservices.HttpRedirectEnabled");
        if (sysProp != null) {
            result = Boolean.valueOf(sysProp);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "System property value of com.ibm.ws.webservices.HttpRedirectEnabled: " + sysProp);
            }
            return result;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "http.redirect.enabled: " + httpRedirectEnabled);
            Tr.debug(_tc, "com.ibm.ws.webservices.HttpRedirectEnabled: " + sysProp);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::isHttpRedirectEnabled=" + result);
        }
        return result;
    }

    private boolean receivedHTTPBasicAuth() {
        MessageContext msgContext;
        boolean success;
        block10: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "HTTPSender::receivedHTTPBasicAuth()");
            }
            success = false;
            msgContext = MessageContext.getCurrentThreadsContext();
            if (!JavaUtils.hasValue(msgContext.getUsername()) && !JavaUtils.hasValue(msgContext.getPassword())) {
                String flag = System.getProperty("com.ibm.ws.webservices.loginSource");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "com.ibm.ws.webservices.loginSource: " + flag);
                }
                try {
                    if (!JavaUtils.hasValue(flag) || "prompt".compareToIgnoreCase(flag) != 0 && "stdin".compareToIgnoreCase(flag) != 0) break block10;
                    SecurityDataPrompt sPrompt = SecurityDataPromptFactory.getPrompt(flag);
                    String[] httpBA = null;
                    try {
                        final String targetRealm = msgContext.getStrProp("WWW-Authenticate");
                        final SecurityDataPrompt finalPrompt = sPrompt;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, Messages.getMessage("challengeRealmInfo", targetRealm));
                        }
                        httpBA = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return finalPrompt.launch(targetRealm == null ? "" : targetRealm);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", "1458", this);
                        Tr.debug(_tc, e.toString());
                        throw e.getException();
                    }
                    if (httpBA != null && JavaUtils.hasValue(httpBA[0]) && JavaUtils.hasValue(httpBA[1])) {
                        msgContext.setUsername(httpBA[0]);
                        msgContext.setPassword(httpBA[1]);
                        success = true;
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.receivedHTTPBasicAuth", "1473", this);
                    if (!_tc.isDebugEnabled()) break block10;
                    Tr.debug(_tc, Messages.getMessage("exception01", ex.toString()));
                }
            }
        }
        msgContext.removeProperty("WWW-Authenticate");
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPSender::receivedHTTPBasicAuth()");
        }
        return success;
    }
}

