/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.websphere.csi.Pool;
import com.ibm.websphere.csi.PoolManager;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

class PoolManagerProxy {
    protected static Log log = LogFactory.getLog(PoolManagerProxy.class.getName());
    private PoolManager poolManager;
    private List queue;
    private int poolLimit;
    private String lock = "lock";

    static PoolManagerProxy newInstance() {
        return new PoolManagerProxy(100);
    }

    private PoolManagerProxy(int limit) {
        PoolManagerProxy poolManagerProxy = this;
        this.poolManager = poolManagerProxy.poolManager.newInstance();
        this.queue = new ArrayList();
        this.poolLimit = limit;
    }

    PoolProxy createThreadSafePool(Object owner, int min2, int max2) {
        return new PoolProxy(owner, min2, max2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        PoolManager poolManager = this.poolManager;
        synchronized (poolManager) {
            StringBuffer sb = new StringBuffer();
            String nl = "\n";
            sb.append("PoolManagerProxy");
            sb.append(nl);
            sb.append("poolLimit    = " + this.poolLimit);
            sb.append(nl);
            sb.append("poolMangager = " + this.poolManager.toString());
            sb.append(nl);
            sb.append("queue size   = " + this.queue.size());
            sb.append(nl);
            for (int i = 0; i < this.queue.size(); ++i) {
                sb.append("  PoolProxy " + i);
                sb.append(nl);
                PoolProxy p = (PoolProxy)this.queue.get(i);
                sb.append(p.dumpPoolProxy("  "));
                sb.append(nl);
            }
            return sb.toString();
        }
    }

    public static void main(String[] args) {
        PoolManagerProxy pmp = PoolManagerProxy.newInstance();
        for (int i = 0; i < 1000; ++i) {
            PoolProxy pp = pmp.createThreadSafePool(new Integer(i), 1, 5);
            pp.put(new String("MyValue" + i));
        }
    }

    class PoolProxy {
        int min;
        int max;
        Object owner;
        Pool _pool;

        PoolProxy(Object owner, int min2, int max2) {
            this.owner = owner;
            this.min = min2;
            this.max = max2;
        }

        public synchronized Object get() {
            return this.getPool().get();
        }

        public synchronized void put(Object value2) {
            this.getPool().put(value2);
        }

        private synchronized Pool getPool() {
            if (this._pool == null) {
                this.createPool();
            }
            return this._pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void destroy() {
            if (this._pool != null) {
                String string = PoolManagerProxy.this.lock;
                synchronized (string) {
                    int i = PoolManagerProxy.this.queue.indexOf(this);
                    if (i >= 0) {
                        PoolManagerProxy.this.queue.remove(i);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Destroying pool: " + this._pool);
                        log.debug("Current Pool is : " + PoolManagerProxy.this.dump());
                    }
                    this._pool.destroy();
                    this._pool = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void createPool() {
            String string = PoolManagerProxy.this.lock;
            synchronized (string) {
                this._pool = PoolManagerProxy.this.poolManager.createThreadSafePool(this.min, this.max);
                PoolManagerProxy.this.queue.add(this);
                if (PoolManagerProxy.this.queue.size() > PoolManagerProxy.this.poolLimit) {
                    PoolProxy proxy = (PoolProxy)PoolManagerProxy.this.queue.get(0);
                    proxy.destroy();
                }
            }
        }

        public synchronized String dumpPoolProxy(String indent) {
            StringBuffer sb = new StringBuffer();
            String nl = "\n";
            sb.append(indent + "pool  = " + this._pool);
            sb.append(nl);
            sb.append(indent + "min   = " + this.min);
            sb.append(nl);
            sb.append(indent + "max   = " + this.max);
            sb.append(nl);
            sb.append(indent + "owner = " + this.owner);
            sb.append(nl);
            return sb.toString();
        }
    }
}

