/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.events;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class P2DConverter
extends PEventProcessor {
    private static Log log = LogFactory.getLog(P2DConverter.class.getName());
    private boolean debug = false;
    private DeserializationContext context;
    private DEventProcessor topProcessor;
    private ArrayList processorStack = new ArrayList();
    private Scopes scopes = new Scopes();
    private static final int STRINGBUFFER_LEN = 100;
    private StringBuffer buffer = null;
    private boolean hasData = false;
    private boolean state = true;
    private boolean simpleEventEnabled = true;
    private boolean preserveMixedContent = true;
    private String sNamespace;
    private String sLocalPart;
    private String sPrefixedName;
    private Attributes sAttributes;
    private MappingScope sMappingScope;
    private Locator locator;

    public P2DConverter(DEventProcessor processor, DeserializationContext context) {
        this.context = context;
        this.topProcessor = processor;
        this.debug = log.isDebugEnabled() || this.debug;
    }

    public void startDocument() throws SAXException {
        this.scopes.push();
    }

    public void endDocument() throws SAXException {
        this.scopes.pop();
    }

    public void characters(char[] chars, int offset, int length) throws SAXException {
        if (this.debug) {
            this.debugMessage("start characters1 = (" + new String(chars, offset, length) + ")");
        }
        this.appendData(chars, offset, length);
        if (this.debug) {
            this.debugMessage("end characters1");
        }
    }

    public void characters(String value2) throws SAXException {
        if (this.debug) {
            this.debugMessage("start characters2 = (" + value2 + ")");
        }
        this.appendData(value2);
        if (this.debug) {
            this.debugMessage("end characters2");
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.debug) {
            this.debugMessage("start startPrefixMapping prefix = {" + prefix + "} namespace = {" + uri + "}");
        }
        this.flush(true);
        MappingScope scope = this.scopes.getMappingScopeUnderConstruction();
        if (prefix != null) {
            scope.addMapping(uri, prefix);
        } else {
            scope.addMapping(uri, "");
        }
        if (this.debug) {
            this.debugMessage("end startPrefixMapping prefix = {" + prefix + "} namespace = {" + uri + "}");
        }
    }

    public void startPrefixMappingNS(String prefix, String uri) throws SAXException {
        if (prefix != null && uri != null && !"".equals(uri)) {
            Mapping m;
            boolean mapPrefix = true;
            MappingScope parentScope = this.scopes.getCurrentMappingScope();
            Mapping mapping = m = parentScope == null ? null : parentScope.getMappingForPrefix(prefix, false);
            if (m != null) {
                String namespace = m.getNamespaceURI();
                boolean bl = namespace == null ? true : (mapPrefix = !namespace.equals(uri));
                if (!mapPrefix) {
                    this.debugMessage("Prefix {" + prefix + "} with namespace {" + namespace + "} already in parent scope");
                }
            }
            if (mapPrefix) {
                this.startPrefixMapping(prefix, uri);
            }
        }
    }

    public void endPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void startElement(String namespace, String localPart, String prefixedName, Attributes attributes) throws SAXException {
        MappingScope mappingScope;
        int colonIndex = localPart.indexOf(":");
        if (colonIndex > 0) {
            if (this.debug) {
                this.debugMessage("pre-adjust start startElement1:" + localPart);
                this.debugMessage("                 prefixedNamed:" + prefixedName);
                this.debugMessage("                 namespace:" + namespace);
            }
            String prefix = localPart.substring(0, colonIndex);
            localPart = localPart.substring(colonIndex + 1);
            prefixedName = prefix + ":" + localPart;
            MappingScope scope = this.scopes.getMappingScopeUnderConstruction();
            Mapping mapping = scope.getMappingForPrefix(prefix, false);
            if (mapping != null) {
                namespace = mapping.getNamespaceURI();
            }
            if (this.debug) {
                this.debugMessage("post-adjust start startElement1:" + localPart);
                this.debugMessage("                  prefixedName:" + prefixedName);
                this.debugMessage("                  namespace:" + namespace);
            }
        } else if (this.debug) {
            this.debugMessage("start startElement1:" + localPart);
        }
        this.flush(true);
        if (this.debug) {
            this.debugMessage("start startElement1 after flush: " + localPart);
        }
        if (this.storeStartElement(namespace, localPart, prefixedName, attributes, mappingScope = this.scopes.getMappingScopeUnderConstruction())) {
            if (this.debug) {
                this.debugMessage("end startElement1 (defer processing): " + localPart);
            }
            return;
        }
        this.startElement(namespace, localPart, prefixedName, attributes, mappingScope, null);
        if (this.debug) {
            this.debugMessage("end startElement1: " + localPart);
        }
    }

    public void startElement(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, SOAPElement element) throws SAXException {
        if (this.debug) {
            this.debugMessage("start startElement2: " + localPart);
        }
        this.flush(true);
        if (this.debug) {
            this.debugMessage("start startElement2 after flush: " + localPart);
        }
        if (mappingScope != null) {
            this.scopes.replaceMappingScopeUnderConstruction(mappingScope);
        }
        this.scopes.push();
        if (attributes == null || attributes.getLength() == 0) {
            attributes = NullAttributes.singleton;
        }
        if (!mappingScope.isReadOnly()) {
            mappingScope.setReadOnly(true, this);
        }
        DEventProcessor nextProcessor = null;
        if (this.topProcessor != null) {
            if (element != null) {
                this.topProcessor.childElementEvent(element);
            }
            nextProcessor = this.topProcessor.onStartChild(namespace, localPart, prefixedName, attributes, this.scopes.getCurrentMappingScope(), this.context);
        }
        if (nextProcessor == null) {
            throw new SAXException(Messages.getMessage("noDEventProcessor01", this.topProcessor.getClass().getName(), prefixedName));
        }
        this.pushDEventProcessor(nextProcessor);
        if (element != null) {
            nextProcessor.elementEvent(element);
        }
        nextProcessor.startElement(namespace, localPart, prefixedName, attributes, this.scopes.getCurrentMappingScope(), this.context);
        if (mappingScope.isReadOnlyOwner(this)) {
            mappingScope.setReadOnly(false, this);
        }
        if (this.debug) {
            this.debugMessage("end startElement2: " + localPart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String namespace, String localPart, String prefixedName) throws SAXException {
        int colonIndex = localPart.indexOf(":");
        if (colonIndex > 0) {
            if (this.debug) {
                this.debugMessage("pre-adjust start endElement1:" + localPart);
                this.debugMessage("                 prefixedNamed:" + prefixedName);
                this.debugMessage("                 namespace:" + namespace);
            }
            String prefix = localPart.substring(0, colonIndex);
            localPart = localPart.substring(colonIndex + 1);
            prefixedName = prefix + ":" + localPart;
            MappingScope scope = this.scopes.getMappingScopeUnderConstruction();
            Mapping mapping = scope.getMappingForPrefix(prefix, false);
            if (mapping != null) {
                namespace = mapping.getNamespaceURI();
            }
            if (this.debug) {
                this.debugMessage("post-adjust start endElement1:" + localPart);
                this.debugMessage("                  prefixedName:" + prefixedName);
                this.debugMessage("                  namespace:" + namespace);
            }
        } else if (this.debug) {
            this.debugMessage("start endElement1: " + localPart);
        }
        if (this.flush(false)) {
            if (this.debug) {
                this.debugMessage("end endElement1 (optimized simple event): " + localPart);
            }
            return;
        }
        try {
            DEventProcessor processor = this.popDEventProcessor();
            processor.endElement(namespace, localPart, this.context);
            if (this.topProcessor != null) {
                this.topProcessor.onEndChild(namespace, localPart, this.context);
            }
        }
        finally {
            this.scopes.pop();
            if (this.debug) {
                this.debugMessage("end endElement1 (normal): " + localPart);
            }
        }
    }

    public void ignorableWhitespace(char[] chars, int offset, int length) throws SAXException {
        if (this.debug) {
            this.debugMessage("ignorableWhitespace (" + new String(chars, offset, length) + ")");
        }
    }

    public void processingInstruction(String p1, String p2) throws SAXException {
        throw new SAXException(Messages.getMessage("noInstructions00"));
    }

    public void skippedEntity(String p1) throws SAXException {
        if (this.debug) {
            this.debugMessage("skippedEntity (" + p1 + ")");
        }
    }

    public void startDTD(String name2, String publicId, String systemId) throws SAXException {
        throw new SAXException(Messages.getMessage("unsupportedSAXEvent", "startDTD"));
    }

    public void endDTD() throws SAXException {
        throw new SAXException(Messages.getMessage("unsupportedSAXEvent", "endDTD"));
    }

    public void startEntity(String name2) throws SAXException {
        if (this.debug) {
            this.debugMessage("startEntity (" + name2 + ")");
        }
    }

    public void endEntity(String name2) throws SAXException {
        if (this.debug) {
            this.debugMessage("endEntity (" + name2 + ")");
        }
    }

    public void startCDATA() throws SAXException {
        if (this.debug) {
            this.debugMessage("start startCDATA");
        }
        if (this.debug) {
            this.debugMessage("end startCDATA");
        }
    }

    public void endCDATA() throws SAXException {
        if (this.debug) {
            this.debugMessage("start endCDATA");
        }
        if (this.debug) {
            this.debugMessage("end endCDATA");
        }
    }

    public void comment(char[] chars, int offset, int length) throws SAXException {
        if (this.debug) {
            this.debugMessage("start comment = (" + new String(chars, offset, length) + ")");
        }
        this.flush(true);
        if (this.topProcessor != null) {
            this.topProcessor.comment(chars, offset, length);
        }
        if (this.debug) {
            this.debugMessage("end comment");
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public final void pushDEventProcessor(DEventProcessor processor) {
        if (processor == null) {
            throw new InternalException(Messages.getMessage("pushNullDEventProcessor00"));
        }
        if (this.debug) {
            this.debugMessage("---push " + processor.getClass());
        }
        if (this.topProcessor != null) {
            this.processorStack.add(this.topProcessor);
        }
        this.topProcessor = processor;
    }

    public final DEventProcessor popDEventProcessor() {
        int size;
        DEventProcessor result = this.topProcessor;
        if (this.debug) {
            if (this.topProcessor != null) {
                this.debugMessage("---popped " + this.topProcessor.getClass());
            } else {
                this.debugMessage("---popped AN EMPTY STACK");
            }
        }
        this.topProcessor = (size = this.processorStack.size()) > 0 ? (DEventProcessor)this.processorStack.remove(size - 1) : null;
        if (this.debug) {
            if (this.topProcessor != null) {
                this.debugMessage("---now " + this.topProcessor.getClass());
            } else {
                this.debugMessage("---now STACK IS EMPTY");
            }
        }
        return result;
    }

    public Object saveState() {
        ArrayList<DEventProcessor> stack = new ArrayList<DEventProcessor>(this.processorStack);
        if (this.topProcessor != null) {
            stack.add(this.topProcessor);
        }
        return stack;
    }

    public void restoreState(Object state) {
        this.processorStack = (ArrayList)state;
        int size = this.processorStack.size();
        this.topProcessor = size > 0 ? (DEventProcessor)this.processorStack.remove(size - 1) : null;
    }

    private void appendData(char[] chars, int offset, int length) {
        if (this.debug) {
            this.debugMessage("appendData chars: (" + new String(chars, offset, length) + ")");
        }
        if (this.state || this.preserveMixedContent) {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(length);
            }
            this.buffer.append(chars, offset, length);
            this.hasData = true;
            if (this.debug) {
                this.debugMessage("appendData hasData");
            }
        }
    }

    private void appendData(String value2) {
        if (this.debug) {
            this.debugMessage("appendData String: (" + value2 + ")");
        }
        if ((this.state || this.preserveMixedContent) && value2.length() > 0) {
            if (this.buffer == null) {
                this.buffer = new StringBuffer(value2.length());
            }
            this.buffer.append(value2);
            this.hasData = true;
            if (this.debug) {
                this.debugMessage("appendData hasData");
            }
        }
    }

    private boolean flush(boolean newState) throws SAXException {
        boolean mixedContent;
        String value2 = "";
        boolean hasValue = false;
        boolean bl = mixedContent = !this.state || newState;
        if (this.hasData) {
            if (!mixedContent || this.preserveMixedContent) {
                hasValue = true;
                value2 = new String(this.buffer);
                this.buffer = null;
                if (this.debug) {
                    this.debugMessage("flush: character data = (" + value2 + ")");
                }
            }
            if (this.buffer != null) {
                this.buffer.setLength(0);
            }
            this.hasData = false;
        }
        if (this.sLocalPart != null) {
            if (this.state && !newState) {
                if (this.debug) {
                    this.debugMessage("flush: send onSimpleChild:" + this.sLocalPart + "(" + value2 + ")");
                }
                String localPart = this.sLocalPart;
                this.sLocalPart = null;
                if (this.topProcessor != null) {
                    if (!this.sMappingScope.isReadOnly()) {
                        this.sMappingScope.setReadOnly(true, this);
                    }
                    this.topProcessor.onSimpleChild(this.sNamespace, localPart, this.sPrefixedName, this.sAttributes, this.sMappingScope, this.context, value2);
                    if (this.sMappingScope.isReadOnlyOwner(this)) {
                        this.sMappingScope.setReadOnly(false, this);
                    }
                    if (this.sMappingScope.isReadOnly()) {
                        this.scopes.pop();
                        this.scopes.push();
                    } else {
                        this.sMappingScope.clear();
                    }
                    this.sLocalPart = null;
                    this.state = newState;
                    return true;
                }
            } else {
                if (this.debug) {
                    this.debugMessage("flush: can't send onSimpleChild:" + this.sLocalPart + "(" + value2 + ")");
                }
                if (this.sMappingScope != null) {
                    this.scopes.replaceMappingScopeUnderConstruction(this.sMappingScope);
                }
                this.scopes.push();
                if (!this.sMappingScope.isReadOnly()) {
                    this.sMappingScope.setReadOnly(true, this);
                }
                DEventProcessor nextProcessor = null;
                if (this.topProcessor != null) {
                    nextProcessor = this.topProcessor.onStartChild(this.sNamespace, this.sLocalPart, this.sPrefixedName, this.sAttributes, this.sMappingScope, this.context);
                }
                this.pushDEventProcessor(nextProcessor);
                nextProcessor.startElement(this.sNamespace, this.sLocalPart, this.sPrefixedName, this.sAttributes, this.sMappingScope, this.context);
                if (this.sMappingScope.isReadOnlyOwner(this)) {
                    this.sMappingScope.setReadOnly(false, this);
                }
                if (hasValue) {
                    if (this.debug) {
                        this.debugMessage("flush: send buffered characters (" + value2 + ")");
                    }
                    this.topProcessor.characters(value2);
                }
            }
            this.sLocalPart = null;
            this.state = newState;
            return false;
        }
        if (hasValue) {
            if (this.debug) {
                this.debugMessage("flush: send buffered characters (" + value2 + ")");
            }
            this.topProcessor.characters(value2);
        }
        this.state = newState;
        return false;
    }

    private boolean storeStartElement(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope) {
        int numAttrs = attributes.getLength();
        if (!this.simpleEventEnabled || numAttrs > 1 || numAttrs == 1 && (!"type".equals(attributes.getLocalName(0)) || !"http://www.w3.org/2001/XMLSchema-instance".equals(attributes.getURI(0))) || Constants.isSOAP_ENV(namespace)) {
            return false;
        }
        this.sNamespace = namespace;
        this.sLocalPart = localPart;
        this.sPrefixedName = prefixedName;
        this.sAttributes = attributes.getClass() != NullAttributes.class ? (attributes.getLength() > 0 ? new AttributesImpl(attributes) : NullAttributes.singleton) : attributes;
        this.sMappingScope = mappingScope;
        return true;
    }

    private void debugMessage(String message) {
        log.debug(message);
    }

    public void enableSimpleEvent() {
        this.simpleEventEnabled = true;
    }

    public void disableSimpleEvent() {
        this.simpleEventEnabled = false;
    }

    public boolean isSimpleEventEnabled() {
        return this.simpleEventEnabled;
    }

    public void setPreserveMixedContent(boolean value2) {
        this.preserveMixedContent = value2;
    }

    public boolean getPreserveMixedContent() {
        return this.preserveMixedContent;
    }

    public void release() {
        this.context = null;
        this.topProcessor = null;
    }

    class Scopes {
        private MappingScope[] mArray = new MappingScope[10];
        int top = -1;

        public Scopes() {
            this.push();
        }

        public MappingScope getCurrentMappingScope() {
            if (this.top <= 0) {
                return null;
            }
            return this.mArray[this.top - 1];
        }

        public MappingScope getMappingScopeUnderConstruction() {
            if (this.top < 0) {
                return null;
            }
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope == null) {
                mappingScope = new MappingScope();
                mappingScope.setParent(this.getCurrentMappingScope());
                this.mArray[this.top] = mappingScope;
            }
            return mappingScope;
        }

        public void replaceMappingScopeUnderConstruction(MappingScope mappingScope) {
            if (mappingScope != this.mArray[this.top]) {
                mappingScope.setReadOnly(true, this);
                this.mArray[this.top] = mappingScope;
            }
        }

        public void push() {
            this.getMappingScopeUnderConstruction();
            ++this.top;
            if (this.top >= this.mArray.length) {
                MappingScope[] newstack = new MappingScope[this.mArray.length * 2];
                System.arraycopy(this.mArray, 0, newstack, 0, this.mArray.length);
                this.mArray = newstack;
            }
        }

        public void pop() {
            --this.top;
            MappingScope mappingScope = this.mArray[this.top];
            if (mappingScope != null) {
                if (mappingScope.isReadOnly()) {
                    this.mArray[this.top] = null;
                    if (mappingScope.isReadOnlyOwner(this)) {
                        mappingScope.setReadOnly(false, this);
                    }
                } else {
                    mappingScope.clear();
                }
            }
        }
    }
}

