/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.utils.Target;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class BeanPropertyTarget
implements Target {
    protected static Log log = LogFactory.getLog(BeanPropertyTarget.class.getName());
    private Object object;
    private BeanPropertyDescriptor pd;
    private int index = -1;

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor pd) {
        this.object = object;
        this.pd = pd;
        this.index = -1;
    }

    public BeanPropertyTarget(Object object, BeanPropertyDescriptor pd, int i) {
        this.object = object;
        this.pd = pd;
        this.index = i;
    }

    public void set(Object value2) throws SAXException {
        try {
            if (this.index < 0) {
                this.pd.set(this.object, value2);
            } else {
                this.pd.set(this.object, this.index, value2);
            }
        }
        catch (Exception e) {
            try {
                Class type = this.pd.getType();
                if (JavaUtils.isConvertable(value2, type)) {
                    value2 = JavaUtils.convert(value2, type);
                    if (this.index < 0) {
                        this.pd.set(this.object, value2);
                    } else {
                        this.pd.set(this.object, this.index, value2);
                    }
                }
                if (this.index == 0 && value2.getClass().isArray() && !type.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(value2); ++i) {
                        Object item = JavaUtils.convert(Array.get(value2, i), type);
                        this.pd.set(this.object, i, item);
                    }
                }
                throw e;
            }
            catch (Exception ex) {
                Throwable t;
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.encoding.utils.BeanPropertyTarget.set", "169", this);
                String field = this.pd.getName();
                if (this.index >= 0) {
                    field = field + "[" + this.index + "]";
                }
                if (log.isErrorEnabled()) {
                    String valueType = "null";
                    if (value2 != null) {
                        valueType = value2.getClass().getName();
                    }
                    log.error(Messages.getMessage("cantConvert02", new String[]{valueType, field, this.pd.getType().getName()}));
                }
                if (ex instanceof InvocationTargetException && (t = ((InvocationTargetException)ex).getTargetException()) != null) {
                    throw new SAXException(t.getMessage());
                }
                throw new SAXException(ex);
            }
        }
    }
}

