/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.custom.CustomBindingContextImpl;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.wsspi.webservices.binding.CustomBinder;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class CustomSerializerProxy
implements Serializer {
    protected static Log log = LogFactory.getLog(CustomSerializerProxy.class.getName());
    private QName xmlType;
    private Class javaType;
    private Class binderClass;

    protected CustomSerializerProxy(Class javaType, QName xmlType, Class binderClass) {
        this.javaType = javaType;
        this.xmlType = xmlType;
        this.binderClass = binderClass;
    }

    public void serialize(QName name2, Attributes attributes, Object value2, SerializationContext context) throws IOException {
        CustomBinder binder = null;
        try {
            binder = (CustomBinder)this.binderClass.newInstance();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerProxy.serialize", "63", this);
            throw new IOException(ex.getMessage());
        }
        if (binder == null) {
            throw new IOException("No CustomBinder is found for xml type: " + this.xmlType);
        }
        try {
            javax.xml.soap.SOAPElement root = SOAPFactory.newInstance().createElement(name2.getLocalPart(), name2.getPrefix(), name2.getNamespaceURI());
            root = binder.serialize(value2, root, new CustomBindingContextImpl());
            if (root instanceof SOAPElement) {
                SOAPElement ibmse = (SOAPElement)root;
                ibmse.output(context);
            } else {
                SOAPElement wrapper = (SOAPElement)SOAPFactory.newInstance().createElement(name2.getLocalPart(), name2.getPrefix(), name2.getNamespaceURI());
                wrapper.setAlternateContent(root);
                wrapper.output(context);
            }
        }
        catch (Exception se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerProxy.serialize", "98", this);
            throw new IOException(se.getMessage());
        }
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    public String getBuildNumber() {
        return null;
    }
}

