/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.dispatchers.BasicDispatcher;
import com.ibm.ws.webservices.engine.dispatchers.Processor;
import com.ibm.ws.webservices.engine.dispatchers.SoapProcessor;
import com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.builders.WebServicesFaultProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class SoapRPCProcessor
extends SoapProcessor {
    protected static Log log = LogFactory.getLog(SoapRPCProcessor.class.getName());
    protected static Processor singleton;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    public static Processor getProcessor() {
        if (singleton == null) {
            singleton = new SoapRPCProcessor();
        }
        return singleton;
    }

    private SoapRPCProcessor() {
    }

    public OperationDesc resolveOperation(MessageContext msgContext) throws Exception, WebServicesFault {
        OperationDesc operation = this.getOperation(msgContext);
        if (operation == null) {
            Message reqMsg = msgContext.getRequestMessage();
            SOAPEnvelope reqEnv = reqMsg.getSOAPEnvelope();
            SOAPBody body = (SOAPBody)reqEnv.getBody();
            if (body == null) {
                if (log.isDebugEnabled()) {
                    log.debug("detected no body.  A body is created.");
                }
                body = (SOAPBody)reqEnv.addBody();
                new RequestResponse("", "", body, false, null, new DeserializationContextImpl(msgContext, null));
            }
            RequestResponse request = body.getRequestResponse();
            QName qNameInMsg = null;
            if (body.getNumChildren() > 0) {
                qNameInMsg = body.getChildElement(0).getQName();
            }
            PortDesc portDesc = msgContext != null ? msgContext.getPortDesc() : null;
            String insert1 = qNameInMsg == null ? "<no element in body>" : qNameInMsg.toString();
            String insert2 = portDesc == null ? "null portDesc" : portDesc.toString();
            throw new WebServicesFault(QNameTable.createQName(msgContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("noSuchOperation", insert1, insert2), null, null);
        }
        return operation;
    }

    public OperationDesc getOperation(MessageContext msgContext) throws Exception, WebServicesFault {
        try {
            OperationDesc operation = msgContext.getOperation();
            if (operation == null) {
                Message reqMsg = msgContext.getRequestMessage();
                SOAPEnvelope reqEnv = reqMsg.getSOAPEnvelope();
                SOAPBody body = (SOAPBody)reqEnv.getBody();
                RequestResponse request = body == null ? null : body.getRequestResponse();
                OperationDesc operationDesc = operation = request == null ? null : request.getOperation();
                if (operation == null) {
                    QName requestQName = request == null ? null : request.getQName();
                    SOAPPort port2 = msgContext.getPort();
                    PortDesc portDesc = port2.getPortDesc();
                    if (requestQName != null) {
                        operation = portDesc.getOperationByElementQName(requestQName);
                    }
                }
                msgContext.setOperation(operation);
            }
            return operation;
        }
        catch (Exception ex) {
            throw WebServicesFault.makeFault(ex);
        }
    }

    public void processMessage(MessageContext msgContext, BasicDispatcher dispatcher2, Object targetService) throws Exception, WebServicesFault {
        Message reqMsg;
        SOAPEnvelope reqEnv;
        SOAPBody body;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SoapRPCProcessor.processMessage()");
        }
        if ((body = (SOAPBody)(reqEnv = (reqMsg = msgContext.getRequestMessage()).getSOAPEnvelope()).getBody()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("detected no body.  A body is created.");
            }
            body = (SOAPBody)reqEnv.addBody();
            new RequestResponse("", "", body, false, null, new DeserializationContextImpl(msgContext, null));
        }
        body.getSOAPFactory().setProtectState(false);
        RequestResponse request = body.getRequestResponse();
        OperationDesc operation = this.resolveOperation(msgContext);
        Vector args = request.getParams();
        Object[] argValues = new Object[operation.getNumParams()];
        ArrayList<ParamValue> outs = new ArrayList<ParamValue>();
        int numArgs = args.size();
        for (int i = 0; i < numArgs; ++i) {
            ParamValue paramValue = (ParamValue)args.get(i);
            Object value2 = paramValue.getValue();
            ParameterDesc paramDesc = paramValue.getParamDesc();
            if (paramDesc != null && paramDesc.getJavaSigType() != null) {
                Class sigType = paramDesc.getJavaSigType();
                try {
                    value2 = JavaUtils.convert(value2, sigType);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processMessage", "204", this);
                    throw new Exception("convert problem " + value2.getClass() + " " + sigType);
                }
                paramValue.setValue(value2);
                if (paramDesc.getMode() == 3) {
                    outs.add(paramValue);
                }
            }
            if (paramDesc == null || paramDesc.getOrder() == -1) {
                argValues[i] = value2;
            } else {
                argValues[paramDesc.getOrder()] = value2;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("  " + Messages.getMessage("value00", JavaUtils.getObjectIdentity(value2)));
        }
        int numIn = operation.getNumInParams();
        if (numIn < argValues.length) {
            ArrayList outParams = operation.getOutParams();
            for (int i = 0; i < outParams.size(); ++i) {
                ParameterDesc param = (ParameterDesc)outParams.get(i);
                Class holderClass = param.getJavaSigType();
                int argIndex = -1;
                argIndex = param == null || param.getOrder() == -1 ? numIn + i : param.getOrder();
                if (holderClass == null || !(class$javax$xml$rpc$holders$Holder == null ? SoapRPCProcessor.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom(holderClass)) {
                    throw new WebServicesFault(Messages.getMessage("badOutParameter00", "" + param.getQName(), operation.getName()));
                }
                argValues[argIndex] = holderClass.newInstance();
                ParamValue p = new ParamValue(param.getQName(), argValues[argIndex]);
                p.setParamDesc(param);
                outs.add(p);
            }
        }
        if (operation.isOneway()) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("onewayOperation", operation.getName()));
            }
            if (log.isDebugEnabled()) {
                log.debug("Oneway operation.");
            }
            this.processOneway(msgContext, dispatcher2, operation, targetService, argValues);
        } else {
            Object redirectFlag = msgContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired");
            if (redirectFlag != null) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("asyncOperation", operation.getName()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Async operation.");
                }
                try {
                    if (msgContext.getProperty("com.ibm.ws.wsaddressing.RedirectResponse") != null && msgContext.getProperty("com.ibm.ws.wsaddressing.RedirectFault") != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Close client connection as response will be sent async.");
                        }
                        msgContext.oneWayEvent();
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processOneway", "1:408:1.23", this);
                }
                QName requestQName = request.getQName();
                this.processRequestResponse(msgContext, dispatcher2, operation, targetService, argValues, outs, requestQName.getNamespaceURI());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("R-ROperation", operation.getName()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("R-R operation.");
                }
                QName requestQName = request.getQName();
                this.processRequestResponse(msgContext, dispatcher2, operation, targetService, argValues, outs, requestQName.getNamespaceURI());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOneway(MessageContext msgContext, BasicDispatcher dispatcher2, OperationDesc operation, Object obj, Object[] argValues) {
        try {
            try {
                msgContext.oneWayEvent();
                msgContext.setInvokingTarget(true);
                dispatcher2.invokeOperation(operation, obj, argValues, msgContext);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processOneway", "1:408:1.23", this);
                Object var8_7 = null;
                msgContext.setInvokingTarget(false);
            }
            Object var8_6 = null;
            msgContext.setInvokingTarget(false);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            msgContext.setInvokingTarget(false);
            throw throwable;
        }
    }

    private void processRequestResponse(MessageContext msgContext, BasicDispatcher dispatcher2, OperationDesc operation, Object obj, Object[] argValues, ArrayList outs, String requestNamespace) throws Exception {
        String responseLocalPart;
        Object objRes = null;
        try {
            try {
                msgContext.setInvokingTarget(true);
                objRes = dispatcher2.invokeOperation(operation, obj, argValues, msgContext);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processRequestResponse", "1:431:1.23", this);
                Throwable rootException = WebServicesFault.getRootCause(e);
                FaultDesc faultDesc = operation.getFaultByClass(rootException.getClass());
                if (faultDesc != null) {
                    WebServicesFaultProcessor.copyWSAFaultAction(faultDesc, msgContext);
                    throw WebServicesFault.makeUserFault((Exception)rootException, faultDesc.getFaultCode());
                }
                throw e;
            }
            Object var13_9 = null;
            msgContext.setInvokingTarget(false);
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            msgContext.setInvokingTarget(false);
            throw throwable;
        }
        msgContext.setPastPivot(true);
        String methodName = operation.getElementQName() != null ? operation.getElementQName().getLocalPart() : operation.getName();
        SOAPEnvelope resEnv = this.createResponseEnvelope(msgContext);
        String responseNamespace = (String)operation.getOption(OperationDesc.RESPONSE_NAMESPACE);
        if (responseNamespace == null) {
            responseNamespace = requestNamespace;
        }
        if ((responseLocalPart = (String)operation.getOption(OperationDesc.RESPONSE_LOCALPART)) == null) {
            responseLocalPart = methodName + "Response";
        }
        RequestResponse response = new RequestResponse(responseNamespace, responseLocalPart, (SOAPBody)resEnv.getBody(), true);
        String encStyle = msgContext.getEncodingStyle();
        if (encStyle != null && encStyle.length() > 0) {
            resEnv.getBody().setEncodingStyle(encStyle);
            resEnv.getHeader().setEncodingStyle(encStyle);
        }
        try {
            ParamValue param;
            if (operation.getMethod().getReturnType() != Void.TYPE) {
                QName returnQName = operation.getReturnQName();
                if (returnQName == null) {
                    returnQName = QNameTable.createQName("", methodName + "Return");
                }
                if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
                    returnQName = Constants.QNAME_RPC_RESULT;
                }
                param = new ParamValue(returnQName, objRes);
                param.setParamDesc(operation.getReturnParamDesc());
                if (!operation.isReturnHeader()) {
                    response.addParam(param);
                } else {
                    SOAPHeaderElement she = resEnv.getSOAPFactory().createSOAPHeaderElement(param.getQName().getNamespaceURI(), param.getQName().getLocalPart());
                    she.setAlternateContent(param);
                    resEnv.getHeader().addChildElement((SOAPElement)she);
                }
            }
            if (!outs.isEmpty()) {
                Iterator i = outs.iterator();
                while (i.hasNext()) {
                    param = (ParamValue)i.next();
                    Holder holder = (Holder)param.getValue();
                    Object value2 = JavaUtils.getHolderValue(holder);
                    ParameterDesc paramDesc = param.getParamDesc();
                    param.setValue(value2);
                    if (paramDesc != null && paramDesc.isOutHeader()) {
                        SOAPHeaderElement she = resEnv.getSOAPFactory().createSOAPHeaderElement(param.getQName().getNamespaceURI(), param.getQName().getLocalPart());
                        she.setAlternateContent(param);
                        resEnv.getHeader().addChildElement((SOAPElement)she);
                        continue;
                    }
                    response.addParam(param);
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processRequestResponse", "1:519:1.23", this);
            throw e;
        }
    }

    protected final SOAPEnvelope createResponseEnvelope(MessageContext msgContext) throws SOAPException {
        SOAPFactory sf = new SOAPFactory(msgContext.getSOAPConstants());
        SOAPEnvelope resEnv = sf.createSOAPEnvelope(true);
        Message resMsg = new Message(resEnv);
        msgContext.setResponseMessage(resMsg);
        return resEnv;
    }
}

