/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDTypeMapping
extends WSDDElement {
    protected QName qname = null;
    protected String serializer = null;
    protected String deserializer = null;
    protected QName typeQName = null;
    protected String ref = null;
    protected String encodingStyle = null;
    protected QName componentQName = null;
    protected QName componentTypeQName = null;
    protected String binderName = null;

    public WSDDTypeMapping() {
    }

    public WSDDTypeMapping(Element e) throws WSDDException {
        String text;
        this.serializer = e.getAttribute("serializer");
        this.deserializer = e.getAttribute("deserializer");
        Attr attrNode = e.getAttributeNode("encodingStyle");
        this.encodingStyle = attrNode == null ? Constants.URI_DEFAULT_SOAP_ENC : attrNode.getValue();
        String qnameStr = e.getAttribute("qname");
        this.qname = XMLUtils.getQNameFromString(qnameStr, e);
        String typeStr = e.getAttribute("type");
        this.typeQName = XMLUtils.getQNameFromString(typeStr, e);
        if (typeStr == null || typeStr.equals("")) {
            typeStr = e.getAttribute("languageSpecificType");
            this.typeQName = XMLUtils.getQNameFromString(typeStr, e);
        }
        if ((text = e.getAttribute("componentQName")) != null && text.length() > 0) {
            this.componentQName = XMLUtils.getQNameFromString(text, e);
        }
        if ((text = e.getAttribute("componentTypeQName")) != null && text.length() > 0) {
            this.componentTypeQName = XMLUtils.getQNameFromString(text, e);
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "encodingStyle", "encodingStyle", "CDATA", this.encodingStyle);
        attrs.addAttribute("", "serializer", "serializer", "CDATA", this.serializer);
        attrs.addAttribute("", "deserializer", "deserializer", "CDATA", this.deserializer);
        String typeStr = context.getSerializationWriter().qName2String(this.typeQName);
        attrs.addAttribute("", "type", "type", "CDATA", typeStr);
        String qnameStr = context.getSerializationWriter().qName2String(this.qname);
        attrs.addAttribute("", "qname", "qname", "CDATA", qnameStr);
        if (this.componentQName != null) {
            attrs.addAttribute("", "componentQName", "componentQName", "CDATA", context.getSerializationWriter().qName2String(this.componentQName));
        }
        if (this.componentTypeQName != null) {
            attrs.addAttribute("", "componentTypeQName", "componentTypeQName", "CDATA", context.getSerializationWriter().qName2String(this.componentTypeQName));
        }
        context.getSerializationWriter().simpleElement(QNAME_TYPEMAPPING, attrs, null);
    }

    protected QName getElementName() {
        return QNAME_TYPEMAPPING;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void setEncodingStyle(String es) {
        this.encodingStyle = es;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setQName(QName name2) {
        this.qname = name2;
    }

    public Class getLanguageSpecificType() throws ClassNotFoundException {
        if (this.typeQName != null) {
            if (!"http://websphere.ibm.com/webservices/wsdd/dispatchers/java".equals(this.typeQName.getNamespaceURI())) {
                throw new ClassNotFoundException(Messages.getMessage("badTypeNamespace00", this.typeQName.getNamespaceURI(), "http://websphere.ibm.com/webservices/wsdd/dispatchers/java"));
            }
            String loadName = JavaUtils.getLoadableClassName(this.typeQName.getLocalPart());
            return ClassUtils.forName(loadName);
        }
        throw new ClassNotFoundException(Messages.getMessage("noTypeQName00"));
    }

    public void setLanguageSpecificType(Class javaType) {
        String type = javaType.getName();
        this.typeQName = QNameTable.createQName("http://websphere.ibm.com/webservices/wsdd/dispatchers/java", type);
    }

    public void setLanguageSpecificType(String javaType) {
        this.typeQName = QNameTable.createQName("http://websphere.ibm.com/webservices/wsdd/dispatchers/java", javaType);
    }

    public Class getSerializer() throws ClassNotFoundException {
        return ClassUtils.forName(this.serializer);
    }

    public String getSerializerName() {
        return this.serializer;
    }

    public void setSerializer(Class ser) {
        this.serializer = ser.getName();
    }

    public void setSerializer(String ser) {
        this.serializer = ser;
    }

    public Class getDeserializer() throws ClassNotFoundException {
        return ClassUtils.forName(this.deserializer);
    }

    public String getDeserializerName() {
        return this.deserializer;
    }

    public void setDeserializer(Class deser) {
        this.deserializer = deser.getName();
    }

    public void setDeserializer(String deser) {
        this.deserializer = deser;
    }

    public void setComponentTypeQName(QName qname) {
        this.componentTypeQName = qname;
    }

    public QName getComponentTypeQName() {
        return this.componentTypeQName;
    }

    public void setComponentQName(QName qname) {
        this.componentQName = qname;
    }

    public QName getComponentQName() {
        return this.componentQName;
    }

    public String getBinderName() {
        return this.binderName;
    }

    public void setBinderName(String string) {
        this.binderName = string;
    }

    public String toString() {
        return "WSDDTypeMapping(\n  qname = " + this.qname + "\n" + "  serializer = " + this.serializer + "\n" + "  deserializer = " + this.deserializer + "\n" + "  typeQname = " + this.typeQName + "\n" + "  ref = " + this.ref + "\n" + "  encodingStyle = " + this.encodingStyle + "\n" + "  componentQName = " + this.componentQName + "\n" + "  componentTypeQName = " + this.componentTypeQName + ")\n";
    }
}

