/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.attachments;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import javax.activation.DataSource;
import javax.xml.transform.stream.StreamSource;

public class SourceDataSource
implements DataSource {
    public static final String CONTENT_TYPE = "text/xml";
    private final String name;
    private final String contentType;
    private byte[] data;
    private ByteArrayInputStream is;
    private ByteArrayOutputStream os;

    public SourceDataSource(String name2, StreamSource data) {
        this(name2, CONTENT_TYPE, data);
    }

    public SourceDataSource(String name2, String contentType, StreamSource data) {
        this.name = name2;
        this.contentType = contentType == null ? CONTENT_TYPE : contentType;
        this.os = new ByteArrayOutputStream();
        try {
            if (data != null) {
                Reader reader = data.getReader();
                if (reader != null) {
                    int ch;
                    Reader originalReader = null;
                    if (reader.markSupported()) {
                        reader.mark(Integer.MAX_VALUE);
                        originalReader = reader;
                    }
                    reader = new BufferedReader(reader);
                    while ((ch = reader.read()) != -1) {
                        this.os.write(ch);
                    }
                    if (originalReader != null) {
                        originalReader.reset();
                    }
                } else {
                    String id;
                    InputStream is = data.getInputStream();
                    if (is == null && (id = data.getSystemId()) != null) {
                        URL url = new URL(id);
                        is = url.openStream();
                    }
                    if (is != null) {
                        int avail;
                        InputStream originalIS = null;
                        if (is.markSupported()) {
                            is.mark(Integer.MAX_VALUE);
                            originalIS = is;
                        }
                        is = new BufferedInputStream(is);
                        byte[] bytes = null;
                        while ((avail = is.available()) > 0) {
                            if (bytes == null || avail > bytes.length) {
                                bytes = new byte[avail];
                            }
                            is.read(bytes, 0, avail);
                            this.os.write(bytes, 0, avail);
                        }
                        if (originalIS != null) {
                            originalIS.reset();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.attachments.SourceDataSource.SourceDataSource", "98", this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os.size() != 0) {
            this.data = this.os.toByteArray();
            this.os.reset();
        }
        return this.os;
    }
}

