/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.component.JAXRPCMetaDataHelper;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webservices.models.WSModels;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class PluginCfgHelper {
    private static TraceComponent _tc = Tr.register(PluginCfgHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public static String getRouterModuleName(EARFile earFile, EjbModule m) {
        String routerModuleName = null;
        ModuleFile mf = earFile.getModuleRef((Module)m).getModuleFile();
        WSBinding wsb = null;
        try {
            wsb = WSModels.getWSBinding(mf.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.PluginCfgHelper.getRouterModuleName", "95");
        }
        if (wsb != null) {
            EList routers = wsb.getRouterModules();
            Iterator it = routers.iterator();
            while (it.hasNext()) {
                RouterModule rm = (RouterModule)it.next();
                String transport2 = rm.getTransport();
                if (!transport2.equalsIgnoreCase("http")) continue;
                routerModuleName = rm.getName();
                break;
            }
        }
        return routerModuleName;
    }

    public static List getWebServicesUrlPatterns(EARFile earFile, List deployedModules, Module m) {
        ConfigObject cfgObj;
        Object theObj;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWebServicesUrlPatterns");
        }
        LinkedList<String> patterns = new LinkedList<String>();
        ModuleFile mf = earFile.getModuleRef(m).getModuleFile();
        Application app = earFile.getDeploymentDescriptor();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Application: " + app.getDisplayName() + "[" + earFile.getName() + "], module: " + mf.getName());
        }
        ConfigService configService = null;
        try {
            configService = (ConfigService)WsServiceRegistry.getService(PluginCfgHelper.class, ConfigService.class);
        }
        catch (Throwable t) {
            // empty catch block
        }
        ConfigObject appDeployment = null;
        if (configService != null && deployedModules != null && deployedModules.size() > 0 && (theObj = deployedModules.get(0)) instanceof ConfigObject && (cfgObj = (ConfigObject)theObj) != null) {
            appDeployment = cfgObj.getParent();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The ApplicationDeployment ConfigObject: " + appDeployment.toString());
            }
        }
        if (appDeployment != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "About to call WSModels.preInvoke()");
            }
            WSModels.preInvoke(appDeployment);
        }
        WebModule wm = null;
        boolean isWebModule = m.isWebModule();
        JAXRPCMetaDataWrapper wrapper = null;
        try {
            JAXRPCMetaDataHelper helper = new JAXRPCMetaDataHelper((Archive)mf, PluginCfgHelper.getContextClassLoader());
            wrapper = helper.loadJAXRPCMetaData();
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.PluginCfgHelper.getWebServicesUrlPatterns", "209");
        }
        if (wrapper != null && wrapper.containsJAXRPCServices()) {
            WebServices webservices = wrapper.getWebServices();
            List jaxrpcPortComponents = wrapper.getJaxrpcPortComponents();
            if (isWebModule) {
                wm = (WebModule)m;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Module " + m.getUri() + " is a Web module.");
                }
            } else if (m.isEjbModule()) {
                Module m1;
                String routerModuleName = PluginCfgHelper.getRouterModuleName(earFile, (EjbModule)m);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Module " + m.getUri() + " is an EJB module, router module name is " + routerModuleName);
                }
                if (routerModuleName != null && (m1 = app.getModule(routerModuleName, null)) != null && m1.isWebModule()) {
                    wm = (WebModule)m1;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found router module: " + m1.getUri());
                    }
                }
            }
            if (wm != null) {
                WebApp webApp = null;
                try {
                    webApp = earFile.getDeploymentDescriptor(wm);
                }
                catch (Exception ex) {
                    FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.PluginCfgHelper.getWebServicesUrlPatterns", "199");
                }
                if (webApp != null) {
                    EList wsds = webservices.getWebServiceDescriptions();
                    Iterator it0 = wsds.iterator();
                    while (it0.hasNext()) {
                        PortComponent pc;
                        String pcName;
                        WebServiceDescription wsd = (WebServiceDescription)it0.next();
                        EList pcs = wsd.getPortComponents();
                        Iterator it1 = pcs.iterator();
                        while (it1.hasNext() && jaxrpcPortComponents.contains(pcName = (pc = (PortComponent)it1.next()).getPortComponentName())) {
                            String wsdlUrl;
                            ServletLink link;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Found JAX-RPC port component: " + pcName);
                            }
                            String servletName2 = (link = pc.getServiceImplBean().getEServletLink()) != null ? link.getServletLink() : pcName;
                            String url = null;
                            Servlet servlet = webApp.getServletNamed(servletName2);
                            ServletMapping mapping = webApp.getServletMapping(servlet);
                            boolean mappingFound = false;
                            if (mapping != null) {
                                url = mapping.getUrlPattern();
                                mappingFound = true;
                            }
                            if (url == null) {
                                url = "services/" + pcName;
                            }
                            String string = wsdlUrl = url.endsWith("/") ? url + "wsdl/*" : url + "/wsdl/*";
                            if (!mappingFound) {
                                patterns.add(url);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Added pattern: " + url);
                                }
                            }
                            patterns.add(wsdlUrl);
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "Added pattern: " + wsdlUrl);
                        }
                    }
                }
            }
        }
        if (appDeployment != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "About to call WSModels.postInvoke()");
            }
            WSModels.postInvoke(appDeployment);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWebServicesUrlPatterns");
        }
        return patterns;
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

