/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.BindingChoices;
import java.text.MessageFormat;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;

public class BindingChoicesHelper {
    private static TraceComponent tc = Tr.register(BindingChoices.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public static void extractModulesFilesToTmpDir(AppDeploymentTask task, String moduleURI, ModuleFile moduleFile, String tmpDirForModule) throws AppDeploymentException {
        try {
            moduleFile.extractTo(tmpDirForModule, 10);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.BindingChoicesHelper.extractModulesFiletToTmpDir", "403", "BindingChoicesHelper");
            Exception exceptionToLog = ex instanceof SaveFailureException ? ((SaveFailureException)ex).getNestedException() : ex;
            Object[] fillins = new Object[]{moduleURI, exceptionToLog};
            String message = MessageFormat.format(util.getMessage((AppDeploymentTask)task, (String)"WSWS0005E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingChoicesHelper.extractModulesFilesToTmpDir(): " + message);
            }
            Tr.error(tc, "WSWS0005E", fillins);
            throw new AppDeploymentException(message, (Throwable)exceptionToLog);
        }
    }

    public static void verifyThatWebServicesDescriptionWsdlFileActuallyExistsInModule(AppDeploymentTask task, String moduleURI, ModuleFile moduleFile, String nameOfInputWSDLFile) throws AppDeploymentException {
        if (!moduleFile.getLoadStrategy().getContainer().containsFile(nameOfInputWSDLFile)) {
            Object[] fillins = new Object[]{moduleURI, nameOfInputWSDLFile};
            String message = MessageFormat.format(util.getMessage((AppDeploymentTask)task, (String)"WSWS0016E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "BindingChoicesHelper.verifyThatWebServicesDescriptionWsdlFileActuallyExistsInModule(): " + message);
            }
            throw new AppDeploymentException(message, null);
        }
    }
}

