/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.CatalogManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import org.xml.sax.InputSource;

public abstract class BaseWSDLLocator {
    private static TraceComponent _tc = Tr.register(BaseWSDLLocator.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    protected String baseURI;
    protected String lastestImportURI;
    protected InputStream baseInputStream;
    protected CatalogManager catalogManager;
    protected ClassLoader classLoader;
    private static final char WSDL_PATH_SEPERATOR_CHAR = '/';
    private static final String WSDL_PATH_SEPERATOR = new Character('/').toString();

    protected abstract InputStream getInputStream(String var1) throws IOException;

    public InputSource getBaseInputSource() {
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String parentLocation, String importPath) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getImportInputSource", new Object[]{parentLocation, importPath, this});
        }
        InputSource inputSource = null;
        try {
            String tmpPath;
            boolean resolved = false;
            if (this.catalogManager != null && (tmpPath = this.catalogManager.resolveLocation(importPath)) != null && !tmpPath.equals(importPath)) {
                importPath = tmpPath;
                resolved = true;
            }
            if (!this.isAbsoluteImport(importPath)) {
                String string = importPath = resolved ? importPath : this.normalizePath(parentLocation, importPath);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Normalized relative import to: " + importPath);
                }
            }
            if (this.isAbsoluteImport(importPath)) {
                URL absoluteURL = new URL(importPath);
                inputSource = new InputSource(absoluteURL.openStream());
                this.lastestImportURI = absoluteURL.toExternalForm();
            } else {
                InputStream is = this.getInputStream(importPath);
                inputSource = new InputSource(is);
                this.lastestImportURI = importPath;
            }
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.client.BaseWSDLLocator.getImportInputSource", "90", this);
            Tr.error(_tc, "internal.error", ex);
            throw new RuntimeException("Caught IOException reading wsdl file from EAR " + ex);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getImportInputSource", inputSource);
        }
        return inputSource;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getLatestImportURI() {
        return this.lastestImportURI;
    }

    protected String convertURI(String rawURI) {
        int idx = rawURI.lastIndexOf(47);
        rawURI = idx > 0 ? rawURI.substring(0, idx + 1) : "";
        return rawURI;
    }

    protected boolean isAbsoluteImport(String uri) {
        boolean absolute = false;
        if (uri != null) {
            absolute = uri.indexOf("://") > 0;
        }
        return absolute;
    }

    protected String normalizePath(String parentLocation, String relativeLocation) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizePath");
        }
        String pathFromRoot = this.convertURI(parentLocation);
        StringBuffer pathToRelativeLocation = new StringBuffer(pathFromRoot);
        StringTokenizer tokenizedRelativeLocation = new StringTokenizer(relativeLocation, WSDL_PATH_SEPERATOR);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "pathFromRoot = " + pathFromRoot);
            Tr.debug(_tc, "relativeLocation = " + relativeLocation);
        }
        while (tokenizedRelativeLocation.hasMoreTokens()) {
            String nextToken = tokenizedRelativeLocation.nextToken();
            if (nextToken.equals("..")) {
                int charToDelete = pathToRelativeLocation.length() - 1;
                if (pathToRelativeLocation.charAt(charToDelete) == '/') {
                    pathToRelativeLocation.deleteCharAt(charToDelete--);
                }
                while (pathToRelativeLocation.charAt(charToDelete) != '/') {
                    pathToRelativeLocation.deleteCharAt(charToDelete--);
                }
                continue;
            }
            if (nextToken.equals(".")) continue;
            if (pathToRelativeLocation.charAt(pathToRelativeLocation.length() - 1) != '/') {
                pathToRelativeLocation.append('/');
            }
            pathToRelativeLocation.append(nextToken);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Built path = " + pathToRelativeLocation.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizePath");
        }
        return pathToRelativeLocation.toString();
    }

    public void close() {
    }
}

