/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class VirtualHostMapper {
    protected HashMap vHostTable = new HashMap();

    public void addMapping(String path, Object target) {
        this.vHostTable.put(this.normalize(path), target);
    }

    private String normalize(String alias) {
        String regExp = new String(alias);
        regExp = regExp.replaceAll("[\\.]", "\\\\\\.");
        regExp = regExp.replaceAll("[*]", "\\.\\*");
        return regExp;
    }

    public void removeMapping(String key) {
        this.vHostTable.remove(this.normalize(key));
    }

    public Iterator targetMappings() {
        Collection vHosts = this.vHostTable.values();
        ArrayList l = new ArrayList();
        l.addAll(vHosts);
        return l.listIterator();
    }

    public Object replaceMapping(String path, Object target) throws Exception {
        return null;
    }

    public Object getMapping(String vHostKey) {
        Iterator i = this.vHostTable.keySet().iterator();
        String bestMatchingPattern = null;
        int bestMatchingPatternLength = -1;
        while (i.hasNext()) {
            try {
                String pattern = (String)i.next();
                if (!vHostKey.matches(pattern)) continue;
                if (vHostKey.equals(pattern)) {
                    bestMatchingPattern = pattern;
                    break;
                }
                if (bestMatchingPattern == null) {
                    bestMatchingPattern = pattern;
                    bestMatchingPatternLength = pattern.length();
                    continue;
                }
                if (pattern.length() < bestMatchingPatternLength) continue;
                bestMatchingPattern = pattern;
                bestMatchingPatternLength = pattern.length();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (bestMatchingPattern != null) {
            return this.vHostTable.get(bestMatchingPattern);
        }
        return null;
    }

    public boolean exists(String path) {
        Iterator i = this.vHostTable.keySet().iterator();
        while (i.hasNext()) {
            try {
                String pattern = (String)i.next();
                if (!path.matches(pattern)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public boolean exactMatchExists(String path) {
        String _path = this.normalize(path);
        Iterator i = this.vHostTable.keySet().iterator();
        while (i.hasNext()) {
            try {
                String pattern = (String)i.next();
                if (!_path.equals(pattern)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    protected Object findExactMatch(String path) {
        String _path = this.normalize(path);
        Iterator i = this.vHostTable.keySet().iterator();
        while (i.hasNext()) {
            try {
                String pattern = (String)i.next();
                if (!_path.equals(pattern)) continue;
                return this.vHostTable.get(pattern);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

