/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.BoundedBuffer;
import com.ibm.ws.util.ThreadPoolListener;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ThreadPool {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 5000L;
    protected int maximumPoolSize_ = Integer.MAX_VALUE;
    protected int minimumPoolSize_ = 1;
    protected int poolSize_ = 0;
    protected int activeThreads = 0;
    protected long keepAliveTime_ = 5000L;
    protected BoundedBuffer requestBuffer;
    protected boolean shutdown_ = false;
    protected final Map threads_;
    protected int threadid = 0;
    protected boolean growasneeded = false;
    private ClassLoader contextClassLoader;
    protected int threadpriority = 5;
    private static ThreadPoolListener[] ZERO_TP_LISTENERS = new ThreadPoolListener[0];
    protected ThreadPoolListener[] threadPoolListeners;
    protected String name;
    private static Field threadLocalsField;
    static Object[] ZERO_OBJECTS;

    public ThreadPool(int minSize, int maxSize, ThreadPoolListener[] tpls) {
        this(null, minSize, maxSize, tpls);
    }

    public ThreadPool(String name2, int minSize, int maxSize) {
        this(name2, minSize, maxSize, null);
    }

    public ThreadPool(String name2, int minPoolSize, int maxPoolSize, ThreadPoolListener[] tpls) {
        this.name = name2;
        this.maximumPoolSize_ = maxPoolSize;
        this.minimumPoolSize_ = minPoolSize;
        this.threads_ = new HashMap();
        this.requestBuffer = new BoundedBuffer((minPoolSize + maxPoolSize) / 2);
        this.threadPoolListeners = tpls == null ? ZERO_TP_LISTENERS : (ThreadPoolListener[])tpls.clone();
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadPoolCreated(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public synchronized void setMaximumPoolSize(int newMaximum) {
        if (newMaximum <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = newMaximum;
    }

    public synchronized int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public synchronized void setMinimumPoolSize(int newMinimum) {
        if (newMinimum < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = newMinimum;
    }

    public synchronized int getPoolSize() {
        return this.poolSize_;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long msecs) {
        this.keepAliveTime_ = msecs;
    }

    protected void addThread(Runnable command) {
        Worker worker = new Worker(command, this.threadid++);
        this.threads_.put(worker, worker);
        ++this.poolSize_;
        ++this.activeThreads;
        this.fireThreadCreated(this.poolSize_);
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createThreads(int numberOfThreads) {
        int ncreated = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this.poolSize_ < this.maximumPoolSize_) {
                    this.addThread(null);
                    ++ncreated;
                } else {
                    break;
                }
                continue;
            }
        }
        return ncreated;
    }

    public synchronized void shutdownNow() {
        this.shutdown_ = true;
        this.maximumPoolSize_ = 0;
        this.minimumPoolSize_ = 0;
        this.interruptAll();
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.shutdown_ = true;
        if (this.poolSize_ == 0) {
            this.maximumPoolSize_ = 0;
            this.minimumPoolSize_ = 0;
        }
    }

    public synchronized void interruptAll() {
        for (Thread t : this.threads_.values()) {
            t.interrupt();
        }
    }

    public synchronized boolean awaitTerminationAfterShutdown(long maxWaitTime) throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        if (this.poolSize_ == 0) {
            return true;
        }
        long waitTime = maxWaitTime;
        if (waitTime <= 0L) {
            return false;
        }
        long start = System.currentTimeMillis();
        do {
            this.wait(waitTime);
            if (this.poolSize_ != 0) continue;
            return true;
        } while ((waitTime = maxWaitTime - (System.currentTimeMillis() - start)) > 0L);
        return false;
    }

    public synchronized void awaitTerminationAfterShutdown() throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        while (this.poolSize_ > 0) {
            this.wait();
        }
    }

    protected synchronized void workerDone(Worker w, boolean taskDied) {
        this.threads_.remove(w);
        if (taskDied) {
            --this.activeThreads;
            --this.poolSize_;
        }
        if (this.poolSize_ == 0 && this.shutdown_) {
            this.minimumPoolSize_ = 0;
            this.maximumPoolSize_ = 0;
            this.notifyAll();
        }
        this.fireThreadDestroyed(this.poolSize_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable getTask() throws InterruptedException {
        Runnable r = null;
        boolean firstTime = true;
        while (true) {
            long waitTime;
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (firstTime) {
                    --this.activeThreads;
                }
                if (!(this.poolSize_ <= this.maximumPoolSize_ || this.growasneeded && firstTime)) {
                    --this.poolSize_;
                    return null;
                }
                waitTime = this.shutdown_ ? 0L : (this.poolSize_ <= this.minimumPoolSize_ ? -1L : this.keepAliveTime_);
            }
            r = waitTime >= 0L ? (Runnable)this.requestBuffer.poll(waitTime) : (Runnable)this.requestBuffer.take();
            threadPool = this;
            synchronized (threadPool) {
                if (r == null) {
                    r = (Runnable)this.requestBuffer.poll(0L);
                }
                if (r != null) {
                    ++this.activeThreads;
                    break;
                }
                if (this.poolSize_ > this.minimumPoolSize_) {
                    --this.poolSize_;
                    break;
                }
            }
            firstTime = false;
        }
        return r;
    }

    public void setGrowAsNeeded(boolean onoff) {
        this.growasneeded = onoff;
    }

    public boolean isGrowAsNeeded() {
        return this.growasneeded;
    }

    public void setContextClassLoader(ClassLoader cl) {
        this.contextClassLoader = cl;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public void setThreadPriority(int priority2) {
        this.threadpriority = priority2;
    }

    public int getThreadPriority() {
        return this.threadpriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) throws InterruptedException {
        boolean offered = false;
        boolean yield = false;
        while (true) {
            if (yield) {
                Thread.yield();
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (!this.shutdown_) {
                    if (!offered) {
                        offered = this.requestBuffer.offer(command, 0L);
                    }
                    if (this.growasneeded && !offered && !yield) {
                        yield = true;
                        continue;
                    }
                    int size = this.poolSize_;
                    if (offered && size - this.activeThreads > this.requestBuffer.size()) {
                        return;
                    }
                    if (size < this.maximumPoolSize_ || this.growasneeded) {
                        this.addThread(null);
                    }
                    if (offered) {
                        return;
                    }
                }
            }
            this.requestBuffer.put(command);
            offered = true;
        }
    }

    public void addThreadPoolListener(ThreadPoolListener tpl) {
        int size = this.threadPoolListeners.length + 1;
        ThreadPoolListener[] tpls = new ThreadPoolListener[size];
        System.arraycopy(this.threadPoolListeners, 0, tpls, 0, size - 1);
        tpls[size - 1] = tpl;
        this.threadPoolListeners = tpls;
    }

    public void removeThreadPoolListener(ThreadPoolListener tpl) {
        int idx;
        for (idx = 0; idx < this.threadPoolListeners.length && this.threadPoolListeners[idx] != tpl; ++idx) {
        }
        if (idx < this.threadPoolListeners.length) {
            int size = this.threadPoolListeners.length - 1;
            ThreadPoolListener[] tpls = new ThreadPoolListener[size];
            System.arraycopy(this.threadPoolListeners, 0, tpls, 0, idx);
            System.arraycopy(this.threadPoolListeners, idx + 1, tpls, idx, size - idx - 1);
            this.threadPoolListeners = tpls;
        }
    }

    protected void fireThreadCreated(int poolSize) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadCreated(this, poolSize);
        }
    }

    protected void fireThreadStarted(int activeThreads, int maxThreads) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadStarted(this, activeThreads, maxThreads);
        }
    }

    protected void fireThreadReturned(int activeThreads, int maxThreads) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadReturned(this, activeThreads, maxThreads);
        }
    }

    protected void fireThreadDestroyed(int poolSize) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadDestroyed(this, poolSize);
        }
    }

    public synchronized boolean areRequestsOutstanding() {
        if (this.poolSize_ == 0) {
            return false;
        }
        for (Thread t : this.threads_.values()) {
            if (!t.isAlive()) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ZERO_OBJECTS = new Object[0];
    }

    class Worker
    extends Thread {
        protected Runnable firstTask_;
        private String id;
        protected Map threadLocalsMap;
        Object[] wsThreadLocals;

        protected Worker(Runnable firstTask, int id) {
            super(ThreadPool.this.name + " : " + id);
            this.id = null;
            this.wsThreadLocals = ZERO_OBJECTS;
            this.firstTask_ = firstTask;
            this.setPriority(ThreadPool.this.getThreadPriority());
            this.setDaemon(true);
            this.initThreadLocal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            Runnable task = this.firstTask_;
            try {
                this.firstTask_ = null;
                if (task != null) {
                    ThreadPool.this.fireThreadStarted(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                    try {
                        task.run();
                    }
                    finally {
                        ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                        if (this.threadLocalsMap != null) {
                            if (this.threadLocalsMap == Collections.EMPTY_MAP) {
                                this.initThreadLocal();
                            }
                            this.threadLocalsMap.clear();
                        } else {
                            try {
                                threadLocalsField.set(this, null);
                            }
                            catch (IllegalAccessException e) {}
                        }
                    }
                }
                while ((task = ThreadPool.this.getTask()) != null) {
                    ThreadPool.this.fireThreadStarted(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                    try {
                        task.run();
                    }
                    finally {
                        ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                        if (this.threadLocalsMap != null) {
                            if (this.threadLocalsMap == Collections.EMPTY_MAP) {
                                this.initThreadLocal();
                            }
                            this.threadLocalsMap.clear();
                            continue;
                        }
                        try {
                            threadLocalsField.set(this, null);
                        }
                        catch (IllegalAccessException e) {}
                    }
                }
                ThreadPool.this.workerDone(this, task != null);
            }
            catch (InterruptedException interruptedException) {
                ThreadPool.this.workerDone(this, task != null);
                catch (Throwable throwable) {
                    ThreadPool.this.workerDone(this, task != null);
                    throw throwable;
                }
            }
        }

        private void initThreadLocal() {
            try {
                Object tlo = threadLocalsField.get(this);
                if (tlo instanceof Map) {
                    this.threadLocalsMap = (Map)tlo;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

