/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.os400.utils.FileUtils;
import com.ibm.ws.util.WSUtil;
import java.io.File;
import java.io.IOException;

public class FileSystem {
    public static final boolean isCaseInsensitive = System.getProperty("os.name").toLowerCase().equals("os/400") || System.getProperty("os.name").toLowerCase().startsWith("windows");
    public static final boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    public static final boolean matchSymLink = Boolean.getBoolean("os400.was.symlink.serving") && System.getProperty("os.name").toLowerCase().equals("os/400");

    public static boolean uriCaseCheck(File file, String matchString) throws IOException {
        if (isCaseInsensitive || isWindows) {
            matchString = WSUtil.resolveURI(matchString);
            matchString = matchString.replace('/', File.separatorChar);
            String canPath = null;
            canPath = matchSymLink ? FileUtils.getSourceFileName((String)file.getAbsolutePath(), (int)(file.getAbsolutePath().length() - matchString.length())) : file.getCanonicalPath();
            int inx = matchString.length();
            int offset = 0;
            if (isWindows && inx > 1 && canPath.length() > 0 && matchString.charAt(1) == ':') {
                if (!matchString.substring(0, 1).equalsIgnoreCase(canPath.substring(0, 1))) {
                    return false;
                }
                offset = 1;
            }
            return canPath.regionMatches(canPath.length() - inx + offset, matchString, offset, inx - offset);
        }
        return true;
    }
}

