/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.channel.impl.SSLChannelFactory;
import com.ibm.ws.ssl.channel.impl.SSLOutboundChannelDefinition;
import com.ibm.ws.ssl.channel.impl.WSSSLChannel;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.WSChannelFactoryRCS;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WSSSLChannelFactory
extends SSLChannelFactory
implements WSChannelFactoryRCS {
    private static final TraceComponent tc = Tr.register(WSSSLChannelFactory.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");

    protected Channel createChannel(ChannelData channelData) throws ChannelException {
        return new WSSSLChannel(channelData, this);
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map data) {
        return new SSLOutboundChannelDefinition(data);
    }

    public Map createFactoryConfigurationMap(ConfigObject factoryConfig, ChannelFrameworkService service) {
        return null;
    }

    public Map createChannelConfigurationMap(ConfigObject channelConfig, ChannelFrameworkService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createChannelConfigurationMap", channelConfig);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        List customPropList = channelConfig.getObjectList("properties");
        if (channelConfig.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "SSLInboundChannel") || channelConfig.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.channels.xmi", "SSLOutboundChannel")) {
            try {
                String alias = channelConfig.getString("sslConfigAlias", null);
                if (alias != null) {
                    result.put("alias", alias);
                }
            }
            catch (Exception exp) {
                Tr.error(tc, "unable.to.read.config", exp);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SSL Property alias=" + result.get("alias"));
        }
        if (null != customPropList) {
            for (ConfigObject property : customPropList) {
                result.put(property.getString("name", null), property.getString("value", null));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Custom SSL Property " + property.getString("name", null) + " = " + property.getString("value", null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createChannelConfigurationMap", result);
        }
        return result;
    }

    public String determineAcceptorID(ConfigObject channelConfig) {
        return null;
    }
}

