/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public final class ServerIdentityHelper {
    private static final TraceComponent tc = Tr.register(ServerIdentityHelper.class, "Security", "com.ibm.ejs.resources.security");
    private WSLoginLocalOSExtension _extension;
    private static final ServerIdentityHelper helper = new ServerIdentityHelper();

    public static ServerIdentityHelper getServerIdentityHelper() {
        return helper;
    }

    private ServerIdentityHelper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        try {
            this._extension = (WSLoginLocalOSExtension)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WSLoginLocalOSExtensionFactory.getInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Manager.Ffdc.log(pae, this, "com.ibm.ws.security.util.ServerIdentityHelper.<init>", "82", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to acquire local OS extension helper", pae);
            }
            this._extension = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public synchronized Object push() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "push");
        }
        Object retObject = null;
        if (this.isApplicationSyncEnabled() || RasHelper.isServer() && this.isRunAsEnabled()) {
            try {
                retObject = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ContextManager contextMgr = ContextManagerFactory.getInstance();
                        Subject serverSubj = contextMgr.getServerSubject();
                        if (ServerIdentityHelper.this.isApplicationSyncEnabled()) {
                            return ServerIdentityHelper.this._extension.setAppLocalOSThreadID(serverSubj);
                        }
                        return ServerIdentityHelper.this._extension.setLocalOSThreadID(serverSubj);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                String message = "Unable to associate server subject with OS thread";
                SecurityException se = new SecurityException("Unable to associate server subject with OS thread");
                se.initCause(se.getCause());
                Manager.Ffdc.log(se, this, "com.ibm.ws.security.util.ServerIdentityHelper.push", "121", this);
                throw se;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "push", retObject);
        }
        return retObject;
    }

    public synchronized void pop(final Object credToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pop", credToken);
        }
        if (credToken != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ServerIdentityHelper.this._extension.restoreAppLocalOSThreadID(credToken);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                String message = "Unable to disassociate server subject from the OS thread";
                SecurityException se = new SecurityException("Unable to disassociate server subject from the OS thread");
                se.initCause(se.getCause());
                Manager.Ffdc.log(se, this, "com.ibm.ws.security.util.ServerIdentityHelper.pop", "155", this);
                throw se;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pop");
        }
    }

    private boolean isApplicationSyncEnabled() {
        boolean enabled;
        boolean bl = enabled = this._extension != null && this._extension.isThreadLocalApplicationSyncEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Application sync enabled: " + enabled);
        }
        return enabled;
    }

    private boolean isRunAsEnabled() {
        boolean enabled;
        boolean bl = enabled = this._extension != null && this._extension.isSyncToThreadEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Connection manager RunAs thread identity enabled: " + enabled);
        }
        return enabled;
    }
}

