/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import java.util.Arrays;
import java.util.HashSet;

public class RestrictedAccess {
    private static final String security_xml = "/security.xml";
    private static final String security_xml_noSlash = "security.xml";
    private static final String ws_security_xml = "/ws-security.xml";
    private static final String ws_security_xml_noSlash = "ws-security.xml";
    private static final String admin_authz_xml = "/admin-authz.xml";
    private static final String admin_authz_xml_noSlash = "admin-authz.xml";
    private static final String srv_sec_signature = "/servers/";
    private static final String domain_security_xml = "/domain-security.xml";
    private static final String domain_security_xml_noSlash = "domain-security.xml";
    private static final String security_class_name = "com.ibm.websphere.models.config.security.Security";
    private static final String ltpa_class_name = "com.ibm.websphere.models.config.security.LTPA";
    private static final String user_registry_class_name = "com.ibm.websphere.models.config.security.UserRegistry";
    private static final String localos_user_registry_class_name = "com.ibm.websphere.models.config.security.LocalOSUserRegistry";
    private static final String ldap_user_registry_class_name = "com.ibm.websphere.models.config.security.LDAPUserRegistry";
    private static final String custom_user_registry_class_name = "com.ibm.websphere.models.config.security.CustomUserRegistry";
    private static final String secure_socket_layer_class_name = "com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer";
    private static final String jaas_auth_data_class_name = "com.ibm.websphere.models.config.jaaslogin.JAASAuthData";
    private static final String per_srv_sec_attr = "com.ibm.websphere.models.config.security.Security.enforceJava2Security";
    private static final String[] names = new String[]{"com.ibm.websphere.models.config.security.Security.enabled", "com.ibm.websphere.models.config.security.Security.enforceJava2Security", "com.ibm.websphere.models.config.security.Security.properties", "com.ibm.websphere.models.config.security.LTPA.password", "com.ibm.websphere.models.config.security.LTPA.private", "com.ibm.websphere.models.config.security.LTPA.public", "com.ibm.websphere.models.config.security.LTPA.shared", "com.ibm.websphere.models.config.security.UserRegistry.serverPassword", "com.ibm.websphere.models.config.security.UserRegistry.serverId", "com.ibm.websphere.models.config.security.LocalOSUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.LocalOSUserRegistry.serverId", "com.ibm.websphere.models.config.security.LDAPUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.LDAPUserRegistry.serverId", "com.ibm.websphere.models.config.security.CustomUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.CustomUserRegistry.serverId"};
    private static final HashSet attributes = new HashSet<String>(Arrays.asList(names));
    private static final String[] class_names = new String[]{"com.ibm.websphere.models.config.security.Security", "com.ibm.websphere.models.config.security.LTPA", "com.ibm.websphere.models.config.security.UserRegistry", "com.ibm.websphere.models.config.security.LocalOSUserRegistry", "com.ibm.websphere.models.config.security.LDAPUserRegistry", "com.ibm.websphere.models.config.security.CustomUserRegistry"};
    private static final HashSet classes = new HashSet<String>(Arrays.asList(class_names));
    private static final String[] sensitive_class_names = new String[]{"com.ibm.websphere.models.config.security.Security", "com.ibm.websphere.models.config.security.LTPA", "com.ibm.websphere.models.config.security.UserRegistry", "com.ibm.websphere.models.config.security.LocalOSUserRegistry", "com.ibm.websphere.models.config.security.LDAPUserRegistry", "com.ibm.websphere.models.config.security.CustomUserRegistry", "com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer", "com.ibm.websphere.models.config.jaaslogin.JAASAuthData"};
    private static final HashSet sensitive_classes = new HashSet<String>(Arrays.asList(sensitive_class_names));
    private static final String[] sensitive_names = new String[]{"com.ibm.websphere.models.config.security.LTPA.password", "com.ibm.websphere.models.config.security.LTPA.private", "com.ibm.websphere.models.config.security.LTPA.public", "com.ibm.websphere.models.config.security.LTPA.shared", "com.ibm.websphere.models.config.security.UserRegistry.serverPassword", "com.ibm.websphere.models.config.security.LocalOSUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.LDAPUserRegistry.serverPassword", "com.ibm.websphere.models.config.security.CustomUserRegistry.serverPassword", "com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer.keyFilePassword", "com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer.trustFilePassword", "com.ibm.websphere.models.config.jaaslogin.JAASAuthData.password"};
    private static final HashSet sensitive_attributes = new HashSet<String>(Arrays.asList(sensitive_names));

    public static boolean isRestricted(String config_file_uri) {
        return config_file_uri.endsWith(security_xml) || config_file_uri.equals(security_xml_noSlash) || config_file_uri.endsWith(ws_security_xml) || config_file_uri.equals(ws_security_xml_noSlash) || config_file_uri.endsWith(admin_authz_xml) || config_file_uri.equals(admin_authz_xml_noSlash) || config_file_uri.endsWith(domain_security_xml) || config_file_uri.equals(domain_security_xml_noSlash);
    }

    public static boolean isRestricted(String config_file_uri, String class_name, String attribute_name) {
        boolean result = false;
        if (config_file_uri.endsWith(security_xml) || config_file_uri.equals(security_xml_noSlash) || config_file_uri.endsWith(ws_security_xml) || config_file_uri.equals(ws_security_xml_noSlash) || config_file_uri.endsWith(domain_security_xml) || config_file_uri.equals(domain_security_xml_noSlash)) {
            if (config_file_uri.indexOf(srv_sec_signature) > 1) {
                if (per_srv_sec_attr.equals(class_name + "." + attribute_name)) {
                    result = true;
                }
            } else if (attributes.contains(class_name + "." + attribute_name)) {
                result = true;
            }
        } else if (config_file_uri.endsWith(admin_authz_xml) || config_file_uri.equals(admin_authz_xml_noSlash)) {
            result = true;
        }
        return result;
    }

    public static boolean isRestricted(String config_file_uri, String class_name) {
        boolean result = false;
        if (config_file_uri.endsWith(security_xml) || config_file_uri.equals(security_xml_noSlash) || config_file_uri.endsWith(ws_security_xml) || config_file_uri.equals(ws_security_xml_noSlash) || config_file_uri.endsWith(domain_security_xml) || config_file_uri.equals(domain_security_xml_noSlash)) {
            if (config_file_uri.indexOf(srv_sec_signature) > 1) {
                if (class_name.equals(security_class_name)) {
                    result = true;
                }
            } else if (classes.contains(class_name)) {
                result = true;
            }
        } else if (config_file_uri.endsWith(admin_authz_xml) || config_file_uri.equals(admin_authz_xml_noSlash)) {
            result = true;
        }
        return result;
    }

    public static boolean isReadable(String config_file_uri) {
        return !config_file_uri.endsWith(security_xml) && !config_file_uri.equals(security_xml_noSlash) && !config_file_uri.endsWith(domain_security_xml) && !config_file_uri.equals(domain_security_xml_noSlash);
    }

    public static boolean isReadable(String config_file_uri, String class_name) {
        boolean result = true;
        if (config_file_uri.endsWith(security_xml) || config_file_uri.equals(security_xml_noSlash) || config_file_uri.endsWith(ws_security_xml) || config_file_uri.equals(ws_security_xml_noSlash) || config_file_uri.endsWith(domain_security_xml) || config_file_uri.equals(domain_security_xml_noSlash)) {
            result = !sensitive_classes.contains(class_name);
        }
        return result;
    }

    public static boolean isReadable(String config_file_uri, String class_name, String attribute_name) {
        boolean result = true;
        if (config_file_uri.endsWith(security_xml) || config_file_uri.equals(security_xml_noSlash) || config_file_uri.endsWith(ws_security_xml) || config_file_uri.equals(ws_security_xml_noSlash) || config_file_uri.endsWith(domain_security_xml) || config_file_uri.equals(domain_security_xml_noSlash)) {
            result = !sensitive_attributes.contains(class_name + "." + attribute_name);
        }
        return result;
    }
}

