/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.util.InvalidPasswordDecodingException;
import com.ibm.ws.security.util.InvalidPasswordEncodingException;
import com.ibm.ws.security.util.UnsupportedCryptoAlgorithmException;

public class PasswordUtil {
    private static final TraceComponent tc = Tr.register(PasswordUtil.class, null, "com.ibm.ejs.resources.security");
    public static final String DEFAULT_CRYPTO_ALGORITHM = com.ibm.ISecurityUtilityImpl.PasswordUtil.DEFAULT_CRYPTO_ALGORITHM;
    public static final String STRING_CONVERSION_CODE = "UTF8";

    public static final String decode(String encoded_string) throws InvalidPasswordDecodingException, UnsupportedCryptoAlgorithmException {
        try {
            return com.ibm.ISecurityUtilityImpl.PasswordUtil.decode(encoded_string);
        }
        catch (com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException e) {
            Tr.debug(tc, "Caught an exception when decoding the password. This probably means that the password was not encoded: ", e.toString());
            throw new InvalidPasswordDecodingException();
        }
        catch (com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException e) {
            Manager.Ffdc.log((Throwable)((Object)e), PasswordUtil.class, "com.ibm.ws.security.util.PasswordUtil.decode", "88");
            throw new UnsupportedCryptoAlgorithmException();
        }
    }

    public static final String encode(String decoded_string) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        try {
            return com.ibm.ISecurityUtilityImpl.PasswordUtil.encode(decoded_string);
        }
        catch (com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException e) {
            Manager.Ffdc.log((Throwable)((Object)e), PasswordUtil.class, "com.ibm.ws.security.util.PasswordUtil.encode", "106");
            throw new InvalidPasswordEncodingException();
        }
        catch (com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException e) {
            Manager.Ffdc.log((Throwable)((Object)e), PasswordUtil.class, "com.ibm.ws.security.util.PasswordUtil.encode", "111");
            throw new UnsupportedCryptoAlgorithmException();
        }
    }

    public static final String encode(String decoded_string, String crypto_algorithm) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        try {
            return com.ibm.ISecurityUtilityImpl.PasswordUtil.encode(decoded_string, crypto_algorithm);
        }
        catch (com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException e) {
            Manager.Ffdc.log((Throwable)((Object)e), PasswordUtil.class, "com.ibm.ws.security.util.PasswordUtil.encode", "129");
            throw new InvalidPasswordEncodingException();
        }
        catch (com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException e) {
            Manager.Ffdc.log((Throwable)((Object)e), PasswordUtil.class, "com.ibm.ws.security.util.PasswordUtil.encode", "134");
            throw new UnsupportedCryptoAlgorithmException();
        }
    }

    public static final String getCryptoAlgorithm(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.getCryptoAlgorithm(encoded_string);
    }

    public static final String getCryptoAlgorithmTag(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.getCryptoAlgorithmTag(encoded_string);
    }

    public static final boolean isEncrypted(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.isEncrypted(encoded_string);
    }

    public static final boolean isValidCryptoAlgorithm(String crypto_algorithm) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.isValidCryptoAlgorithm(crypto_algorithm);
    }

    public static final boolean isValidCryptoAlgorithmTag(String crypto_algorithm_tag) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.isValidCryptoAlgorithmTag(crypto_algorithm_tag);
    }

    public static final String passwordDecode(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.passwordDecode(encoded_string);
    }

    public static final String passwordEncode(String decoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.passwordEncode(decoded_string);
    }

    public static final String passwordEncode(String decoded_string, String crypto_algorithm) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.passwordEncode(decoded_string, crypto_algorithm);
    }

    public static final String removeCryptoAlgorithmTag(String encoded_string) {
        return com.ibm.ISecurityUtilityImpl.PasswordUtil.removeCryptoAlgorithmTag(encoded_string);
    }
}

