/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.collaborator;

import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;

public abstract class J2EEResourceMBean
extends J2EEManagedObjectCollaborator {
    private static final TraceComponent tc = Tr.register(J2EEResourceMBean.class, "Runtime", null);
    private String name;
    private String description;

    public J2EEResourceMBean() {
    }

    public J2EEResourceMBean(J2EEResourceProvider rp, String serverName) {
        this.name = rp.getName();
        this.description = rp.getDescription();
        this.activate(rp, serverName);
    }

    public J2EEResourceMBean(ConfigObject resourceProvider, String serverName) {
        this.name = resourceProvider.getString("name", "__null__");
        this.description = resourceProvider.getString("description", "__null__");
        this.activate(resourceProvider, serverName);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    private ObjectName activate(Object rp, String serverName) {
        ObjectName mbeanName = null;
        try {
            Properties keyProperties = new Properties();
            keyProperties.setProperty("name", this.name);
            keyProperties.setProperty("Server", serverName);
            MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
            String configId = mbeanFactory.getConfigId(rp);
            mbeanName = mbeanFactory.activateMBean(this.getResourceType(), this, configId, null, keyProperties);
        }
        catch (AdminException x) {
            if (x.getCause() instanceof InstanceAlreadyExistsException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception", x);
                }
            }
            Manager.Ffdc.log(x, this, J2EEResourceMBean.class.getName(), "92");
        }
        return mbeanName;
    }

    protected abstract String getResourceType();

    protected Properties getAdditionalProps() {
        return null;
    }
}

