/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.naming.Referenceable;

public class MQConnectionFactoryBinder
extends JMSBinder {
    private static TraceComponent tc = Tr.register(MQConnectionFactoryBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.mqseries.xmi", "MQConnectionFactory");
    }

    public Object getBindingObject(ConfigObject resource) throws ResourceBindingException {
        int intValueBrokerVersion;
        int intValueTransportType;
        Properties jmsProps = new Properties();
        ConfigObject jmsProvider = resource.getParent();
        ConfigObject connectionPool = resource.getObject("connectionPool");
        this.checkRequiredProperty(resource.getString("name", "__null__"), "ConnectionPool", connectionPool);
        ConfigObject sessionPool = resource.getObject("sessionPool");
        this.addPropertySet(jmsProps, jmsProvider.getObject("propertySet"), true);
        this.setProperty(jmsProps, "NAME", resource.getString("name", "__null__"), true);
        this.setProperty(jmsProps, "DESC", resource.getString("description", "__null__"), true);
        this.setProperty(jmsProps, "QMGR", resource.getString("queueManager", "__null__"), true);
        String stringValue = resource.getString("transportType", "BINDINGS");
        if (stringValue.equals("BINDINGS_THEN_CLIENT")) {
            intValueTransportType = 8;
        } else if (stringValue.equals("BINDINGS")) {
            intValueTransportType = 0;
        } else if (stringValue.equals("CLIENT")) {
            intValueTransportType = 1;
        } else if (stringValue.equals("DIRECT")) {
            intValueTransportType = 2;
        } else if (stringValue.equals("DIRECTHTTP")) {
            intValueTransportType = 4;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "TRAN", resource.isSet("transportType") ? Integer.valueOf(intValueTransportType) : null, true);
        if (intValueTransportType != 0) {
            this.setNonBindingsModeProperties(jmsProps, resource);
        }
        this.setProperty(jmsProps, "TM", resource.getString("tempModel", "__null__"), true);
        this.setProperty(jmsProps, "CID", resource.getString("clientID", "__null__"), true);
        this.setProperty(jmsProps, "BCON", resource.getString("brokerControlQueue", "__null__"), true);
        this.setProperty(jmsProps, "BQM", resource.getString("brokerQueueManager", "__null__"), true);
        this.setProperty(jmsProps, "BPUB", resource.getString("brokerPubQueue", "__null__"), true);
        this.setProperty(jmsProps, "BSUB", resource.getString("brokerSubQueue", "__null__"), true);
        this.setProperty(jmsProps, "CCSUB", resource.getString("brokerCCSubQ", "__null__"), true);
        stringValue = resource.getString("brokerVersion", "MQSI");
        if (stringValue.equals("MA0C")) {
            intValueBrokerVersion = 1;
        } else if (stringValue.equals("MQSI")) {
            intValueBrokerVersion = 0;
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "BVER", intValueBrokerVersion, true);
        this.setProperty(jmsProps, "MRET", resource.isSet("msgRetention") ? new Boolean(resource.getBoolean("msgRetention", true)) : null, true);
        this.setProperty(jmsProps, "XAEnabled", resource.isSet("XAEnabled") ? new Boolean(resource.getBoolean("XAEnabled", true)) : Boolean.TRUE, true);
        this.setProperty(jmsProps, "CLONESUP", resource.isSet("cloneSupport") ? new Boolean(resource.getBoolean("cloneSupport", false)) : Boolean.FALSE, true);
        stringValue = resource.getString("pubSubCleanup", "SAFE");
        this.setProperty(jmsProps, "CL", stringValue, true);
        this.setProperty(jmsProps, "CLINT", resource.isSet("pubSubCleanupInterval") ? new Long(resource.getLong("pubSubCleanupInterval", 3600000L)) : null, true);
        stringValue = resource.getString("directAuth", "BASIC");
        this.setProperty(jmsProps, "DAUTH", stringValue, true);
        this.setProperty(jmsProps, "FIQ", resource.isSet("failIfQuiesce") ? new Boolean(resource.getBoolean("failIfQuiesce", true)) : null, true);
        stringValue = resource.getString("msgSelection", "BROKER");
        this.setProperty(jmsProps, "MSEL", stringValue, true);
        stringValue = resource.getString("multicast", "DISABLED");
        this.setProperty(jmsProps, "MCAST", stringValue, true);
        this.setProperty(jmsProps, "PINT", resource.isSet("pollingInterval") ? new Integer(resource.getInt("pollingInterval", 5000)) : null, true);
        this.setProperty(jmsProps, "PHOST", resource.getString("proxyHostName", "__null__"), true);
        this.setProperty(jmsProps, "PPORT", resource.isSet("proxyPort") ? new Integer(resource.getInt("proxyPort", 0)) : null, true);
        this.setProperty(jmsProps, "PAI", resource.isSet("publishAckInterval") ? new Integer(resource.getInt("publishAckInterval", 25)) : null, true);
        this.setProperty(jmsProps, "RINT", resource.isSet("rescanInterval") ? new Integer(resource.getInt("rescanInterval", 5000)) : null, true);
        this.setProperty(jmsProps, "SSUBS", resource.isSet("sparseSubscriptions") ? new Boolean(resource.getBoolean("sparseSubscriptions", false)) : null, true);
        this.setProperty(jmsProps, "SRI", resource.isSet("statRefreshInterval") ? new Integer(resource.getInt("statRefreshInterval", 60000)) : null, true);
        stringValue = resource.getString("substore", "MIGRATE");
        this.setProperty(jmsProps, "SS", stringValue, true);
        this.setProperty(jmsProps, "TQP", resource.getString("tempQueuePrefix", "__null__"), true);
        this.setProperty(jmsProps, "UCP", resource.isSet("useConnectionPooling") ? new Boolean(resource.getBoolean("useConnectionPooling", true)) : null, true);
        stringValue = resource.getString("compressHeaders", "NONE");
        this.setProperty(jmsProps, "HC", stringValue, true);
        stringValue = resource.getString("compressPayload", "NONE");
        this.setProperty(jmsProps, "MC", stringValue, true);
        stringValue = resource.getString("providerVersion", "__null__");
        if (stringValue == null || stringValue.trim().length() == 0) {
            stringValue = "UNSPECIFIED";
        }
        this.setProperty(jmsProps, "PVER", stringValue, true);
        stringValue = resource.getString("wildcardFormat", null);
        if (stringValue != null) {
            if (stringValue.equals("characterWildcards")) {
                this.setProperty(jmsProps, "WCFMT", "CHAR_ONLY", true);
            } else if (stringValue.equals("topicWildcards")) {
                this.setProperty(jmsProps, "WCFMT", "TOPIC_ONLY", true);
            } else {
                throw new IllegalStateException(stringValue);
            }
        }
        if (this.checkMapNameStyleCompatiability()) {
            this.setProperty(jmsProps, "MAPNAMESTYLE", "COMPATIBLE", true);
        }
        stringValue = resource.getString("tempTopicPrefix", "__null__");
        this.setProperty(jmsProps, "TTP", stringValue, true);
        stringValue = resource.getString("replyWithRFH2", "AS_REPLY_DEST");
        if (stringValue.equals("ALWAYS")) {
            stringValue = "NO";
        } else if (stringValue.equals("AS_REPLY_DEST")) {
            stringValue = "YES";
        } else {
            throw new IllegalStateException(stringValue);
        }
        this.setProperty(jmsProps, "TCM", stringValue, true);
        this.setProperty(jmsProps, "MBS", resource.isSet("maxBatchSize") ? new Integer(resource.getInt("maxBatchSize", 10)) : null, true);
        this.setAuthenticationProperties(resource, jmsProps);
        Properties connectionPoolProperties = new Properties();
        stringValue = resource.getString("xaRecoveryAuthAlias", "__null__");
        this.setProperty(connectionPoolProperties, "XA_RECOVERY_AUTH_ALIAS", stringValue, true);
        this.addConnectionPoolProperties(connectionPoolProperties, connectionPool);
        this.addJ2EEHrefProperties(connectionPoolProperties, resource);
        Properties sessionPoolProperties = new Properties();
        this.addConnectionPoolProperties(sessionPoolProperties, sessionPool);
        this.addCustomPropertySet(jmsProps, resource.getObject("propertySet"));
        JMSResourceRefBuilder refBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable ref = null;
        try {
            ref = refBuilder.createMQConnectionFactoryReferenceable(jmsProps, connectionPoolProperties, sessionPoolProperties);
        }
        catch (ResourceBindingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.MQConnectionFactoryBinder.getBindingObject", "131", this);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.runtime.component.binder.MQConnectionFactoryBinder.getBindingObject", "136", this);
            throw new ResourceBindingException(t.toString());
        }
        return ref;
    }

    private void setNonBindingsModeProperties(Properties jmsProps, ConfigObject resource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setNonBindingsModeProperties", new Object[]{jmsProps, resource});
        }
        this.setProperty(jmsProps, "HOST", resource.getString("host", "__null__"), true);
        this.setProperty(jmsProps, "PORT", resource.isSet("port") ? Integer.valueOf(resource.getInt("port", 0)) : null, true);
        this.setProperty(jmsProps, "CHAN", resource.getString("channel", "__null__"), true);
        this.setProperty(jmsProps, "CCS", resource.getString("CCSID", "__null__"), true);
        this.setProperty(jmsProps, "LA", resource.getString("localAddress", "__null__"), true);
        this.setProperty(jmsProps, "SRC", resource.isSet("sslResetCount") ? Integer.valueOf(resource.getInt("sslResetCount", 0)) : null, true);
        this.setProperty(jmsProps, "CCDT", resource.getString("ccdtUrl", "__null__"), true);
        this.setProperty(jmsProps, "SCPHS", resource.getString("sslCipherSuite", "__null__"), true);
        this.setProperty(jmsProps, "SCRL", resource.getString("sslCRL", "__null__"), true);
        this.setProperty(jmsProps, "SPEER", resource.getString("sslPeerName", "__null__"), true);
        this.setProperty(jmsProps, "SCX", resource.getString("secExit", "__null__"), true);
        this.setProperty(jmsProps, "SCXI", resource.getString("secExitInitData", "__null__"), true);
        this.setProperty(jmsProps, "RCX", resource.getString("rcvExit", "__null__"), true);
        this.setProperty(jmsProps, "RCXI", resource.getString("rcvExitInitData", "__null__"), true);
        this.setProperty(jmsProps, "SDX", resource.getString("sendExit", "__null__"), true);
        this.setProperty(jmsProps, "SDXI", resource.getString("sendExitInitData", "__null__"), true);
        if (jmsProps.containsKey("CCDT")) {
            String sslConfigurationValue = resource.getString("sslConfiguration", "__null__");
            if (sslConfigurationValue == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null ssl configuration assuming central");
                }
                this.setProperty(jmsProps, "sslType", "CENTRAL", true);
            } else {
                this.setProperty(jmsProps, "sslType", "SPECIFIC", true);
                this.setProperty(jmsProps, "sslConfiguration", sslConfigurationValue, true);
            }
        } else {
            String sslTypeValue = resource.getString("sslType", "NONE");
            if (sslTypeValue.equals("CENTRAL")) {
                this.setProperty(jmsProps, "sslType", "CENTRAL", true);
            } else if (sslTypeValue.equals("SPECIFIC")) {
                String sslConfigurationValue = resource.getString("sslConfiguration", "__null__");
                this.setProperty(jmsProps, "sslType", "SPECIFIC", true);
                this.setProperty(jmsProps, "sslConfiguration", sslConfigurationValue, true);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setNonBindingsModeProperties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addCustomPropertySet(Properties jmsProps, ConfigObject customProps) throws ResourceBindingException {
        HashSet<String> unknownCustomPropertiesSet;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addCustomPropertySet", new Object[]{jmsProps, customProps});
            }
            unknownCustomPropertiesSet = new HashSet<String>();
            if (jmsProps != null && customProps != null) break block12;
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
            return;
        }
        try {
            List propertyList = customProps.getObjectList("resourceProperties");
            for (int i = 0; i < propertyList.size(); ++i) {
                ConfigObject property = (ConfigObject)propertyList.get(i);
                if (property == null) continue;
                String name2 = property.getString("name", "__null__");
                String value2 = property.getString("value", "__null__");
                try {
                    value2 = this.expandVariable(value2);
                }
                catch (IllegalArgumentException e) {
                    throw new ResourceBindingException("Illegal value '" + value2 + "' for Custom Property '" + name2 + "'");
                }
                if (name2 == null) {
                    throw new ResourceBindingException("Illegal Custom Property name " + name2);
                }
                if (value2 == null) {
                    throw new ResourceBindingException("Illegal Custom Property value " + value2);
                }
                if (name2.equalsIgnoreCase("ssl.repertoire")) {
                    this.setProperty(jmsProps, "ssl.repertoire", value2, true);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding unknown custom property <" + name2 + "=" + value2 + ">");
                }
                if (unknownCustomPropertiesSet.contains(name2.toUpperCase())) {
                    throw new ResourceBindingException("Custom Property '" + name2.toUpperCase() + "' already set");
                }
                this.setProperty(jmsProps, name2, value2, true);
                unknownCustomPropertiesSet.add(name2.toUpperCase());
            }
            if (!tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
            throw throwable;
        }
        Tr.exit(tc, "addCustomPropertySet", new Object[]{jmsProps});
    }
}

