/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.jms.JMSResourceRefBuilder;
import com.ibm.ejs.jms.JMSResourceRefBuilderFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.binder.JMSBinder;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.Properties;
import javax.naming.Referenceable;

public class GenericJMSConnectionFactoryBinder
extends JMSBinder {
    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.xmi", "GenericJMSConnectionFactory");
    }

    public Object getBindingObject(ConfigObject connectionFactory) throws ResourceBindingException {
        ConfigObject provider = connectionFactory.getParent();
        String genericJMSConnectionFactoryName = connectionFactory.getString("GenericJMSConnectionFactory", "__null__");
        String externalInitialContextFactory = provider.getString("externalInitialContextFactory", "__null__");
        this.checkRequiredProperty(genericJMSConnectionFactoryName, "externalInitialContextFactory", externalInitialContextFactory);
        String externalProviderURL = provider.getString("externalProviderURL", "__null__");
        this.checkRequiredProperty(genericJMSConnectionFactoryName, "externalProviderURL", externalProviderURL);
        String externalJNDIName = connectionFactory.getString("externalJNDIName", "__null__");
        this.checkRequiredProperty(genericJMSConnectionFactoryName, "externalJNDIName", externalJNDIName);
        boolean supportsASF = provider.getBoolean("supportsASF", true);
        Properties customProperties = new Properties();
        this.addPropertySet(customProperties, provider.getObject("propertySet"), true);
        this.addPropertySet(customProperties, connectionFactory.getObject("propertySet"), true);
        ConfigObject connectionPool = connectionFactory.getObject("connectionPool");
        this.checkRequiredProperty(genericJMSConnectionFactoryName, "ConnectionPool", connectionPool);
        ConfigObject sessionPool = connectionFactory.getObject("sessionPool");
        Properties properties = new Properties();
        this.addPropertySet(properties, connectionFactory.getObject("propertySet"), true);
        this.setProperty(properties, "NAME", genericJMSConnectionFactoryName, true);
        this.setProperty(properties, "ContextFactoryClassname", externalInitialContextFactory, true);
        this.setProperty(properties, "ProviderURL", externalProviderURL, true);
        this.setProperty(properties, "JNDIPath", externalJNDIName, true);
        this.setProperty(properties, "supportsASF", new Boolean(supportsASF), true);
        this.setAuthenticationProperties(connectionFactory, properties);
        Properties connectionPoolProperties = new Properties();
        this.addConnectionPoolProperties(connectionPoolProperties, connectionPool);
        this.addJ2EEHrefProperties(connectionPoolProperties, connectionFactory);
        Properties sessionPoolProperties = new Properties();
        this.addConnectionPoolProperties(sessionPoolProperties, sessionPool);
        JMSResourceRefBuilder refBuilder = JMSResourceRefBuilderFactory.createJMSResourceRefBuilder();
        Referenceable ref = null;
        try {
            String type = connectionFactory.getString("type", "QUEUE");
            if (type.equals("QUEUE")) {
                ref = refBuilder.createGenericQueueConnectionFactoryReferenceable(properties, connectionPoolProperties, sessionPoolProperties, customProperties);
            } else if (type.equals("TOPIC")) {
                ref = refBuilder.createGenericTopicConnectionFactoryReferenceable(properties, connectionPoolProperties, sessionPoolProperties, customProperties);
            } else if (type.equals("UNIFIED")) {
                ref = refBuilder.createGenericConnectionFactoryReferenceable(properties, connectionPoolProperties, sessionPoolProperties, customProperties);
            }
        }
        catch (ResourceBindingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.component.binder.GenericJMSConnectionFactoryBinder.getBindingObject", "110", this);
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.runtime.component.binder.GenericJMSConnectionFactoryBinder.getBindingObject", "115", this);
            throw new ResourceBindingException(t.toString());
        }
        return ref;
    }
}

