/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orb.transport;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionDataCarrier;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orb.transport.IIOPEndpointProfile;
import com.ibm.ws.orb.transport.ServerConnectionData;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.orbimpl.transport.DefaultConnectionDataImpl;
import com.ibm.ws.orbimpl.transport.DefaultServerConnectionDataImpl;
import com.ibm.ws.security.orbssl.SSLConnectionData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.INTERNAL;

public abstract class ConnectionInterceptor {
    private static final String SCCSID = " @(#) 1.12 SERV1/ws/code/orbext/src/com/ibm/ws/orb/transport/ConnectionInterceptor.java, WAS.orbext, WAS70.SERV1, cf050925.09 4/26/06 14:18:35 [6/25/09 07:40:59]";
    private static final String IIOP_OUTBOUND_CHAIN_ROOT = "IIOP_OUT_";
    private static final String IIOP_SECURE_OUTBOUND_CHAIN_ROOT = "IIOP_SECURE_OUT_";
    protected ORB theOrb;

    public void init(ORB orb) {
        this.theOrb = orb;
    }

    public String getChainName(ORB orb, long connectionType) {
        if (connectionType == 1L) {
            return IIOP_SECURE_OUTBOUND_CHAIN_ROOT + orb.getORBId();
        }
        return IIOP_OUTBOUND_CHAIN_ROOT + orb.getORBId();
    }

    public IIOPEndpointProfile[] getIIOPEndpointProfiles(IOR ior, String class_name, String method_name) {
        ConnectionDataCarrier connDataCarrier;
        if (ior == null) {
            return null;
        }
        Profile p = ior.getProfile();
        boolean valid = this.getConnectionKey(p, 0, ior, class_name, method_name, connDataCarrier = new ConnectionDataCarrier());
        if (valid) {
            ConnectionData cd = connDataCarrier.getConnectionData();
            String chainName = this.getChainName(this.theOrb, 2L);
            IIOPEndpointProfile iiopepp = new IIOPEndpointProfile(ior, chainName, cd);
            return new IIOPEndpointProfile[]{iiopepp};
        }
        return null;
    }

    public Object getServerConnectionData(GIOPConnectionContext ctx) {
        VirtualConnection vc = null;
        Map stateMap = null;
        ConnectionInformation ci = null;
        vc = ctx.getVirtualConnection();
        if (vc != null && (stateMap = vc.getStateMap()) != null) {
            ci = (ConnectionInformation)stateMap.get("DefaultConnectionInfo");
        }
        if (ci == null) {
            DefaultServerConnectionDataImpl scd = new DefaultServerConnectionDataImpl();
            scd.setLocalHost(ctx.getLocalHost());
            scd.setLocalPort(ctx.getLocalPort());
            String remoteHost = ctx.getRemoteHost();
            int remotePort = ctx.getRemotePort();
            scd.setRemoteHost(remoteHost);
            scd.setRemotePort(remotePort);
            scd.setConnectionHandle(ConnectionHandle.getConnectionHandle((VirtualConnection)vc));
            ci = new ConnectionInformationImpl(scd, null, System.currentTimeMillis(), remoteHost, remotePort);
            if (stateMap != null) {
                stateMap.put("DefaultConnectionInfo", ci);
            }
        }
        return ci;
    }

    public byte[] getClientConnectionInfo(Object connectionInfo) {
        ConnectionData cd;
        byte[] data_bytes = null;
        ConnectionInformation info = (ConnectionInformation)connectionInfo;
        if (info != null && (cd = (ConnectionData)info.getConnectionData()) != null) {
            String key = cd.getConnectionKey();
            data_bytes = key.getBytes();
        }
        return data_bytes;
    }

    public Object getClientConnectionInfo(byte[] data_bytes) {
        ConnectionInformationImpl info = null;
        String key = null;
        boolean remotePort = false;
        Object remoteHost = null;
        DefaultConnectionDataImpl cd = null;
        try {
            key = new String(data_bytes);
            cd = new DefaultConnectionDataImpl();
            cd.setConnectionKey(key);
            info = new ConnectionInformationImpl(cd, null, System.currentTimeMillis(), null, 0);
        }
        catch (Exception e) {
            throw new INTERNAL("Could not initialize client connection data");
        }
        return info;
    }

    public abstract boolean getConnectionKey(Profile var1, int var2, IOR var3, String var4, String var5, ConnectionDataCarrier var6);

    public abstract ServerConnectionData[] getServerConnectionData(ORB var1);

    public abstract void notifyBrokenConnection(ConnectionInformation var1);

    public abstract SSLConnectionData getSSLConfigurationParameters(String var1, long var2, short var4, int var5);

    public void notifyChainInitializationComplete(ChannelFramework cfw, ORB orb, List secureChains, List insecureChains) {
    }
}

