/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orb.transport;

import com.ibm.ws.orb.transport.ConnectionData;
import java.util.Arrays;

public class BaseConnectionDataImpl
implements ConnectionData {
    protected String connection_key = null;
    protected long connection_type = 0L;
    protected int localPort = 0;
    protected int remotePort = 0;
    protected String localHost = null;
    protected String remoteHost = null;
    protected Object connection_handle = null;
    protected byte[] altConnData = null;

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BaseConnectionDataImpl)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        BaseConnectionDataImpl that = (BaseConnectionDataImpl)o;
        if (this.connection_type != that.connection_type) {
            return false;
        }
        if (this.connection_type == 4L) {
            byte[] thisData = this.altConnData;
            byte[] thatData = that.altConnData;
            if (thisData == null && thatData != null || thisData != null && thatData == null || thisData != null && thatData != null && !Arrays.equals(thisData, thatData)) {
                return false;
            }
        } else {
            String thisKey = this.connection_key;
            String thatKey = that.connection_key;
            if (thisKey == null && thatKey != null || thisKey != null && thatKey == null || thisKey != null && thatKey != null && !thisKey.equals(thatKey)) {
                return false;
            }
        }
        return true;
    }

    public void setConnectionKey(String connKey) {
        this.connection_key = connKey;
    }

    public String getConnectionKey() {
        return this.connection_key;
    }

    public void setConnectionType(long connType) {
        if (connType >= 1L && connType <= 4L) {
            this.connection_type = connType;
        }
    }

    public long getConnectionType() {
        return this.connection_type;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int port2) {
        this.localPort = port2;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String host) {
        this.localHost = host;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int port2) {
        this.remotePort = port2;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public byte[] getAltConnectionData() {
        return this.altConnData;
    }

    public void setAltConnectionData(byte[] data) {
        this.altConnData = data;
        if (this.connection_type == 4L) {
            if (this.remoteHost == null) {
                this.remoteHost = "other:" + (this.altConnData == null ? "noData" : this.altConnData + ":" + this.altConnData.length);
            }
            if (this.connection_key == null) {
                this.connection_key = "other:" + (this.altConnData == null ? "noData" : this.altConnData + ":" + this.altConnData.length);
            }
        }
    }

    public Object getConnectionHandle() {
        return this.connection_handle;
    }

    public void setConnectionHandle(Object handle) {
        this.connection_handle = handle;
    }

    public String toString() {
        String keyString = this.connection_key;
        if (this.connection_type == 4L && keyString == null) {
            keyString = "other:" + (this.altConnData == null ? "noData" : this.altConnData + ":" + this.altConnData.length);
        }
        String stringType = "";
        long type = this.getConnectionType();
        switch ((int)type) {
            case 1: {
                stringType = "SSL";
                break;
            }
            case 2: {
                stringType = "TCPIP";
                break;
            }
            case 3: {
                stringType = "LOCAL";
                break;
            }
            case 4: {
                stringType = "OTHER";
                break;
            }
            default: {
                stringType = "UNKnown " + type;
            }
        }
        return "ConnectionData[@" + this.hashCode() + ",type=" + stringType + ",key=" + keyString + "]";
    }

    protected void setHostPortFromKeyString(String keyString) {
        if (this.connection_type == 4L || this.connection_key == null) {
            return;
        }
        if (keyString.indexOf("IIOPSSL") != -1) {
            int lastColon = keyString.lastIndexOf(":");
            keyString = keyString.substring(0, lastColon);
            lastColon = keyString.lastIndexOf(":");
            keyString = keyString.substring(0, lastColon);
            lastColon = keyString.lastIndexOf(":");
            String port2 = keyString.substring(lastColon + 1);
            this.remotePort = Integer.parseInt(port2);
            this.remoteHost = keyString = keyString.substring(0, lastColon);
        } else {
            int lastColon = keyString.lastIndexOf(":");
            String port3 = keyString.substring(lastColon + 1);
            this.remotePort = Integer.parseInt(port3);
            this.remoteHost = keyString = keyString.substring(0, lastColon);
        }
    }
}

