/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

class AppInfo {
    private static TraceComponent tc = Tr.register(AppInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    String name = null;
    String earName = null;
    boolean distribute = true;
    String deploymentURI = null;
    DocumentDigest prevDigest = null;
    ConfigRepository repository = null;

    AppInfo(String cellName, String appName) {
        this.name = appName;
        this.deploymentURI = "cells/" + cellName + "/applications/" + appName + "/deployment.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void update() {
        block18: {
            ApplicationDeployment d;
            InputStream in;
            block17: {
                DocumentDigest currentDigest;
                in = null;
                d = null;
                if (this.repository == null) {
                    this.repository = ConfigRepositoryFactory.getConfigRepository();
                }
                if (!((Object)(currentDigest = this.repository.getDigest(this.deploymentURI))).equals(this.prevDigest)) {
                    DocumentContentSource dcs = this.repository.extract(this.deploymentURI);
                    in = dcs.getSource();
                    d = this.loadDeployment(in);
                    this.earName = ConfigStructureHelper.getEarName(d.getBinariesURL());
                    this.distribute = d.isEnableDistribution();
                    this.prevDigest = dcs.getDocument().getDigest();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.deploymentURI);
                        Tr.debug(tc, "EAR name is " + this.earName);
                        Tr.debug(tc, "distribution is " + this.distribute);
                    }
                }
                if (d == null) break block17;
                Resource res = d.eResource();
                ResourceSet set = res.getResourceSet();
                EList l = set.getResources();
                l.remove(res);
            }
            try {
                if (in != null) {
                    in.close();
                }
                break block18;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.management.repository.AppInfo.loadDeployment", "101", this);
            }
            break block18;
            catch (Exception e) {
                block19: {
                    try {
                        Manager.Ffdc.log(e, this, "com.ibm.ws.management.repository.AppInfo.loadDeployment", "88", this);
                        if (d == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (d != null) {
                            Resource res = d.eResource();
                            ResourceSet set = res.getResourceSet();
                            EList l = set.getResources();
                            l.remove(res);
                        }
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception e2) {
                            Manager.Ffdc.log(e2, this, "com.ibm.ws.management.repository.AppInfo.loadDeployment", "101", this);
                        }
                        throw throwable;
                    }
                    Resource res = d.eResource();
                    ResourceSet set = res.getResourceSet();
                    EList l = set.getResources();
                    l.remove(res);
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e3) {
                    Manager.Ffdc.log(e3, this, "com.ibm.ws.management.repository.AppInfo.loadDeployment", "101", this);
                }
            }
        }
    }

    private ApplicationDeployment loadDeployment(InputStream in) {
        ApplicationDeployment appDeployment = null;
        try {
            WASResourceSetImpl resourceSet = new WASResourceSetImpl();
            URI uri = URI.createURI("deployment.xml");
            Resource resource = resourceSet.createResource(uri);
            HashMap options = new HashMap();
            resource.load(in, options);
            Deployment deployment = (Deployment)resource.getContents().get(0);
            if (deployment == null) {
                throw new AdminException("Unable to load deployment document");
            }
            appDeployment = (ApplicationDeployment)deployment.getDeployedObject();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.management.repository.AppInfo.loadDeployment", "119", this);
        }
        return appDeployment;
    }

    public boolean getDistribute() {
        return this.distribute;
    }

    public String getEarName() {
        return this.earName;
    }

    public String getName() {
        return this.name;
    }
}

