/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManager;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class ManagedObjectMetadataCollectorManagerFactory {
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataCollectorManagerFactory.class, "Admin", null);
    private static final String COLLECTOR_IMPL_CLASS_NAME = "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl";

    public static ManagedObjectMetadataCollectorManager createCollectorManager(Properties props, AdminClient adminClient) throws AdminException {
        return ManagedObjectMetadataCollectorManagerFactory.createCollectorManagerInstance(props, adminClient);
    }

    public static ManagedObjectMetadataCollectorManager createCollectorManager(Properties props) throws AdminException {
        return ManagedObjectMetadataCollectorManagerFactory.createCollectorManagerInstance(props, null);
    }

    private static ManagedObjectMetadataCollectorManager createCollectorManagerInstance(Properties props, AdminClient adminClient) throws AdminException {
        props = ManagedObjectMetadataCollectorManagerFactory.validateProperties(props);
        try {
            Class<?> collectorMgrClass = Class.forName(COLLECTOR_IMPL_CLASS_NAME);
            Constructor<?> collectorMgrCtor = collectorMgrClass.getConstructor(Properties.class, AdminClient.class);
            ManagedObjectMetadataCollectorManager collectorMgrInst = (ManagedObjectMetadataCollectorManager)collectorMgrCtor.newInstance(props, adminClient);
            return collectorMgrInst;
        }
        catch (Exception e) {
            throw new AdminException(e, "Encountered an error while attempting to create a ManagedObjectMetadataCollector instance.");
        }
    }

    private static Properties validateProperties(Properties props) throws AdminException {
        IllegalArgumentException badArgException = null;
        props = props == null ? new Properties() : (Properties)props.clone();
        AdminService adminService = AdminServiceFactory.getAdminService();
        String prop = props.getProperty("was.repository.root");
        if (prop == null || prop.length() == 0) {
            prop = System.getProperty("was.repository.root");
            if (prop == null || prop.length() == 0) {
                if (adminService == null) {
                    badArgException = new IllegalArgumentException("The property \"was.repository.root\" setting does not exist in the set of input properties or system properties or has a zero-length value.");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "validateProperties: Using repository root from sys props: " + prop);
                }
                props.setProperty("was.repository.root", prop);
            }
        }
        if ((prop = props.getProperty("local.cell")) == null || prop.length() == 0) {
            prop = System.getProperty("local.cell");
            if (prop == null || prop.length() == 0) {
                if (adminService != null) {
                    prop = adminService.getCellName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using cell name from AdminService: " + prop);
                    }
                    props.setProperty("local.cell", prop);
                } else {
                    badArgException = new IllegalArgumentException("The property \"local.cell\" setting does not exist in the set of input properties and a value for \"local.cell\" could not be found in the system properties.");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using cell name from sys props: " + prop);
                }
                props.setProperty("local.cell", prop);
            }
        }
        if ((prop = props.getProperty("local.node")) == null || prop.length() == 0) {
            prop = System.getProperty("local.node");
            if (prop == null || prop.length() == 0) {
                if (adminService != null) {
                    prop = adminService.getNodeName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using node name from AdminService: " + prop);
                    }
                    props.setProperty("local.node", prop);
                } else {
                    badArgException = new IllegalArgumentException("The property \"local.node\" setting does not exist in the set of input properties and a value for \"local.node\" could not be found in the system properties.");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using cell name from sys props: " + prop);
                }
                props.setProperty("local.node", prop);
            }
        }
        if ((prop = props.getProperty("was.install.root")) == null || prop.length() == 0) {
            prop = System.getProperty("was.install.root");
            if (prop == null || prop.length() == 0) {
                badArgException = new IllegalArgumentException("The property \"was.install.root\" setting does not exist in the set of input properties and a value for \"was.install.root\" could not be found in the system properties.");
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using was.install.root from sys props: " + prop);
                }
                props.setProperty("was.install.root", prop);
            }
        }
        if (badArgException != null) {
            throw new AdminException(badArgException, "Invalid input.  See nested exception for more information.");
        }
        return props;
    }
}

