/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commanddata.TaskCommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.exception.SessionTimeoutException;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandSecurityUtil;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.EObjectSerializer;
import com.ibm.ws.management.cmdframework.impl.RemoteCommandMgr;
import com.ibm.ws.management.cmdframework.impl.ServerCommandMgr;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSession;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSessionMgr;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import javax.management.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RemoteCommandMgrImpl
extends RuntimeCollaborator
implements RemoteCommandMgr {
    private static TraceComponent tc = Tr.register(RemoteCommandMgrImpl.class, "RemoteCommandMgrImpl", "com.ibm.ws.management.cmdframework.impl");
    private static transient TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.cmdframework");
    private CommandMgr cmdMgr;
    private static long messageId = 0L;

    public RemoteCommandMgrImpl() throws Exception {
        this.initialize();
    }

    private void initialize() throws Exception {
        this.cmdMgr = CommandMgr.getCommandMgr();
    }

    public ArrayList listCommandGroups() {
        return new ArrayList(CommandMetadataMgr.getInstance().listCommandGroups());
    }

    public ArrayList listAllCommands() {
        return new ArrayList(CommandMetadataMgr.getInstance().listAllCommands());
    }

    public ArrayList listCommands(String commandGroup) {
        return new ArrayList(CommandMetadataMgr.getInstance().listCommands(commandGroup));
    }

    public ArrayList listCommands() {
        return new ArrayList(CommandMetadataMgr.getInstance().listCommands());
    }

    private void mergeCommandStepData(AbstractTaskCommand serverTaskCommand, TaskCommandData clientCmdData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeCommandStepData, serverTaskCmd: " + serverTaskCommand.getName() + ", clientCmdData: " + clientCmdData);
        }
        EList stepDataList = clientCmdData.getSteps();
        for (CommandStepData stepData : stepDataList) {
            String stepName = stepData.getName();
            EList params = stepData.getCmdParams();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stepName: (" + (stepData.isEnabled() ? "T) " : "F) ") + stepName + ", Parameters are " + params);
            }
            CommandStep step = null;
            try {
                step = serverTaskCommand.getCommandStep(stepName);
            }
            catch (CommandNotFoundException cnfe) {
                Tr.debug(tc, "Cought unexpected CommandNotFoundException on stepName while getting the step: " + stepName);
                continue;
            }
            EObject paramData = null;
            for (int i = 0; i < params.size(); ++i) {
                paramData = (EObject)params.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "paramData name is " + paramData);
                }
                EClass metaObj = paramData.eClass();
                for (EStructuralFeature feature : metaObj.getEAllAttributes()) {
                    String value2;
                    if (!paramData.eIsSet(feature)) continue;
                    String paramName = feature.getName();
                    Object paramValue = paramData.eGet(feature);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setted feature name.: " + paramName);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setted feature value: " + paramValue);
                    }
                    if ((value2 = (String)paramValue) == null || value2.equals("")) continue;
                    try {
                        if (step != null && ((CommandStepMetadata)step.getCommandMetadata()).isTable()) {
                            serverTaskCommand.getCommandStep(stepName).setParameter(paramName, paramValue, i);
                            continue;
                        }
                        serverTaskCommand.getCommandStep(stepName).setParameter(paramName, paramValue);
                    }
                    catch (CommandNotFoundException cnfe) {
                        Tr.debug(tc, "Cought unexpected CommandNotFoundException on stepName: " + stepName);
                    }
                    catch (InvalidParameterNameException ipne) {
                        Tr.debug(tc, "Cought unexpected InvalidParameterNameException on feature: " + paramName + ", value: " + paramValue);
                    }
                    catch (InvalidParameterValueException ipve) {
                        Tr.debug(tc, "Cought InvalidParameterValueException on feature: " + paramName + ", value: " + paramValue);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeCommandStepData, serverTaskCmd: " + serverTaskCommand.getName());
        }
    }

    public ArrayList listCommandStepsWithData(TaskCommandSession session, EObjectSerializer cmdDataEObj) {
        TaskCommandMetadata cmdMetadata;
        TaskCommandData cmdData;
        ArrayList<EObjectSerializer> returnData;
        block13: {
            AbstractTaskCommand serverTaskCommand;
            block12: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "listCommandStepsWithData, session: " + session, "cmdDataEObj: " + cmdDataEObj);
                }
                returnData = new ArrayList<EObjectSerializer>(2);
                returnData.add(0, null);
                returnData.add(1, null);
                try {
                    TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)this.cmdMgr).getTaskCommandSessionMgr();
                    serverTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
                }
                catch (SessionTimeoutException ste) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught, return empty step.", ste);
                    }
                    return returnData;
                }
                try {
                    TaskCommandData clientCmdData = (TaskCommandData)cmdDataEObj.getEObjectValue();
                    this.mergeCommandStepData(serverTaskCommand, clientCmdData);
                }
                catch (IOException ioe) {
                    Manager.Ffdc.log(ioe, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "140", this);
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Exception caught, cannot get command data.", ioe);
                }
            }
            cmdData = serverTaskCommand.getTaskCommandData();
            cmdMetadata = serverTaskCommand.getTaskCommandMetadata();
            try {
                EObject serverCommandDataClone = CommandUtility.clone(cmdData);
                EObject serverCommandMetadataClone = CommandUtility.clone(cmdMetadata);
                try {
                    returnData.set(0, this.createEObjSerializer(serverCommandDataClone));
                    returnData.set(1, this.createEObjSerializer(serverCommandMetadataClone));
                }
                catch (IOException ioe) {
                    Manager.Ffdc.log(ioe, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "150", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IOException caught when creating createEObjSerializer, return null EObjectSerializer", ioe);
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "155", this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Exception caught when cloning, return null EObjectSerializer", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommandStepsWithData, session: " + session + "\n cmdData: " + cmdData + "\n cmdMetadata: " + cmdMetadata);
        }
        return returnData;
    }

    public TaskCommandSession getCmdSession(String commandName) throws CommandNotFoundException, CommandException {
        AbstractAdminCommand adminCmd;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCmdSession", commandName);
        }
        try {
            adminCmd = (AbstractAdminCommand)this.cmdMgr.createCommand(commandName);
        }
        catch (CommandNotFoundException cnfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to load command", cnfe);
            }
            throw new CommandNotFoundException(commandName);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Excepiton Caught", e);
            }
            throw new CommandException(e);
        }
        TaskCommandSession session = adminCmd.getCommandSession();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCmdSession", session);
        }
        return session;
    }

    public CommandResult executeAsync(TaskCommandSession session, EObjectSerializer command) throws CommandNotFoundException, CommandLoadException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeAsync", new Object[]{session, command});
        }
        CommandResult result = this.adminCmdExecute(session, command);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeAsync");
        }
        return result;
    }

    public CommandResult execute(EObjectSerializer command) throws CommandNotFoundException, CommandLoadException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", command);
        }
        CommandResult result = this.adminCmdExecute(null, command);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", new Boolean(result.isSuccessful()).toString());
        }
        return result;
    }

    private CommandResult adminCmdExecute(TaskCommandSession session, EObjectSerializer command) throws CommandNotFoundException, CommandLoadException {
        AbstractAdminCommand clientCommand;
        CommandData cmdData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{session, command});
        }
        try {
            String commandName = command.getName();
            if (commandName != null && !commandName.equals("")) {
                EClass commandEClass = CommandMetadataMgr.getInstance().getParamDataEClass(commandName);
            }
            cmdData = (CommandData)command.getEObjectValue();
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", ioe);
            }
            throw new CommandLoadException(ioe);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command execute is " + cmdData.getName());
        }
        if (session != null) {
            TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)this.cmdMgr).getTaskCommandSessionMgr();
            try {
                clientCommand = (AbstractAdminCommand)sessionMgr.getAdminCommand(session);
            }
            catch (SessionTimeoutException ste) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "session timedout", ste);
                }
                throw new CommandLoadException(ste);
            }
            clientCommand.resetCommandData(cmdData);
        } else {
            CommandProvider cmdProvider = CommandMetadataMgr.getInstance().getCommandProvider(cmdData.getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Command provider is " + cmdProvider);
            }
            clientCommand = cmdProvider.loadCommand(cmdData);
        }
        clientCommand.execute();
        if (!clientCommand.isAsyncCommand()) {
            clientCommand.cleanupUploadedFiles();
        }
        CommandResult result = clientCommand.getCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
        return result;
    }

    public CommandResult execute(TaskCommandSession session, EObjectSerializer command) throws CommandNotFoundException, CommandLoadException {
        TaskCommandData newTaskCmdData;
        AbstractTaskCommand storedTaskCommand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", command);
        }
        TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)this.cmdMgr).getTaskCommandSessionMgr();
        try {
            storedTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
            newTaskCmdData = (TaskCommandData)command.getEObjectValue();
        }
        catch (Exception ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", ioe);
            }
            throw new CommandLoadException(ioe);
        }
        if (tc.isDebugEnabled()) {
            this.listAllStepParamsData(newTaskCmdData);
        }
        storedTaskCommand.resetCommandData(newTaskCmdData);
        storedTaskCommand.execute();
        if (!storedTaskCommand.isAsyncCommand()) {
            storedTaskCommand.cleanupUploadedFiles();
        }
        CommandResult result = storedTaskCommand.getCommandResult();
        sessionMgr.removeTaskCommand(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
        return result;
    }

    public ArrayList processTaskParameters(TaskCommandSession session, EObjectSerializer command) throws CommandNotFoundException, CommandLoadException {
        ArrayList<EObjectSerializer> arrayList;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processTaskParameters", command);
            }
            TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)this.cmdMgr).getTaskCommandSessionMgr();
            ArrayList<EObjectSerializer> returnData = new ArrayList<EObjectSerializer>(2);
            try {
                AbstractTaskCommand storedTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
                TaskCommandData newTaskCmdData = (TaskCommandData)command.getEObjectValue();
                CommandSecurityUtil cmdSecurityUtil = CommandSecurityUtil.getInstance();
                boolean accessGranted = cmdSecurityUtil.checkAccess(storedTaskCommand, "process task parameters");
                if (!accessGranted) {
                    String msg = nls.getFormattedMessage("ADMF0010E", new Object[]{storedTaskCommand.getName()}, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, msg);
                    }
                    throw new SecurityException(msg);
                }
                storedTaskCommand.resetCommandData(newTaskCmdData);
                storedTaskCommand.processTaskParameters();
                TaskCommandData processedTaskCmdData = storedTaskCommand.getTaskCommandData();
                TaskCommandMetadata processedTaskCmdMetaData = storedTaskCommand.getTaskCommandMetadata();
                if (tc.isDebugEnabled()) {
                    this.listAllStepParamsData(processedTaskCmdData);
                }
                returnData.add(0, this.createEObjSerializer(processedTaskCmdMetaData));
                returnData.add(1, this.createEObjSerializer(processedTaskCmdData));
                arrayList = returnData;
                Object var13_14 = null;
                if (!tc.isEntryEnabled()) break block9;
            }
            catch (Exception ioe) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught", ioe);
                    }
                    throw new CommandLoadException(ioe);
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var13_15 = null;
                        if (!tc.isEntryEnabled()) break block10;
                        Tr.exit(tc, "processTaskParameters");
                    }
                    throw throwable;
                }
            }
            Tr.exit(tc, "processTaskParameters");
        }
        return arrayList;
    }

    public void listAllStepParamsData(TaskCommandData cmdData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllStepParamsData", cmdData);
        }
        EList stepDataList = cmdData.getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "step data list is  ", stepDataList);
        }
        for (CommandStepData stepData : stepDataList) {
            String stepName = stepData.getName();
            EList params = stepData.getCmdParams();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stepName: (" + (stepData.isEnabled() ? "T) " : "F) ") + stepName + ", Parameters are " + params);
            }
            EObject paramData = null;
            for (int i = 0; i < params.size(); ++i) {
                paramData = (EObject)params.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "paramData name is " + paramData);
                }
                EClass metaObj = paramData.eClass();
                for (EStructuralFeature feature : metaObj.getEAllAttributes()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "feature", feature);
                    }
                    if (!paramData.eIsSet(feature)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setted feature is " + feature.getName());
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "setted feature value is " + paramData.eGet(feature));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllStepParamsData");
        }
    }

    public EObjectSerializer getCommandGroupMetaInfo(String commandGrpName, Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandGroupMetaInfo", commandGrpName);
        }
        try {
            CommandGroupMetadata cmdGrpMetadata = this.cmdMgr.getCommandGroupMetadata(commandGrpName);
            if (locale != null && !locale.equals(Locale.getDefault())) {
                CommandMetadataMgr.getInstance().translate(cmdGrpMetadata, null, locale);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandGroupMetaInfo");
            }
            return this.createEObjSerializer(cmdGrpMetadata);
        }
        catch (CommandNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "167", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught ", ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetaInfo");
            }
            CommandNotFoundException cnfe = new CommandNotFoundException(commandGrpName);
            cnfe.initCause(ex);
            throw cnfe;
        }
    }

    public Collection getAllCommandGrpMetaInfo(Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllCommandGrpMetaInfo", locale);
        }
        Collection cmdGrpList = CommandMetadataMgr.getInstance().listCommandGroups();
        Iterator cmdGrpListIterator = cmdGrpList.iterator();
        ArrayList<EObjectSerializer> cmdGrpMetadataList = new ArrayList<EObjectSerializer>();
        while (cmdGrpListIterator.hasNext()) {
            String commandGrpName = (String)cmdGrpListIterator.next();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command Group to lookup is " + commandGrpName);
                }
                CommandGroupMetadata cmdGrpMetadata = this.cmdMgr.getCommandGroupMetadata(commandGrpName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default Locale is " + Locale.getDefault());
                }
                if (locale != null && !locale.equals(Locale.getDefault())) {
                    CommandMetadataMgr.getInstance().translate(cmdGrpMetadata, null, locale);
                }
                cmdGrpMetadataList.add(this.createEObjSerializer(cmdGrpMetadata));
            }
            catch (CommandNotFoundException ce) {
                Manager.Ffdc.log(ce, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "CommandNotFoundException caught ", ce);
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception caught ", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllCommandGrpMetaInfo");
        }
        return cmdGrpMetadataList;
    }

    public EObjectSerializer getCommandMetaInfo(String commandName, Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetaInfo", new Object[]{commandName, locale});
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Command to lookup is " + commandName);
            }
            CommandMetadata cmdMetadata = this.cmdMgr.getCommandMetadata(commandName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Default Locale is " + Locale.getDefault());
            }
            if (locale != null && !locale.equals(Locale.getDefault())) {
                CommandMetadataMgr.getInstance().translate(cmdMetadata, null, locale);
            }
            EClass commandEClass = CommandMetadataMgr.getInstance().getParamDataEClass(commandName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetaInfo");
            }
            return this.createEObjSerializer(cmdMetadata);
        }
        catch (CommandNotFoundException ce) {
            Manager.Ffdc.log(ce, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CommandNotFoundException caught ", ce);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetaInfo");
            }
            throw ce;
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught ", ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetaInfo");
            }
            CommandNotFoundException cnfe = new CommandNotFoundException(commandName);
            cnfe.initCause(ex);
            throw cnfe;
        }
    }

    public Collection getAllCommandMetaInfo(Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandAllMetaInfo", locale);
        }
        Collection cmdList = CommandMetadataMgr.getInstance().listAllCommands();
        Iterator cmdListIterator = cmdList.iterator();
        ArrayList<EObjectSerializer> cmdMetadataList = new ArrayList<EObjectSerializer>();
        while (cmdListIterator.hasNext()) {
            String commandName = (String)cmdListIterator.next();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command to lookup is " + commandName);
                }
                CommandMetadata cmdMetadata = this.cmdMgr.getCommandMetadata(commandName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default Locale is " + Locale.getDefault());
                }
                if (locale != null && !locale.equals(Locale.getDefault())) {
                    CommandMetadataMgr.getInstance().translate(cmdMetadata, null, locale);
                }
                cmdMetadataList.add(this.createEObjSerializer(cmdMetadata));
            }
            catch (CommandNotFoundException ce) {
                Manager.Ffdc.log(ce, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "CommandNotFoundException caught ", ce);
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.management.cmdframework.RemoteCommandmgrImpl", "190", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception caught ", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllCommandMetaInfo");
        }
        return cmdMetadataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EObjectSerializer getCurrentStep(TaskCommandSession session, EObjectSerializer cliCmdStepDataEObj, Integer operation, String stepName) {
        EObjectSerializer serverCurrentStepDataClone2;
        block33: {
            TaskCommandData clientTaskCmdData;
            AbstractTaskCommand serverTaskCommand;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCurrentStep", session);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Client operation is " + operation);
            }
            int operationType = operation;
            try {
                TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)this.cmdMgr).getTaskCommandSessionMgr();
                serverTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
            }
            catch (SessionTimeoutException ste) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught, return empty EObjectSerializer", ste);
                }
                return new EObjectSerializer();
            }
            if (operationType == 3) {
                try {
                    clientTaskCmdData = (TaskCommandData)cliCmdStepDataEObj.getEObjectValue();
                    serverTaskCommand.resetCommandData(clientTaskCmdData);
                    AbstractCommandStep serverStep = (AbstractCommandStep)serverTaskCommand.getCommandStep(stepName);
                    EObject serverCurrentStepDataClone2 = CommandUtility.clone(serverStep.getCommandStepData());
                    try {
                        return this.createEObjSerializer(serverCurrentStepDataClone2);
                    }
                    catch (IOException ioe) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "IOException caught, return empty EObjectSerializer", ioe);
                        }
                        return new EObjectSerializer();
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught, return empty EObjectSerializer", e);
                    }
                    return new EObjectSerializer();
                }
            }
            if (serverTaskCommand.getCurrentStepIndex() != 0) {
                try {
                    CommandStepData clientCmdStepData = (CommandStepData)cliCmdStepDataEObj.getEObjectValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Client Current command step is " + clientCmdStepData.getName());
                    }
                    AbstractCommandStep serverStep = (AbstractCommandStep)serverTaskCommand.getCommandStep(clientCmdStepData.getName());
                    serverStep.resetCommandData(clientCmdStepData);
                    serverTaskCommand.setCurrentStep(serverStep);
                }
                catch (IOException ioe) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught, return empty EObjectSerializer", ioe);
                    }
                    return new EObjectSerializer();
                }
                catch (CommandNotFoundException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught, return empty EObjectSerializer", e);
                    }
                    return new EObjectSerializer();
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "First client command step.  Reset the commanddata from the task command");
                }
                clientTaskCmdData = (TaskCommandData)cliCmdStepDataEObj.getEObjectValue();
                serverTaskCommand.resetCommandData(clientTaskCmdData);
            }
            catch (IOException ioe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during resetting the client Task commanddata , return empty EObjectSerializer", ioe);
                }
                return new EObjectSerializer();
            }
            switch (operationType) {
                case 0: {
                    serverTaskCommand.nextStep();
                    break;
                }
                case 1: {
                    serverTaskCommand.previousStep();
                    break;
                }
                case 2: {
                    serverTaskCommand.gotoStep(stepName);
                }
            }
            AbstractCommandStep serverCurrentStep = (AbstractCommandStep)serverTaskCommand.getCurrentStep(operationType);
            EObject serverCurrentStepDataClone3 = CommandUtility.clone(serverCurrentStep.getCommandStepData());
            try {
                serverCurrentStepDataClone2 = this.createEObjSerializer(serverCurrentStepDataClone3);
                Object var12_20 = null;
                if (!tc.isEntryEnabled()) break block33;
            }
            catch (IOException ioe) {
                EObjectSerializer eObjectSerializer;
                block34: {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception caught, return empty EObjectSerializer", ioe);
                        }
                        eObjectSerializer = new EObjectSerializer();
                        Object var12_21 = null;
                        if (!tc.isEntryEnabled()) break block34;
                    }
                    catch (Throwable throwable) {
                        block35: {
                            Object var12_22 = null;
                            if (!tc.isEntryEnabled()) break block35;
                            Tr.exit(tc, "getCurrentStep", serverCurrentStep.getName());
                        }
                        throw throwable;
                    }
                    Tr.exit(tc, "getCurrentStep", serverCurrentStep.getName());
                }
                return eObjectSerializer;
            }
            Tr.exit(tc, "getCurrentStep", serverCurrentStep.getName());
        }
        return serverCurrentStepDataClone2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getCurrentStepInList(TaskCommandSession session, EObjectSerializer cliCmdStepDataEObj, Integer operation, String stepName) {
        TaskCommandData clientTaskCmdData;
        AbstractTaskCommand serverTaskCommand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentStepInList, operation: " + operation + ", stepName: " + stepName + ", cliCmdStepDataEObj: " + cliCmdStepDataEObj, session);
        }
        int operationType = operation;
        ArrayList<Serializable> returnData = new ArrayList<Serializable>(4);
        returnData.add(0, null);
        returnData.add(1, new EObjectSerializer());
        returnData.add(2, null);
        returnData.add(3, null);
        try {
            TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)this.cmdMgr).getTaskCommandSessionMgr();
            serverTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
        }
        catch (SessionTimeoutException ste) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught, return empty EObjectSerializer", ste);
            }
            return returnData;
        }
        if (operationType == 3) {
            try {
                clientTaskCmdData = (TaskCommandData)cliCmdStepDataEObj.getEObjectValue();
                serverTaskCommand.resetCommandData(clientTaskCmdData);
                AbstractCommandStep serverStep = (AbstractCommandStep)serverTaskCommand.getCommandStep(stepName);
                EObject serverCurrentStepDataClone = CommandUtility.clone(serverStep.getCommandStepData());
                EObject serverTaskCommandMetaDataClone = CommandUtility.clone(serverTaskCommand.getTaskCommandMetadata());
                EList stepDataList = serverTaskCommand.getTaskCommandData().getSteps();
                int returnedStepIndex = stepDataList.indexOf(serverStep.getCommandStepData());
                try {
                    try {
                        returnData.set(0, this.createEObjSerializer(serverTaskCommandMetaDataClone));
                        returnData.set(1, this.createEObjSerializer(serverCurrentStepDataClone));
                        ArrayList<Serializable> arrayList = returnData;
                        Object var17_27 = null;
                        returnData.set(2, new Integer(returnedStepIndex));
                    }
                    catch (IOException ioe) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "IOException caught, return empty EObjectSerializer", ioe);
                        }
                        ArrayList<Serializable> arrayList = returnData;
                        Object var17_28 = null;
                        returnData.set(2, new Integer(returnedStepIndex));
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getCurrentStepInList", new Object[]{serverStep.getName(), new Integer(returnedStepIndex)});
                        }
                        return returnData;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_29 = null;
                    returnData.set(2, new Integer(returnedStepIndex));
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCurrentStepInList", new Object[]{serverStep.getName(), new Integer(returnedStepIndex)});
                    }
                    return returnData;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCurrentStepInList", new Object[]{serverStep.getName(), new Integer(returnedStepIndex)});
                }
                return returnData;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught, return empty EObjectSerializer", e);
                }
                return returnData;
            }
        }
        if (serverTaskCommand.getCurrentStepIndex() != 0) {
            try {
                CommandStepData clientCmdStepData = (CommandStepData)cliCmdStepDataEObj.getEObjectValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client Current command step is " + clientCmdStepData.getName());
                }
                AbstractCommandStep serverStep = (AbstractCommandStep)serverTaskCommand.getCommandStep(clientCmdStepData.getName());
                serverStep.resetCommandData(clientCmdStepData);
                serverTaskCommand.setCurrentStep(serverStep);
            }
            catch (IOException ioe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught, return empty EObjectSerializer", ioe);
                }
                return returnData;
            }
            catch (CommandNotFoundException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught, return empty EObjectSerializer", e);
                }
                return returnData;
            }
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "First client command step.  Reset the commanddata from the task command");
            }
            clientTaskCmdData = (TaskCommandData)cliCmdStepDataEObj.getEObjectValue();
            serverTaskCommand.resetCommandData(clientTaskCmdData);
        }
        catch (IOException ioe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during resetting the client Task commanddata , return empty EObjectSerializer", ioe);
            }
            return returnData;
        }
        switch (operationType) {
            case 0: {
                serverTaskCommand.nextStep();
                break;
            }
            case 1: {
                serverTaskCommand.previousStep();
                break;
            }
            case 2: {
                serverTaskCommand.gotoStep(stepName);
                break;
            }
        }
        AbstractCommandStep serverCurrentStep = (AbstractCommandStep)serverTaskCommand.getCurrentStep(operationType);
        EObject serverCurrentStepDataClone = CommandUtility.clone(serverCurrentStep.getCommandStepData());
        EObject serverTaskCommandMetaDataClone = CommandUtility.clone(serverTaskCommand.getTaskCommandMetadata());
        EObject serverTaskCommandDataClone = CommandUtility.clone(serverTaskCommand.getTaskCommandData());
        EList stepDataList = serverTaskCommand.getTaskCommandData().getSteps();
        int returnedStepIndex = stepDataList.indexOf(serverCurrentStep.getCommandStepData());
        try {
            try {
                returnData.set(0, this.createEObjSerializer(serverTaskCommandMetaDataClone));
                returnData.set(1, this.createEObjSerializer(serverCurrentStepDataClone));
                returnData.set(3, this.createEObjSerializer(serverTaskCommandDataClone));
            }
            catch (IOException ioe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught, return empty EObjectSerializer", ioe);
                }
                returnData.set(1, new EObjectSerializer());
                Object var19_33 = null;
                returnData.set(2, new Integer(returnedStepIndex));
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCurrentStepInList", new Object[]{serverCurrentStep.getName(), new Integer(returnedStepIndex)});
                }
                return returnData;
            }
            Object var19_32 = null;
            returnData.set(2, new Integer(returnedStepIndex));
        }
        catch (Throwable throwable) {
            Object var19_34 = null;
            returnData.set(2, new Integer(returnedStepIndex));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCurrentStepInList", new Object[]{serverCurrentStep.getName(), new Integer(returnedStepIndex)});
            }
            return returnData;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentStepInList", new Object[]{serverCurrentStep.getName(), new Integer(returnedStepIndex)});
        }
        return returnData;
    }

    public ArrayList contructSteps(String taskCmdName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contructSteps", taskCmdName);
        }
        try {
            TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)this.cmdMgr).getTaskCommandSessionMgr();
            AbstractTaskCommand taskCmd = (AbstractTaskCommand)this.cmdMgr.createCommand(taskCmdName);
            EClass commandEClass = CommandMetadataMgr.getInstance().getParamDataEClass(taskCmdName);
            this.constructStepEClass(taskCmd.getTaskCommandMetadata());
            TaskCommandData taskCmdData = taskCmd.getTaskCommandData();
            TaskCommandSession taskSession = sessionMgr.createTaskCommandSession(taskCmd);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Command Session send is  " + taskSession.getSessionId());
                this.listAllStepParamsData(taskCmdData);
            }
            ArrayList<Serializable> returnData = new ArrayList<Serializable>(2);
            returnData.add(0, taskSession);
            returnData.add(1, this.createEObjSerializer(taskCmdData));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "contructSteps");
            }
            return returnData;
        }
        catch (Exception cnfe) {
            Tr.debug(tc, "Exception caught ", cnfe);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "contructSteps, return null.");
            }
            return null;
        }
    }

    public void sendCmdNotification(String type, Object e) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendCmdNotification", new Object[]{type, e});
            }
            try {
                Notification notf = new Notification(type, this, messageId++);
                notf.setUserData(e);
                this.sendNotification(notf);
            }
            catch (Throwable th) {
                Manager.Ffdc.log(th, this, "com.ibm.ws.management.cmdframework.impl.RemoteCommandMgrImpl.sendJMXEvent", "359", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception from sending JMX event: ", th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendCmdNotification");
        }
    }

    private void constructStepEClass(TaskCommandMetadata taskCmdMetaData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructStepEClass", taskCmdMetaData);
        }
        String taskCmdName = taskCmdMetaData.getName();
        EList steps = taskCmdMetaData.getSteps();
        for (CommandStepMetadata stepMetadata : steps) {
            String stepCmdName = stepMetadata.getName();
            CommandMetadataMgr.getInstance().createParamDataEClass(CommandMetadataMgr.getInstance().getStepEClassName(taskCmdName, stepCmdName), stepMetadata.getParameters());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructStepEClass");
        }
    }

    private EObjectSerializer createEObjSerializer(EObject metadata) throws IOException {
        EObjectSerializer eObjectSerializer;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createEObjSerializer", metadata);
            }
            EObjectSerializer eObjSerizer = new EObjectSerializer();
            try {
                eObjSerizer.setEObjectValue(CommandUtility.clone(metadata));
                eObjectSerializer = eObjSerizer;
                Object var5_5 = null;
                if (!tc.isEntryEnabled()) break block6;
            }
            catch (IOException ioe) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught", ioe);
                    }
                    throw ioe;
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var5_6 = null;
                        if (!tc.isEntryEnabled()) break block7;
                        Tr.exit(tc, "createEObjSerializer");
                    }
                    throw throwable;
                }
            }
            Tr.exit(tc, "createEObjSerializer");
        }
        return eObjectSerializer;
    }
}

