/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.object;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class WsLogRecordHelper {
    private static final int svClassVersion = 3;

    public static void writeEventToStream(LogRecord lr, DataOutputStream dos) throws IOException {
        WsLogRecordHelper.writeEventToStreamInCBEFormat(lr, dos);
    }

    public static WsLogRecord readEventFromStream(DataInputStream dis) throws IOException {
        return WsLogRecordHelper.readEventFromStreamInCBEFormat(dis);
    }

    private static WsLogRecord readEventFromStreamInCBEFormat(DataInputStream dis) throws IOException {
        int classVersion = dis.readInt();
        if (classVersion < 3) {
            return WsLogRecordHelper.readLegacyEventFromStream(dis, classVersion);
        }
        CommonBaseEventLogRecord cbelr = null;
        try {
            String cbelrString = dis.readUTF();
            CommonBaseEvent cbe = EventFormatter.eventFromCanonicalXML(cbelrString);
            cbelr = new CommonBaseEventLogRecord(cbe);
        }
        catch (Exception e) {
            cbelr = null;
        }
        return WsLogRecordFactory.getWsLogRecordIfConvertible(cbelr);
    }

    private static void writeEventToStreamInCBEFormat(LogRecord lr, DataOutputStream dos) throws IOException {
        dos.writeInt(3);
        CommonBaseEventLogRecord cbelr = WsLogRecordFactory.convertToCBELogRecord(lr);
        CommonBaseEvent cbe = cbelr.getCommonBaseEvent();
        String cbelrString = EventFormatter.toCanonicalXMLString(cbe, false);
        dos.writeUTF(cbelrString);
    }

    static WsLogRecord readLegacyEventFromStream(DataInputStream dis, int classVersion) throws IOException {
        WsLogRecord lr;
        String org = dis.readUTF();
        String prod = dis.readUTF();
        String comp = dis.readUTF();
        String vers = dis.readUTF();
        String name2 = dis.readUTF();
        String method = dis.readUTF();
        String tid = dis.readUTF();
        String pid = dis.readUTF();
        String pname = dis.readUTF();
        String msg = dis.readUTF();
        String rbName = dis.readUTF();
        String strace = dis.readUTF();
        String corr = dis.readUTF();
        long time = dis.readLong();
        Level level = WsLogRecordHelper.mapTypeToLevel(dis.readInt());
        int numberOfParms = dis.readInt();
        Object[] parms = null;
        if (numberOfParms != 0) {
            parms = new String[numberOfParms];
            for (int i = 0; i < numberOfParms; ++i) {
                parms[i] = dis.readUTF();
            }
        }
        int rawDataLength = dis.readInt();
        byte[] rawData = null;
        if (rawDataLength != 0) {
            rawData = new byte[rawDataLength];
            dis.read(rawData, 0, rawDataLength);
        }
        String className = null;
        if (classVersion == 2) {
            className = dis.readUTF();
        }
        if ((lr = WsLogRecordFactory.createWsLogRecord(EventFactoryImpl.getInstance(), level, msg, parms, className, method, rbName, null, null, org, prod, comp, null, Level.ALL.intValue(), name2)) == null) {
            return null;
        }
        lr.setVersion(vers);
        try {
            lr.setThreadID(Integer.parseInt(tid, 16));
        }
        catch (Throwable t) {
            lr.setThreadID(-1);
        }
        lr.setProcessId(pid);
        lr.setProcessName(pname);
        lr.setStackTrace(strace);
        lr.setCorrelationId(corr);
        lr.setMillis(time);
        if (rawData != null) {
            lr.setRawData(rawData);
        }
        return lr;
    }

    private static Level mapTypeToLevel(int type) {
        if (type < 0 || type >= WsLogRecordFactory.LevelTypesForRASEventTypes.length) {
            type = 8;
        }
        return WsLevel.LEVELS[LevelConstants.DISTINCT_LEVELS[WsLogRecordFactory.LevelTypesForRASEventTypes[type]]];
    }
}

