/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.genericbnf.impl.HeaderHandler;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.logging.DebugLog;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.HeaderStorage;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseMessageImpl
extends HttpBaseMessageImpl
implements HttpResponseMessage {
    private static final TraceComponent tc = Tr.register(HttpResponseMessageImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final long serialVersionUID = 7629585068712704258L;
    private static final byte[] NOCACHE_VALUE = GenericUtils.getEnglishBytes("no-cache=\"set-cookie, set-cookie2\"");
    private static final byte[] LONG_AGO = GenericUtils.getEnglishBytes("Thu, 01 Dec 1994 16:00:00 GMT");
    private transient StatusCodes myStatusCode = StatusCodes.OK;
    private byte[] myReasonBytes = null;
    private transient String myReason = null;

    public HttpResponseMessageImpl() {
        this.setOwner(null);
        this.setBinaryParseState(14);
    }

    public HttpResponseMessageImpl(HttpInboundServiceContext isc) {
        this.setOwner(isc);
        this.setBinaryParseState(14);
        this.initVersion();
    }

    public HttpResponseMessageImpl(HttpOutboundServiceContext osc) {
        this.setOwner(osc);
        this.setBinaryParseState(14);
    }

    public void init(HttpInboundServiceContext sc) {
        this.setOwner(sc);
        this.setBinaryParseState(14);
        this.initVersion();
    }

    public void init(HttpOutboundServiceContext sc) {
        this.setOwner(sc);
        this.setBinaryParseState(14);
    }

    public void init(HttpInboundServiceContext sc, BNFHeaders hdrs) {
        this.setOwner(sc);
        this.setBinaryParseState(14);
        if (null != hdrs) {
            hdrs.duplicate(this);
        }
        this.initVersion();
    }

    public void init(HttpOutboundServiceContext sc, BNFHeaders hdrs) {
        this.setOwner(sc);
        this.setBinaryParseState(14);
        if (null != hdrs) {
            hdrs.duplicate(this);
        }
    }

    private void initVersion() {
        VersionValues ver = this.getServiceContext().getRequestVersion();
        VersionValues configVer = this.getServiceContext().getHttpConfig().getOutgoingVersion();
        if (VersionValues.V10.equals(configVer) && VersionValues.V11.equals(ver)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Configuration forcing 1.0 instead of 1.1");
            }
            this.setVersion(configVer);
        } else {
            this.setVersion(ver);
        }
    }

    public void setOwner(HttpServiceContext hsc) {
        if (null != this.getServiceContext()) {
            this.getServiceContext().setResponseOwner(false);
        }
        if (null != hsc) {
            super.init(hsc);
            this.getServiceContext().setResponseOwner(true);
            this.setIncoming(!this.getServiceContext().isInboundConnection());
            if (!this.isIncoming()) {
                this.setHeaderValidation(this.getServiceContext().getHttpConfig().isHeaderValidationEnabled());
            }
        }
    }

    @Override
    public boolean isBodyExpected() {
        if (VersionValues.V10.equals(this.getVersionValue())) {
            return this.isBodyAllowed();
        }
        if (super.isBodyExpected() || this.containsHeader(HttpHeaderKeys.HDR_CONTENT_RANGE)) {
            if (this.getServiceContext().getRequestMethod().equals(MethodValues.HEAD)) {
                return false;
            }
            return this.myStatusCode.isBodyAllowed();
        }
        return false;
    }

    @Override
    public boolean isBodyAllowed() {
        if (super.isBodyAllowed()) {
            if (this.getServiceContext().getRequestMethod().equals(MethodValues.HEAD)) {
                return false;
            }
            return this.myStatusCode.isBodyAllowed();
        }
        return false;
    }

    @Override
    public boolean shouldUpdateBodyHeaders() {
        return !MethodValues.HEAD.equals(this.getServiceContext().getRequestMethod());
    }

    @Override
    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Clearing this response: " + this);
        }
        super.clear();
        this.myStatusCode = StatusCodes.OK;
        this.myReason = null;
        this.myReasonBytes = null;
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Destroying this response: " + this);
        }
        HttpObjectFactory tempFactory = this.getObjectFactory();
        super.destroy();
        if (null != tempFactory) {
            tempFactory.releaseResponse(this);
        }
    }

    @Override
    protected void setParsedFirstToken(byte[] token) throws Exception {
        this.setVersion(token);
    }

    @Override
    protected void setParsedSecondToken(byte[] token) throws Exception {
        this.setStatusCode(GenericUtils.asIntValue(token));
    }

    @Override
    protected void setParsedThirdToken(byte[] token) throws Exception {
        this.setReasonPhrase(token);
    }

    @Override
    protected byte[] getMarshalledFirstToken() {
        return this.getVersionValue().getByteArray();
    }

    @Override
    protected byte[] getMarshalledSecondToken() {
        return this.myStatusCode.getByteArray();
    }

    @Override
    protected byte[] getMarshalledThirdToken() {
        return this.getReasonPhraseBytes();
    }

    @Override
    public boolean parseBinaryFirstLine(WsByteBuffer buff) throws MalformedMessageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "parseBinaryFirstLine for " + this);
            Tr.debug(tc, "Buffer: " + buff);
        }
        if (this.getBinaryParseState() == 14) {
            if (!buff.hasRemaining()) {
                return false;
            }
            byte version = buff.get();
            if (version != 49) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported binary version in message: " + version);
                }
                throw new MalformedMessageException("Invalid binary message");
            }
            this.setBinaryParseState(5);
            this.resetCacheToken(4);
        }
        boolean lineEnds = false;
        block7: while (!lineEnds) {
            if (!this.fillCacheToken(buff)) {
                return false;
            }
            switch (this.getBinaryParseState()) {
                case 5: {
                    int value2 = GenericUtils.asInt(this.getParsedToken());
                    if (0 == (value2 & 0x20000)) {
                        this.setVersion(VersionValues.getByOrdinal(value2));
                        this.setBinaryParseState(11);
                        this.resetCacheToken(4);
                        continue block7;
                    }
                    this.setBinaryParseState(6);
                    this.resetCacheToken(value2 & 0x1FFFF);
                    continue block7;
                }
                case 6: {
                    this.setVersion(VersionValues.find(this.getParsedToken()));
                    this.setBinaryParseState(11);
                    this.createCacheToken(4);
                    continue block7;
                }
                case 11: {
                    this.setStatusCode(GenericUtils.asInt(this.getParsedToken()));
                    this.setBinaryParseState(12);
                    this.resetCacheToken(4);
                    continue block7;
                }
                case 12: {
                    int value2 = GenericUtils.asInt(this.getParsedToken());
                    if (0 == value2) {
                        this.setBinaryParseState(1);
                        this.resetCacheToken(4);
                        lineEnds = true;
                        continue block7;
                    }
                    this.setBinaryParseState(13);
                    this.resetCacheToken(value2);
                    continue block7;
                }
                case 13: {
                    this.setReasonPhrase(this.getParsedToken());
                    this.setBinaryParseState(1);
                    this.createCacheToken(4);
                    lineEnds = true;
                    continue block7;
                }
            }
            throw new MalformedMessageException("Invalid state in line: " + this.getBinaryParseState());
        }
        this.setFirstLineComplete(true);
        return true;
    }

    @Override
    public WsByteBuffer[] marshallLine() {
        WsByteBuffer[] firstLine = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        firstLine = this.putBytes(this.getVersionValue().getByteArray(), firstLine);
        firstLine = this.putByte((byte)32, firstLine);
        if (null == this.myReasonBytes) {
            firstLine = this.putBytes(this.myStatusCode.getStatusWithPhrase(), firstLine);
        } else {
            firstLine = this.putBytes(this.myStatusCode.getByteArray(), firstLine);
            firstLine = this.putByte((byte)32, firstLine);
            firstLine = this.putBytes(this.getReasonPhraseBytes(), firstLine);
        }
        firstLine = this.putBytes(BNFHeaders.EOL, firstLine);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Marshalling first line: " + this.getVersion() + " " + this.getStatusCodeAsInt() + " " + this.getReasonPhrase());
        }
        return firstLine;
    }

    @Override
    public WsByteBuffer[] marshallBinaryFirstLine() {
        WsByteBuffer[] firstLine = new WsByteBuffer[]{this.allocateBuffer(this.getOutgoingBufferSize())};
        firstLine = this.putByte((byte)49, firstLine);
        if (this.getVersionValue().isUndefined()) {
            byte[] data = this.getVersionValue().getByteArray();
            firstLine = this.putInt(data.length | 0x20000, firstLine);
            firstLine = this.putBytes(data, firstLine);
        } else {
            firstLine = this.putInt(this.getVersionValue().getOrdinal(), firstLine);
        }
        firstLine = this.putInt(this.myStatusCode.getIntCode(), firstLine);
        if (null != this.myReasonBytes) {
            firstLine = this.putInt(this.myReasonBytes.length, firstLine);
            firstLine = this.putBytes(this.myReasonBytes, firstLine);
        } else {
            firstLine = this.putInt(0, firstLine);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Marshalling binary first line: " + this.getVersion() + " " + this.getStatusCodeAsInt() + " " + this.getReasonPhrase());
        }
        return firstLine;
    }

    @Override
    protected void parsingComplete() throws MalformedMessageException {
        int num = this.getNumberFirstLineTokens();
        if (3 != num && 2 != num) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "numFirstLineTokensRead is " + this.getNumberFirstLineTokens());
            }
            if (this.getServiceContext().getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
                this.getServiceContext().getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "Invalid number of first line tokens", (HttpServiceContext)this.getServiceContext());
            }
            throw new MalformedMessageException("Received " + this.getNumberFirstLineTokens() + " first line tokens");
        }
    }

    @Override
    public void headerComplianceCheck() throws MessageSentException {
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isEntryEnabled()) {
            Tr.entry(tc, "headerComplianceCheck");
        }
        super.headerComplianceCheck();
        if (!this.containsHeader(HttpHeaderKeys.HDR_DATE)) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a missing Date header");
            }
            this.setCurrentDate();
        }
        if (this.getServiceContext().getHttpConfig().removeServerHeader()) {
            if (this.containsHeader(HttpHeaderKeys.HDR_SERVER)) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configuration forcing removal of Server header");
                }
                this.removeSpecialHeader(HttpHeaderKeys.HDR_SERVER);
            }
        } else if (!this.containsHeader(HttpHeaderKeys.HDR_SERVER)) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_SERVER, this.getServiceContext().getHttpConfig().getServerHeaderValue());
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding default Server header value: " + this.getHeaderAsString(HttpHeaderKeys.HDR_SERVER));
            }
        }
        if (this.getServiceContext().getHttpConfig().shouldCookiesConfigureNoCache()) {
            this.updateCacheControl();
        }
        if (bTrace && tc.isEntryEnabled()) {
            Tr.exit(tc, "headerComplianceCheck");
        }
    }

    private void updateCacheControl() {
        boolean addSet2;
        boolean addSet1 = this.containsHeader(HttpHeaderKeys.HDR_SET_COOKIE) || this.isCookieCacheDirty(HttpHeaderKeys.HDR_SET_COOKIE);
        boolean bl = addSet2 = this.containsHeader(HttpHeaderKeys.HDR_SET_COOKIE2) || this.isCookieCacheDirty(HttpHeaderKeys.HDR_SET_COOKIE2);
        if (!addSet1 && !addSet2) {
            return;
        }
        if (!this.containsHeader(HttpHeaderKeys.HDR_EXPIRES)) {
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_EXPIRES, LONG_AGO);
        }
        if (this.containsHeader(HttpHeaderKeys.HDR_CACHE_CONTROL)) {
            HeaderHandler handler2 = new HeaderHandler((HeaderStorage)this, ',', HttpHeaderKeys.HDR_CACHE_CONTROL);
            if (!handler2.contains("no-cache")) {
                boolean updated = false;
                if (addSet1) {
                    updated = handler2.add("no-cache", "set-cookie");
                }
                if (addSet2) {
                    updated = handler2.add("no-cache", "set-cookie2") | updated;
                }
                if (updated) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Updating Cache-Control for Set-Cookie");
                    }
                    this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CACHE_CONTROL, handler2.marshall());
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Adding Cache-Control due to Set-Cookie");
            }
            this.setSpecialHeader((HeaderKeys)HttpHeaderKeys.HDR_CACHE_CONTROL, NOCACHE_VALUE);
        }
    }

    @Override
    public final int getStatusCodeAsInt() {
        return this.myStatusCode.getIntCode();
    }

    @Override
    public final StatusCodes getStatusCode() {
        return this.myStatusCode;
    }

    @Override
    public void setStatusCode(int code) {
        StatusCodes val = null;
        try {
            val = StatusCodes.getByOrdinal(code);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (null == val) {
            val = StatusCodes.makeUndefinedValue(code);
        }
        this.setStatusCode(val);
    }

    @Override
    public void setStatusCode(StatusCodes code) {
        if (!code.equals(this.myStatusCode)) {
            this.myStatusCode = code;
            this.myReason = null;
            this.myReasonBytes = null;
            super.setFirstLineChanged();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "setStatusCode(sc): " + code);
        }
    }

    public boolean isTemporaryStatusCode() {
        int code = this.myStatusCode.getIntCode();
        return 100 <= code && 200 > code;
    }

    @Override
    public String getReasonPhrase() {
        if (null == this.myReason) {
            this.myReason = GenericUtils.getEnglishString(this.getReasonPhraseBytes());
        }
        return this.myReason;
    }

    @Override
    public byte[] getReasonPhraseBytes() {
        if (null == this.myReasonBytes) {
            return this.myStatusCode.getDefaultPhraseBytes();
        }
        return this.myReasonBytes;
    }

    @Override
    public void setReasonPhrase(String reason) {
        this.myReason = reason;
        this.myReasonBytes = GenericUtils.getEnglishBytes(reason);
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "setReasonPhrase(String): set to [" + this.myReason + "]");
        }
    }

    @Override
    public void setReasonPhrase(byte[] reason) {
        this.myReasonBytes = reason;
        this.myReason = null;
        super.setFirstLineChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            this.myReason = GenericUtils.getEnglishString(reason);
            Tr.event(tc, "setReasonPhrase(byte[]): set to [" + this.myReason + "]");
        }
    }

    @Override
    public byte[] getCookieValue(String name2) {
        if (null == name2) {
            return null;
        }
        byte[] val = this.getCookieValue(name2, HttpHeaderKeys.HDR_SET_COOKIE);
        if (null == val) {
            val = this.getCookieValue(name2, HttpHeaderKeys.HDR_SET_COOKIE2);
        }
        return val;
    }

    @Override
    public List<String> getAllCookieValues(String name2) {
        LinkedList<String> list = new LinkedList<String>();
        if (null != name2) {
            this.getAllCookieValues(name2, HttpHeaderKeys.HDR_SET_COOKIE, list);
            this.getAllCookieValues(name2, HttpHeaderKeys.HDR_SET_COOKIE2, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllCookieValues: Found " + list.size() + " instances of " + name2);
        }
        return list;
    }

    @Override
    public Cookie getCookie(String name2) {
        if (null == name2) {
            return null;
        }
        Cookie cookie = this.getCookie(name2, HttpHeaderKeys.HDR_SET_COOKIE);
        if (null == cookie) {
            cookie = this.getCookie(name2, HttpHeaderKeys.HDR_SET_COOKIE2);
        }
        return null == cookie ? null : (Cookie)cookie.clone();
    }

    @Override
    public List<Cookie> getAllCookies() {
        LinkedList<Cookie> list = new LinkedList<Cookie>();
        this.getAllCookies(HttpHeaderKeys.HDR_SET_COOKIE, list);
        this.getAllCookies(HttpHeaderKeys.HDR_SET_COOKIE2, list);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllCookies: Found " + list.size() + " instances");
        }
        return list;
    }

    @Override
    public List<Cookie> getAllCookies(String name2) {
        LinkedList<Cookie> list = new LinkedList<Cookie>();
        if (null != name2) {
            this.getAllCookies(name2, HttpHeaderKeys.HDR_SET_COOKIE, list);
            this.getAllCookies(name2, HttpHeaderKeys.HDR_SET_COOKIE2, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAllCookies: Found " + list.size() + " instances of " + name2);
        }
        return list;
    }

    @Override
    public boolean setCookie(Cookie cookie, HeaderKeys header2) {
        if (null == cookie || null == header2) {
            return false;
        }
        if (1 < cookie.getVersion()) {
            throw new IllegalArgumentException("Cookie version is invalid: " + cookie.getVersion());
        }
        HttpHeaderKeys headers = (HttpHeaderKeys)header2;
        return this.setCookie(cookie, headers);
    }

    @Override
    public boolean setCookie(Cookie cookie, HttpHeaderKeys header2) {
        if (header2.equals(HttpHeaderKeys.HDR_SET_COOKIE) || header2.equals(HttpHeaderKeys.HDR_SET_COOKIE2)) {
            return this.addCookie(cookie, header2);
        }
        return false;
    }

    @Override
    public boolean setCookie(String name2, String value2, HeaderKeys header2) {
        if (null == header2) {
            return false;
        }
        HttpHeaderKeys headers = (HttpHeaderKeys)header2;
        return this.setCookie(name2, value2, headers);
    }

    @Override
    public boolean setCookie(String name2, String value2, HttpHeaderKeys header2) {
        return this.setCookie(new Cookie(name2, value2), header2);
    }

    @Override
    public boolean removeCookie(String name2, HeaderKeys header2) {
        if (null == name2 || null == header2) {
            return false;
        }
        HttpHeaderKeys headers = (HttpHeaderKeys)header2;
        return this.removeCookie(name2, headers);
    }

    @Override
    public boolean removeCookie(String name2, HttpHeaderKeys header2) {
        if (header2.equals(HttpHeaderKeys.HDR_SET_COOKIE) || header2.equals(HttpHeaderKeys.HDR_SET_COOKIE2)) {
            return this.deleteCookie(name2, header2);
        }
        return false;
    }

    @Override
    public void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Response Message: " + this);
            Tr.debug(tc, "Status: " + this.getStatusCodeAsInt());
            Tr.debug(tc, "Reason: " + this.getReasonPhrase());
            super.debug();
        }
    }

    @Override
    public HttpResponseMessage duplicate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the response message: " + this);
        }
        HttpResponseMessageImpl msg = null;
        HttpObjectFactory factory = this.getObjectFactory();
        if (null == factory) {
            msg = new HttpResponseMessageImpl();
            msg.setIncoming(this.isIncoming());
        } else {
            msg = this.isIncoming() ? factory.getResponse(this.getOutboundSC()) : factory.getResponse(this.getInboundSC());
        }
        msg.setStatusCode(this.myStatusCode);
        msg.setReasonPhrase(this.myReasonBytes);
        super.duplicate(msg);
        return msg;
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "De-serializing into: " + this);
        }
        super.readExternal(input);
        if (-1091633150 == this.getDeserializationVersion()) {
            this.setStatusCode(input.readShort());
        } else {
            this.setStatusCode(input.readInt());
        }
        this.setReasonPhrase(this.readByteArray(input));
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Serializing: " + this);
        }
        super.writeExternal(output);
        output.writeShort(this.getStatusCodeAsInt());
        this.writeByteArray(output, this.myReasonBytes);
    }
}

