/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.compression;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.http.channel.compression.DecompressionHandler;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GzipInputHandler
implements DecompressionHandler {
    private static final TraceComponent tc = Tr.register(GzipInputHandler.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private PARSE_STATE state = PARSE_STATE.ID1;
    private byte gzipFlag = (byte)-1;
    private int parseInt = 0;
    private int parseFirstByte = 0;
    private int parseOffset = 0;
    private Inflater inflater = null;
    private byte[] buf = new byte[16384];
    private CRC32 checksum = null;

    public GzipInputHandler() {
        this.inflater = new Inflater(true);
        this.checksum = new CRC32();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created a gzip input handler; " + this);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private boolean isFExtraSet() {
        return (this.gzipFlag & 4) == 4;
    }

    private boolean isFNameSet() {
        return (this.gzipFlag & 8) == 8;
    }

    private boolean isFCommentSet() {
        return (this.gzipFlag & 0x10) == 16;
    }

    private boolean isFHCRCSet() {
        return (this.gzipFlag & 1) == 1;
    }

    private int skip(byte[] data, int pos, int count) {
        int remaining = data.length - pos;
        if (remaining >= count) {
            this.parseInt = 0;
            return pos + count;
        }
        this.parseInt = count - remaining;
        return data.length;
    }

    private int skipPast(byte[] data, int pos, byte target) {
        while (pos < data.length) {
            if (target != data[pos++]) continue;
            return pos;
        }
        return pos;
    }

    private int parseHeader(byte[] data) throws DataFormatException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing gzip header; state=" + (Object)((Object)this.state));
        }
        int pos = 0;
        while (pos < data.length && PARSE_STATE.DONE != this.state) {
            byte b = data[pos++];
            if (PARSE_STATE.ID1 == this.state) {
                if (31 != b) {
                    throw new DataFormatException("Invalid gzip header, first byte=" + b);
                }
                this.state = PARSE_STATE.ID2;
                continue;
            }
            if (PARSE_STATE.ID2 == this.state) {
                if (-117 != b) {
                    throw new DataFormatException("Invalid gzip header, second byte=" + b);
                }
                this.state = PARSE_STATE.COMPRESSION;
                continue;
            }
            if (PARSE_STATE.COMPRESSION == this.state) {
                if (8 != b) {
                    throw new DataFormatException("Invalid gzip compression method=" + b);
                }
                this.state = PARSE_STATE.FLAG;
                continue;
            }
            if (PARSE_STATE.FLAG == this.state) {
                if (-1 == this.gzipFlag) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "gzip header flag=" + b);
                    }
                    this.gzipFlag = b;
                    pos = this.skip(data, pos, 6);
                } else {
                    pos = this.skip(data, pos, this.parseInt);
                }
                if (0 != this.parseInt) continue;
                this.state = this.isFExtraSet() ? PARSE_STATE.FEXTRA : (this.isFNameSet() ? PARSE_STATE.FNAME : (this.isFCommentSet() ? PARSE_STATE.FCOMMENT : (this.isFHCRCSet() ? PARSE_STATE.FHCRC : PARSE_STATE.DONE)));
                this.parseOffset = 0;
                continue;
            }
            if (PARSE_STATE.FEXTRA == this.state) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsing FEXTRA data, offset=" + this.parseOffset);
                }
                if (0 == this.parseOffset) {
                    this.parseInt = b;
                    ++this.parseOffset;
                    continue;
                }
                if (1 == this.parseOffset) {
                    this.parseInt = b << 8 | this.parseInt;
                    ++this.parseOffset;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "FEXTRA length is " + this.parseInt);
                }
                pos = this.skip(data, pos, this.parseInt);
                if (0 != this.parseInt) continue;
                this.state = this.isFNameSet() ? PARSE_STATE.FNAME : (this.isFCommentSet() ? PARSE_STATE.FCOMMENT : (this.isFHCRCSet() ? PARSE_STATE.FHCRC : PARSE_STATE.DONE));
                this.parseOffset = 0;
                continue;
            }
            if (PARSE_STATE.FNAME == this.state) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsing FNAME data");
                }
                if (0 != b) {
                    pos = this.skipPast(data, pos, (byte)0);
                }
                if (data.length == pos) {
                    return pos;
                }
                if (this.isFCommentSet()) {
                    this.state = PARSE_STATE.FCOMMENT;
                    continue;
                }
                if (this.isFHCRCSet()) {
                    this.state = PARSE_STATE.FHCRC;
                    continue;
                }
                this.state = PARSE_STATE.DONE;
                continue;
            }
            if (PARSE_STATE.FCOMMENT == this.state) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parsing FCOMMENT data");
                }
                if (0 != b) {
                    pos = this.skipPast(data, pos, (byte)0);
                }
                if (data.length == pos) {
                    return pos;
                }
                if (this.isFHCRCSet()) {
                    this.state = PARSE_STATE.FHCRC;
                    continue;
                }
                this.state = PARSE_STATE.DONE;
                continue;
            }
            if (PARSE_STATE.FHCRC != this.state) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsing FHCRC data; offset=" + this.parseOffset);
            }
            ++this.parseOffset;
            if (2 > this.parseOffset) continue;
            this.state = PARSE_STATE.DONE;
        }
        if (PARSE_STATE.DONE == this.state) {
            this.parseOffset = 0;
            this.parseInt = 0;
        }
        return pos;
    }

    private int parseTrailer(byte[] input, int offset, List<WsByteBuffer> list) throws DataFormatException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing trailer, offset=" + this.parseOffset + " val=" + this.parseInt);
        }
        long val = 0L;
        while (8 > this.parseOffset && offset < input.length) {
            switch (this.parseOffset) {
                case 0: 
                case 2: 
                case 4: 
                case 6: {
                    this.parseFirstByte = input[offset] & 0xFF;
                    break;
                }
                case 1: 
                case 5: {
                    this.parseInt = (input[offset] & 0xFF) << 8 | this.parseFirstByte;
                    break;
                }
                case 3: {
                    val = (input[offset] & 0xFF) << 8 | this.parseFirstByte;
                    val = val << 16 | (long)this.parseInt;
                    if (this.checksum.getValue() == val) break;
                    String msg = "Checksum does not match; crc=" + this.checksum.getValue() + " trailer=" + val;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, msg);
                    }
                    this.release(list);
                    throw new DataFormatException(msg);
                }
                case 7: {
                    val = (input[offset] & 0xFF) << 8 | this.parseFirstByte;
                    val = val << 16 | (long)this.parseInt;
                    if (this.inflater.getBytesWritten() == val) break;
                    String msg = "BytesWritten does not match; inflater=" + this.inflater.getBytesWritten() + " trailer=" + val;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, msg);
                    }
                    this.release(list);
                    throw new DataFormatException(msg);
                }
            }
            ++offset;
            ++this.parseOffset;
        }
        return offset;
    }

    private void release(List<WsByteBuffer> list) {
        while (!list.isEmpty()) {
            list.remove(0).release();
        }
    }

    @Override
    public List<WsByteBuffer> decompress(WsByteBuffer inputBuffer) throws DataFormatException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "decompress, input=" + inputBuffer);
        }
        LinkedList<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        int dataSize = inputBuffer.remaining();
        byte[] input = new byte[dataSize];
        inputBuffer.get(input, 0, dataSize);
        int inOffset = 0;
        if (PARSE_STATE.DONE != this.state && (inOffset = this.parseHeader(input)) >= input.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "decompress, ran out of data while parsing gzip header");
            }
            return list;
        }
        if (!this.inflater.finished()) {
            this.inflater.setInput(input, inOffset, dataSize - inOffset);
        }
        long initialBytesRead = this.inflater.getBytesRead();
        int outOffset = 0;
        int len = -1;
        while (inOffset < input.length && !this.inflater.finished() && 0 != len) {
            try {
                len = this.inflater.inflate(this.buf, outOffset, this.buf.length - outOffset);
            }
            catch (DataFormatException dfe) {
                this.release(list);
                throw dfe;
            }
            long bytesRead = this.inflater.getBytesRead();
            inOffset = (int)((long)inOffset + (bytesRead - initialBytesRead));
            initialBytesRead = bytesRead;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Decompressed amount=" + len + " inOffset=" + inOffset + " read=" + this.inflater.getBytesRead() + " written=" + this.inflater.getBytesWritten() + " finished=" + this.inflater.finished());
            }
            if ((outOffset += len) < this.buf.length) continue;
            WsByteBuffer buffer = WsByteBufferPoolManagerImpl.getRef().allocate(this.buf.length);
            buffer.put(this.buf, 0, this.buf.length);
            this.checksum.update(this.buf, 0, this.buf.length);
            buffer.flip();
            list.add(buffer);
            outOffset = 0;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Storing decompressed buffer; " + buffer);
        }
        if (0 < outOffset) {
            WsByteBuffer buffer = WsByteBufferPoolManagerImpl.getRef().allocate(outOffset);
            buffer.put(this.buf, 0, outOffset);
            this.checksum.update(this.buf, 0, outOffset);
            buffer.flip();
            list.add(buffer);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Stored final decompressed buffer; " + buffer);
            }
        }
        if (this.inflater.finished()) {
            inOffset = this.parseTrailer(input, inOffset, list);
        }
        if (inOffset < dataSize) {
            inputBuffer.position(inputBuffer.position() - (dataSize - inOffset));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "input buffer has unused data; " + inputBuffer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "decompress, output=" + list.size());
        }
        return list;
    }

    @Override
    public void close() {
        this.inflater.end();
    }

    @Override
    public boolean isFinished() {
        return this.inflater.finished();
    }

    @Override
    public long getBytesRead() {
        return this.inflater.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.inflater.getBytesWritten();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PARSE_STATE {
        ID1,
        ID2,
        COMPRESSION,
        FLAG,
        FEXTRA,
        FNAME,
        FCOMMENT,
        FHCRC,
        DONE;

    }
}

