/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.ffdc.IncidentStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrospectionLevelMember {
    public static final String $sccsid = "@(#) 1.4 SERV1/ws/code/ras.lite/src/com/ibm/ws/ffdc/IntrospectionLevelMember.java, WAS.ras.lite, WAS70.SERV1, cf050925.09 08/07/23 10:33:23 [6/25/09 08:11:54]";
    private static final String OBJECT_TYPE = "Object type";
    private static final String EQUALS = " = ";
    private static final int EQUALS_LENGTH = " = ".length();
    private static final int EXTRA_SPACE = 5;
    private static final int MAX_PRIMITIVE_ARRAY_LENGTH = 1024;
    private static final Field[] EMPTY_FIELDS = new Field[0];
    private Object _member;
    private int _level;
    private String _name;
    private String _description;
    private List<IntrospectionLevelMember> _children;
    private Set<IntrospectionLevelMember> _allKnownMembersInThisTree;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntrospectionLevelMember) {
            IntrospectionLevelMember other = (IntrospectionLevelMember)obj;
            return this._member == other._member;
        }
        return false;
    }

    public int hashCode() {
        if (this._member == null) {
            return 0;
        }
        return System.identityHashCode(this._member);
    }

    public IntrospectionLevelMember(Object member) {
        this(0, OBJECT_TYPE, member.getClass().getName(), member, new HashSet<IntrospectionLevelMember>());
        this._allKnownMembersInThisTree.add(this);
    }

    private IntrospectionLevelMember(int level, String name2, String description, Object member, Set<IntrospectionLevelMember> allKnownMembers) {
        this._level = level;
        this._name = name2;
        this._description = description;
        this._member = member;
        this._allKnownMembersInThisTree = allKnownMembers;
    }

    public int sizeOfIntrospection() {
        return this._name.length() + this._description.length() + 5 + 2 * this._level;
    }

    public List<IntrospectionLevelMember> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<IntrospectionLevelMember>();
            if (this._member != null) {
                if (this._member instanceof String) {
                    this.addNewChild("String value", this._member);
                } else if (this._member instanceof FFDCSelfIntrospectable) {
                    this.introspectSelfIntrospectable();
                } else {
                    this.introspectViaReflection();
                }
            }
        }
        return this._children;
    }

    private void introspectViaReflection() {
        Class<?> memberClass = this._member.getClass();
        if (memberClass.isArray()) {
            int length = Array.getLength(this._member);
            for (int i = 0; i < length; ++i) {
                Object value2 = Array.get(this._member, i);
                this.addNewChild(this._name + "[" + i + "]", value2);
            }
        } else {
            for (Class<?> currentClass = this._member.getClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                Field[] fields = this.getFields(currentClass);
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    Object value3 = this.getFieldValue(field);
                    this.addNewChild(field.getName(), value3);
                }
            }
        }
    }

    private void introspectSelfIntrospectable() {
        try {
            String[] strings = ((FFDCSelfIntrospectable)this._member).introspectSelf();
            if (strings != null) {
                for (int i = 0; i < strings.length; ++i) {
                    if (strings[i] != null) {
                        int equalsLoc = strings[i].indexOf(EQUALS);
                        if (equalsLoc > 0 && equalsLoc < strings[i].length() - EQUALS_LENGTH) {
                            this.addNewChild(strings[i].substring(0, equalsLoc), strings[i].substring(equalsLoc + EQUALS_LENGTH));
                            continue;
                        }
                        if (equalsLoc > 0) {
                            this.addNewChild(strings[i].substring(0, equalsLoc), "");
                            continue;
                        }
                        this.addNewChild("strings[" + i + "]", strings[i]);
                        continue;
                    }
                    this.addNewChild("strings[" + i + "]", null);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void addNewChild(String name2, Object value2) {
        IntrospectionLevelMember prospectiveMember = new IntrospectionLevelMember(this._level + 1, name2, this.makeDescription(value2), this.makeMember(value2), this._allKnownMembersInThisTree);
        if (this.makeMember(value2) != null) {
            if (this._allKnownMembersInThisTree.contains(prospectiveMember)) {
                prospectiveMember = new IntrospectionLevelMember(this._level + 1, name2, this.makeDescription(value2), null, this._allKnownMembersInThisTree);
            } else {
                this._allKnownMembersInThisTree.add(prospectiveMember);
            }
        }
        this._children.add(prospectiveMember);
    }

    private Object getFieldValue(final Field field) {
        Object field_value = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return field.get(IntrospectionLevelMember.this._member);
                }
                catch (IllegalAccessException e) {
                    return "/* Could not access " + field.getName() + " */";
                }
            }
        });
        return field_value;
    }

    private Field[] getFields(final Class currentClass) {
        Field[] objectFields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                try {
                    AccessibleObject[] tempObjectFields = currentClass.getDeclaredFields();
                    if (tempObjectFields.length != 0) {
                        AccessibleObject.setAccessible(tempObjectFields, true);
                    }
                    return tempObjectFields;
                }
                catch (NoClassDefFoundError e) {
                    return EMPTY_FIELDS;
                }
            }
        });
        return objectFields;
    }

    private String makeDescription(Object value2) {
        Class<?> objClass;
        String answer = value2 == null ? "null" : (value2 instanceof String ? "\"" + value2 + "\"" : ((objClass = value2.getClass()) == Boolean.class || objClass == Character.class || objClass == Byte.class || objClass == Short.class || objClass == Integer.class || objClass == Long.class || objClass == Float.class || objClass == Double.class ? value2.toString() : (objClass.isArray() ? (objClass.getComponentType().isPrimitive() ? this.convertSimpleArrayToString(value2) : objClass.getComponentType() + "[" + Array.getLength(value2) + "]") : value2.getClass().toString() + "@" + Integer.toHexString(System.identityHashCode(value2)))));
        return answer;
    }

    private String convertSimpleArrayToString(Object value2) {
        int length = Array.getLength(value2);
        StringBuffer temp = new StringBuffer("{");
        for (int i = 0; i < length && i < 1024; ++i) {
            Object element = Array.get(value2, i);
            if (i > 0 && !(element instanceof Character)) {
                temp.append(",");
            }
            temp.append(element);
        }
        if (length > 1024) {
            if (!(Array.get(value2, 0) instanceof Character)) {
                temp.append(",");
            }
            temp.append("...");
        }
        temp.append("} /* array length = ");
        temp.append(Integer.toString(Array.getLength(value2)));
        temp.append("*/");
        String answer = temp.toString();
        return answer;
    }

    private Object makeMember(Object value2) {
        Object answer = null;
        if (value2 != null) {
            Class<?> objClass = value2.getClass();
            if (objClass.isArray()) {
                if (Array.getLength(value2) > 0 && !objClass.getComponentType().isPrimitive()) {
                    answer = value2;
                }
            } else if (objClass != String.class && objClass != Boolean.class && objClass != Character.class && objClass != Byte.class && objClass != Short.class && objClass != Integer.class && objClass != Long.class && objClass != Float.class && objClass != Double.class && objClass != String.class) {
                answer = value2;
            }
        }
        return answer;
    }

    public void print(IncidentStream is, int maxDepth) {
        StringBuffer fullName = new StringBuffer();
        for (int i = 0; i < this._level; ++i) {
            fullName.append("  ");
        }
        fullName.append(this._name);
        is.writeLine(fullName.toString(), this._description);
        if (this._level < maxDepth) {
            List<IntrospectionLevelMember> children = this.getChildren();
            for (IntrospectionLevelMember ilm : children) {
                ilm.print(is, maxDepth);
            }
        }
    }
}

