/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import org.eclipse.core.runtime.IStatus;

class Status
implements IStatus {
    private int _severity = 0;
    private String _pluginId;
    private int _code;
    private String _message;
    private Throwable _exception = null;
    private static final IStatus[] EMPTY_STATUS_ARRAY = new IStatus[0];

    public Status(int severity, String pluginId, int code, String message, Throwable exception) {
        this.setSeverity(severity);
        this.setPlugin(pluginId);
        this.setCode(code);
        this.setMessage(message);
        this.setException(exception);
    }

    public IStatus[] getChildren() {
        return EMPTY_STATUS_ARRAY;
    }

    public int getCode() {
        return this._code;
    }

    public Throwable getException() {
        return this._exception;
    }

    public String getMessage() {
        return this._message;
    }

    public String getPlugin() {
        return this._pluginId;
    }

    public int getSeverity() {
        return this._severity;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean isOK() {
        return this._severity == 0;
    }

    public boolean matches(int severityMask) {
        return (this._severity & severityMask) != 0;
    }

    protected void setCode(int code) {
        this._code = code;
    }

    protected void setException(Throwable exception) {
        this._exception = exception;
    }

    protected void setMessage(String message) {
        this._message = message;
    }

    protected void setPlugin(String pluginId) {
        this._pluginId = pluginId;
    }

    protected void setSeverity(int severity) {
        this._severity = severity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Status ");
        if (this._severity == 0) {
            buf.append("OK");
        } else if (this._severity == 4) {
            buf.append("ERROR");
        } else if (this._severity == 2) {
            buf.append("WARNING");
        } else if (this._severity == 1) {
            buf.append("INFO");
        } else if (this._severity == 8) {
            buf.append("CANCEL");
        } else {
            buf.append("severity=");
            buf.append(this._severity);
        }
        buf.append(": ");
        buf.append(this._pluginId);
        buf.append(" code=");
        buf.append(this._code);
        buf.append(' ');
        buf.append(this._message);
        buf.append(' ');
        buf.append(this._exception);
        return buf.toString();
    }
}

