/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.extension.thinregistry.ExtensionRegistry;
import com.ibm.ws.extension.thinregistry.PluginDescriptor;
import com.ibm.ws.extension.thinregistry.PluginParser;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.xml.sax.InputSource;

public class RegistryLoader {
    private static final String srcClass = "RegistryLoader";
    private ExtensionRegistry _registry = null;
    private PluginParser _parser = null;

    public RegistryLoader(ExtensionRegistry reg) {
        this._registry = reg;
        this._parser = new PluginParser();
    }

    public void addToRegistry(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block2: {
                    try {
                        Enumeration<URL> e = cl.getResources("plugin.xml");
                        RegistryLoader.this.loadAllPluginXmls(e, cl);
                        e = cl.getResources("fragment.xml");
                        RegistryLoader.this.loadAllPluginXmls(e, cl);
                    }
                    catch (IOException ex) {
                        if (!LoggingServices.debugEnabled) break block2;
                        LoggingServices.trace("Exception loading plugin descriptors: ", ex);
                    }
                }
                return null;
            }
        });
    }

    private void loadAllPluginXmls(Enumeration e, ClassLoader cl) {
        try {
            while (true) {
                URL url = (URL)e.nextElement();
                String urlKey = url.toExternalForm();
                URLConnection conn = null;
                try {
                    conn = url.openConnection();
                }
                catch (IOException ioe) {
                    continue;
                }
                this.loadPluginXml(url, cl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private boolean loadPluginXml(URL url, ClassLoader cl) {
        boolean success;
        block4: {
            success = false;
            String urlKey = url.toExternalForm();
            if (LoggingServices.debugEnabled) {
                LoggingServices.trace("Loading from ", urlKey);
            }
            try {
                InputSource is = new InputSource(url.openStream());
                is.setSystemId(urlKey);
                PluginDescriptor descriptor = this._parser.parsePlugin(is);
                if (descriptor != null) {
                    descriptor.setPluginClassLoader(cl);
                    descriptor.setInstallURL(url);
                    this._registry.addPlugin(descriptor);
                    success = true;
                }
            }
            catch (IOException ex) {
                if (!LoggingServices.debugEnabled) break block4;
                LoggingServices.trace("Exception parsing plugin descriptor: ", ex);
                ex.printStackTrace(LoggingServices.out);
            }
        }
        return success;
    }

    void releaseLoader() {
        this._parser.releaseParser();
        this._parser = null;
    }
}

